/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.favorites.actions;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.actions.AddBusinessToUDDIPerspectiveAction;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.actions.AddRegistryToUDDIPerspectiveAction;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.actions.AddServiceInterfaceToUDDIPerspectiveAction;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.actions.AddServiceToUDDIPerspectiveAction;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.actions.MultipleLinkAction;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesUDDIBusinessFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesUDDIRegistryFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesUDDIServiceFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesUDDIServiceInterfaceFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.OpenRegistryAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.CategoryModel;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.RegistryNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIMainNode;
import org.eclipse.wst.ws.internal.explorer.platform.util.URLUtils;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;

public abstract class AddToUDDIPerspectiveAction
extends MultipleLinkAction {
    public AddToUDDIPerspectiveAction(Controller controller) {
        super(controller);
    }

    public static String getActionLink(int nodeID, int toolID, int viewID, int viewToolID) {
        StringBuffer actionLink = new StringBuffer("favorites/actions/FavoritesAddToUDDIPerspectiveActionJSP.jsp?");
        actionLink.append("nodeId");
        actionLink.append('=');
        actionLink.append(nodeID);
        actionLink.append('&');
        actionLink.append("toolId");
        actionLink.append('=');
        actionLink.append(toolID);
        actionLink.append('&');
        actionLink.append("viewId");
        actionLink.append('=');
        actionLink.append(viewID);
        actionLink.append('&');
        actionLink.append("viewToolId");
        actionLink.append('=');
        actionLink.append(viewToolID);
        return actionLink.toString();
    }

    public static String getBaseActionLink() {
        return "favorites/actions/FavoritesAddToUDDIPerspectiveActionJSP.jsp";
    }

    protected boolean createRegistryInUDDIPerspective(String inquiryAPI, String publishAPI, String registryName, String registrationURL, boolean useExisting) {
        Vector registryNodes = this.getRegistryNodesByInquiryURL(inquiryAPI);
        if (registryNodes != null && useExisting) {
            Node registryNode = (Node)registryNodes.elementAt(0);
            NodeManager nodeManager = registryNode.getNodeManager();
            nodeManager.setSelectedNodeId(registryNode.getNodeId());
            return true;
        }
        OpenRegistryAction openRegAction = new OpenRegistryAction(this.controller_);
        Hashtable propertyTable = openRegAction.getPropertyTable();
        if (!Validator.validateString(registryName)) {
            return false;
        }
        propertyTable.put("registryName", registryName);
        if (!Validator.validateURL(inquiryAPI)) {
            return false;
        }
        propertyTable.put("inquiryURL", inquiryAPI);
        if (Validator.validateURL(publishAPI)) {
            propertyTable.put("publishURL", publishAPI);
        }
        if (Validator.validateURL(registrationURL)) {
            propertyTable.put("registrationURL", registrationURL);
        }
        StringBuffer directoryBuffer = new StringBuffer();
        FavoritesUDDIRegistryFolderElement.formCategoriesDirectory(directoryBuffer, this.controller_.getServletEngineStateLocation(), registryName);
        File categoriesDirectory = new File(directoryBuffer.toString());
        File[] categoryFiles = null;
        if (categoriesDirectory.exists() && (categoryFiles = categoriesDirectory.listFiles()).length > 0) {
            propertyTable.put("checkUserDefinedCategories", Boolean.TRUE);
        }
        if (!openRegAction.run()) {
            return false;
        }
        if (categoryFiles != null && categoryFiles.length > 0) {
            RegistryElement regElement = (RegistryElement)this.controller_.getUDDIPerspective().getNavigatorManager().getSelectedNode().getTreeElement();
            regElement.setCheckForUserDefinedCategories(true);
            regElement.getUserDefinedCategories();
            this.linkCategoryModelsWithSavedData(registryName, regElement.getUserDefinedCategories());
        }
        return true;
    }

    public final void linkCategoryModelsWithSavedData(String registryName, Enumeration userDefinedCategories) {
        StringBuffer directoryBuffer = new StringBuffer();
        FavoritesUDDIRegistryFolderElement.formCategoriesDirectory(directoryBuffer, this.controller_.getServletEngineStateLocation(), registryName);
        this.linkCategoryModelsWithSavedData(userDefinedCategories, directoryBuffer.toString());
    }

    public final void linkCategoryModelsWithSavedData(Enumeration userDefinedCategories, String categoriesDirectory) {
        File categoriesDirectoryFile = new File(categoriesDirectory);
        File[] categoryFiles = null;
        if (categoriesDirectoryFile.exists()) {
            categoryFiles = categoriesDirectoryFile.listFiles();
            if (userDefinedCategories != null) {
                block0: while (userDefinedCategories.hasMoreElements()) {
                    CategoryModel categoryModel = (CategoryModel)((Object)userDefinedCategories.nextElement());
                    String categoryKey = categoryModel.getCategoryKey();
                    int i = 0;
                    while (i < categoryFiles.length) {
                        String categoryPropertiesFileName = categoryFiles[i].getName();
                        int lastDotPos = categoryPropertiesFileName.lastIndexOf(".");
                        String decodedCategoryPropertiesFileNameBase = URLUtils.decode(categoryPropertiesFileName.substring(0, lastDotPos));
                        if (lastDotPos > 0 && categoryPropertiesFileName.endsWith(".properties") && categoryKey.equals(decodedCategoryPropertiesFileNameBase)) {
                            categoryModel.setDefaultDataFile(categoryFiles[i].getAbsolutePath());
                            categoryModel.loadFromDelimiterFile();
                            continue block0;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    protected Vector getRegistryNodesByInquiryURL(String inquiryURL) {
        Vector<Node> registryNodes = null;
        NodeManager navigatorManager = this.controller_.getUDDIPerspective().getNavigatorManager();
        UDDIMainNode uddiMainNode = (UDDIMainNode)navigatorManager.getRootNode();
        Vector childNodes = uddiMainNode.getChildNodes();
        int i = 0;
        while (i < childNodes.size()) {
            RegistryElement regElement;
            String currInquiryURL;
            Node childNode = (Node)childNodes.elementAt(i);
            if (childNode instanceof RegistryNode && (currInquiryURL = (regElement = (RegistryElement)childNode.getTreeElement()).getInquiryURL()) != null && currInquiryURL.equals(inquiryURL)) {
                if (registryNodes == null) {
                    registryNodes = new Vector<Node>();
                }
                registryNodes.addElement(childNode);
            }
            ++i;
        }
        return registryNodes;
    }

    public static AddToUDDIPerspectiveAction newAction(Controller controller) {
        TreeElement selectedElement = controller.getFavoritesPerspective().getNodeManager().getSelectedNode().getTreeElement();
        FavoritesFolderElement favoritesFolderElement = null;
        if (selectedElement instanceof FavoritesFolderElement) {
            favoritesFolderElement = (FavoritesFolderElement)selectedElement;
        } else if (selectedElement instanceof FavoritesElement) {
            favoritesFolderElement = ((FavoritesElement)selectedElement).getParentFolderElement();
        } else {
            return null;
        }
        if (favoritesFolderElement instanceof FavoritesUDDIRegistryFolderElement) {
            return new AddRegistryToUDDIPerspectiveAction(controller);
        }
        if (favoritesFolderElement instanceof FavoritesUDDIBusinessFolderElement) {
            return new AddBusinessToUDDIPerspectiveAction(controller);
        }
        if (favoritesFolderElement instanceof FavoritesUDDIServiceFolderElement) {
            return new AddServiceToUDDIPerspectiveAction(controller);
        }
        if (favoritesFolderElement instanceof FavoritesUDDIServiceInterfaceFolderElement) {
            return new AddServiceInterfaceToUDDIPerspectiveAction(controller);
        }
        return null;
    }
}

