/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.server.internal.ui.dialogs.ConnectedServerDialog;
import org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup.AbstractAction;
import org.eclipse.wst.rdb.server.internal.ui.util.ServerUIDebugOptions;
import org.eclipse.wst.rdb.server.internal.ui.util.logging.Logger;

public class DisconnectServerAction
extends AbstractAction {
    private static ISelection selection;
    static /* synthetic */ Class class$0;

    private List removeNonConnectedServers(List servers) {
        int i = 0;
        while (i < servers.size()) {
            IConnectionNode server = (IConnectionNode)servers.get(i);
            if (!server.isConnected()) {
                servers.remove(i);
                --i;
            }
            ++i;
        }
        return servers;
    }

    protected void setSelection(ISelection sel) {
        selection = sel;
    }

    protected ISelection getSelection() {
        return selection;
    }

    private void disconnectServers(IConnectionNode[] nodes) {
        int i = 0;
        int n = nodes.length;
        while (i < n) {
            IConnectionNode node = nodes[i];
            ConnectionInfo info = node.getConnectionInfo();
            try {
                Connection connection = info.getSharedConnection();
                if (info.getSharedDatabase() != null) {
                    info.removeSharedDatabase();
                }
                if (info.getSharedConnection() != null) {
                    info.removeSharedConnection();
                    connection.close();
                }
            }
            catch (SQLException e1) {
                Logger.log(this, e1, ServerUIDebugOptions.SERVER_EXPLORER_LOG);
            }
            ++i;
        }
    }

    public void run(IAction action) {
        try {
            List servers;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!(servers = this.removeNonConnectedServers(this.getMultipleSelection(clazz))).isEmpty()) {
                this.disconnectServers(servers.toArray(new IConnectionNode[servers.size()]));
            } else {
                ConnectedServerDialog dialog = new ConnectedServerDialog();
                if (dialog.open() == 0) {
                    this.disconnectServers(dialog.getSelectedServers());
                }
            }
        }
        catch (AbstractAction.NullSelectionException e) {
            Logger.log(this, e, ServerUIDebugOptions.SERVER_EXPLORER_LOG);
        }
    }
}

