/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.componentcore.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.jdt.internal.integration.JavaProjectMigrationDataModelProvider;
import org.eclipse.jst.common.jdt.internal.integration.JavaProjectMigrationOperation;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsOp;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceComponentOperation;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.internal.util.ArtifactEditRegistryReader;
import org.eclipse.wst.common.componentcore.internal.util.IArtifactEditFactory;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IFlexibleProject;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class ComponentUtilities {
    public static String JAVA_NATURE = "org.eclipse.jdt.core.javanature";

    public static IPackageFragmentRoot[] getSourceContainers(IVirtualComponent vc) {
        ArrayList<IPackageFragmentRoot> list = new ArrayList<IPackageFragmentRoot>();
        IProject project = vc.getProject();
        IJavaProject jProject = JavaCore.create((IProject)project);
        try {
            IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IResource resource = roots[i].getResource();
                if (resource != null) {
                    IVirtualResource[] vResources = ComponentCore.createResources((IResource)resource);
                    boolean found = false;
                    int j = 0;
                    while (!found && j < vResources.length) {
                        if (vResources[j].getComponent().equals(vc)) {
                            list.add(roots[i]);
                            found = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        return list.toArray(new IPackageFragmentRoot[list.size()]);
    }

    public static void ensureContainerNotReadOnly(IResource resource) {
        IContainer container;
        if (resource != null && !resource.exists() && (container = resource.getParent()) != null) {
            ResourceAttributes attr = container.getResourceAttributes();
            if (!attr.isReadOnly()) {
                container = container.getParent();
            }
            attr.setReadOnly(false);
        }
    }

    public static IFolder createFolderInComponent(IVirtualComponent component, String folderName) throws CoreException {
        if (folderName != null) {
            IVirtualFolder rootfolder = component.getRootFolder();
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(new Path(rootfolder.getProject().getName()).append(folderName));
            if (!folder.exists()) {
                ProjectUtilities.ensureContainerNotReadOnly((IResource)folder);
                folder.create(true, true, null);
            }
            return folder;
        }
        return null;
    }

    public static ArtifactEdit getArtifactEditForRead(IVirtualComponent comp) {
        ArtifactEditRegistryReader reader = ArtifactEditRegistryReader.instance();
        if (comp != null) {
            IArtifactEditFactory factory = reader.getArtifactEdit(comp.getComponentTypeId());
            return factory.createArtifactEditForRead(comp);
        }
        return null;
    }

    public static IFile findFile(IVirtualComponent comp, IPath aPath) throws CoreException {
        IVirtualResource[] members = comp.getRootFolder().members();
        int i = 0;
        while (i < members.length) {
            IVirtualResource file;
            IVirtualResource resource = members[i];
            if (resource.getType() == 32 && (file = ((IVirtualContainer)resource).findMember(aPath)) != null) {
                return (IFile)file.getUnderlyingResource();
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IVirtualComponent findComponent(IProject project, Resource res) {
        WorkbenchComponent module;
        block8: {
            StructureEdit moduleCore = null;
            module = null;
            try {
                try {
                    moduleCore = StructureEdit.getStructureEditForRead((IProject)project);
                    URI uri = WorkbenchResourceHelperBase.getNonPlatformURI((URI)res.getURI());
                    IPath projPath = WorkbenchResourceHelper.getPathInProject((IProject)project, (IPath)new Path(uri.path()));
                    ComponentResource[] resources = moduleCore.findResourcesBySourcePath(projPath, 2);
                    int i = 0;
                    while (i < resources.length && (module = resources[i].getComponent()) == null) {
                        ++i;
                    }
                }
                catch (UnresolveableURIException unresolveableURIException) {}
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (moduleCore != null) {
                    moduleCore.dispose();
                }
                throw throwable;
            }
            {
                Object var8_10 = null;
                if (moduleCore == null) break block8;
            }
            moduleCore.dispose();
        }
        if (module == null) {
            return null;
        }
        return ComponentCore.createComponent((IProject)project, (String)module.getName());
    }

    /*
     * Exception decompiling
     */
    public static IVirtualComponent findComponent(IProject project, IResource res) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 83->86)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static IVirtualComponent[] getAllWorkbenchComponents() {
        ArrayList<IVirtualComponent> components = new ArrayList<IVirtualComponent>();
        List<IProject> projects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
        int i = 0;
        while (i < projects.size()) {
            IFlexibleProject flexProject = ComponentCore.createFlexibleProject((IProject)projects.get(i));
            IVirtualComponent[] wbComp = flexProject.getComponents();
            int j = 0;
            while (j < wbComp.length) {
                components.add(ComponentCore.createComponent((IProject)projects.get(i), (String)wbComp[j].getName()));
                ++j;
            }
            ++i;
        }
        VirtualComponent[] temp = components.toArray(new VirtualComponent[components.size()]);
        return temp;
    }

    public static IVirtualComponent[] getComponentsForProject(IProject project) {
        IFlexibleProject flexProject = ComponentCore.createFlexibleProject((IProject)project);
        return flexProject.getComponents();
    }

    public static IVirtualComponent[] getComponent(String componentName) {
        IVirtualComponent[] allComponents = ComponentUtilities.getAllWorkbenchComponents();
        ArrayList<IVirtualComponent> matchingComponents = new ArrayList<IVirtualComponent>();
        int i = 0;
        while (i < allComponents.length) {
            if (allComponents[i].getName().equals(componentName)) {
                matchingComponents.add(allComponents[i]);
            }
            ++i;
        }
        VirtualComponent[] temp = matchingComponents.toArray(new VirtualComponent[matchingComponents.size()]);
        return temp;
    }

    public static ArtifactEdit getArtifactEditForWrite(IVirtualComponent comp) {
        ArtifactEditRegistryReader reader = ArtifactEditRegistryReader.instance();
        IArtifactEditFactory factory = reader.getArtifactEdit(comp.getComponentTypeId());
        return factory.createArtifactEditForWrite(comp);
    }

    public static IVirtualComponent findComponent(EObject anObject) {
        IProject project = ProjectUtilities.getProject((EObject)anObject);
        Resource res = anObject.eResource();
        return ComponentUtilities.findComponent(project, res);
    }

    public static IVirtualComponent findComponent(Resource aResource) {
        IProject project = ProjectUtilities.getProject((Resource)aResource);
        return ComponentUtilities.findComponent(project, aResource);
    }

    public static List getAllJavaNonFlexProjects() throws CoreException {
        ArrayList<IProject> nonFlexJavaProjects = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].hasNature(JAVA_NATURE) && !projects[i].hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                nonFlexJavaProjects.add(projects[i]);
            }
            ++i;
        }
        return nonFlexJavaProjects;
    }

    public static JavaProjectMigrationOperation createFlexJavaProjectForProjectOperation(IProject project) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new JavaProjectMigrationDataModelProvider());
        model.setProperty("IJavaProjectMigrationDataModelProperties.PROJECT_NAME", (Object)project.getName());
        return new JavaProjectMigrationOperation(model);
    }

    public static CreateReferenceComponentsOp createReferenceComponentOperation(ComponentHandle sourceComponentHandle, List targetComponentsHandles) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
        model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT_HANDLE", (Object)sourceComponentHandle);
        List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_HANDLE_LIST");
        modHandlesList.addAll(targetComponentsHandles);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_HANDLE_LIST", (Object)modHandlesList);
        return new CreateReferenceComponentsOp(model);
    }

    public static CreateReferenceComponentsOp createWLPReferenceComponentOperation(ComponentHandle sourceComponentHandle, List targetComponentsHandles) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
        model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT_HANDLE", (Object)sourceComponentHandle);
        List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_HANDLE_LIST");
        modHandlesList.addAll(targetComponentsHandles);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_HANDLE_LIST", (Object)modHandlesList);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)"/WEB-INF/lib");
        return new CreateReferenceComponentsOp(model);
    }

    public static RemoveReferenceComponentOperation removeReferenceComponentOperation(ComponentHandle sourceComponentHandle, List targetComponentsHandles) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new RemoveReferenceComponentsDataModelProvider());
        model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT_HANDLE", (Object)sourceComponentHandle);
        List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_HANDLE_LIST");
        modHandlesList.addAll(targetComponentsHandles);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_HANDLE_LIST", (Object)modHandlesList);
        return new RemoveReferenceComponentOperation(model);
    }

    public static IPath getResolvedPathForArchiveComponent(String name) {
        URI uri = URI.createURI((String)name);
        String resourceType = uri.segment(0);
        URI contenturi = ModuleURIUtil.trimToRelativePath((URI)uri, (int)1);
        String contentName = contenturi.toString();
        if (resourceType.equals("lib")) {
            return Path.fromOSString((String)contentName);
        }
        if (resourceType.equals("var")) {
            String classpathVar = contenturi.segment(0);
            URI remainingPathuri = ModuleURIUtil.trimToRelativePath((URI)contenturi, (int)1);
            String remainingPath = remainingPathuri.toString();
            String[] classpathvars = JavaCore.getClasspathVariableNames();
            boolean found = false;
            int i = 0;
            while (i < classpathvars.length) {
                if (classpathVar.equals(classpathvars[i])) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) {
                IPath path = JavaCore.getClasspathVariable((String)classpathVar);
                URI finaluri = URI.createURI((String)(String.valueOf(path.toOSString()) + '/' + remainingPath));
                return Path.fromOSString((String)finaluri.toString());
            }
        }
        return null;
    }

    public static IVirtualComponent[] getAllComponentsInWorkspaceOfType(String type) {
        ArrayList<IVirtualComponent> result = new ArrayList<IVirtualComponent>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IFlexibleProject project = ComponentCore.createFlexibleProject((IProject)projects[i]);
            result.addAll(Arrays.asList(project.getComponentsOfType(type)));
            ++i;
        }
        return result.toArray(new IVirtualComponent[result.size()]);
    }
}

