/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jst.common.navigator.internal.plugin.WTPNavigatorResourceHandler;
import org.eclipse.swt.widgets.Menu;

public class CompressedMenu
extends MenuManager {
    private String unit = null;
    private Map unitMap;
    private Map groupMap;
    private boolean compressGroups = false;

    public CompressedMenu() {
    }

    public CompressedMenu(String text) {
        super(text);
    }

    public CompressedMenu(String text, String id) {
        super(text, id);
    }

    public void openUnit(String unit1) {
        if (this.isUnitActive()) {
            throw new IllegalStateException(WTPNavigatorResourceHandler.getString("1_UI_", new Object[]{this.unit}));
        }
        this.unit = unit1;
    }

    public void closeUnit(String unit1) {
        if (!this.isUnitActive() || !this.unit.equals(unit1)) {
            throw new IllegalStateException(WTPNavigatorResourceHandler.getString("2_UI_", new Object[]{unit1, unit1}));
        }
        this.unit = null;
    }

    public void commit() {
        if (this.menusShouldBeCompressed()) {
            String key = null;
            Iterator keys = this.getUnitMap().keySet().iterator();
            while (keys.hasNext()) {
                key = keys.next().toString();
                List list = this.getUnitList(key);
                if (list.size() < 2) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        super.add((IContributionItem)((ContributionItem)iterator.next()));
                    }
                    continue;
                }
                MenuManager submenu = new MenuManager(key, String.valueOf(key) + ".id");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    submenu.add((IContributionItem)((ContributionItem)iterator.next()));
                }
                super.add((IContributionItem)submenu);
            }
            this.getUnitMap().clear();
        } else {
            Iterator keys = this.getUnitMap().keySet().iterator();
            while (keys.hasNext()) {
                List list = this.getUnitList(keys.next().toString());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    super.add((IContributionItem)((ContributionItem)iterator.next()));
                }
            }
        }
    }

    private boolean menusShouldBeCompressed() {
        int count = 0;
        if (this.getUnitMap().size() < 2) {
            return false;
        }
        Iterator unitKeys = this.getUnitMap().keySet().iterator();
        while (unitKeys.hasNext()) {
            List unitList = this.getUnitList(unitKeys.next().toString());
            if ((count += unitList.size()) <= 5) continue;
            return true;
        }
        return false;
    }

    private boolean isUnitActive() {
        return this.unit != null;
    }

    public void add(IContributionItem item) {
        if (this.isUnitActive()) {
            this.getUnitList(this.unit).add(item);
        } else {
            super.add(item);
        }
    }

    public void fill(Menu parent, int index) {
        this.commit();
        IContributionItem[] items = this.getItems();
        int cnt = 0;
        int contributionIndex = 0;
        int i = 0;
        while (cnt < 2 && i < items.length) {
            if (items[i] instanceof ActionContributionItem || items[i] instanceof IContributionManager) {
                ++cnt;
                contributionIndex = i;
            }
            ++i;
        }
        if (cnt == 1) {
            items[contributionIndex].fill(parent, index);
        } else {
            super.fill(parent, index);
        }
    }

    protected List getUnitList(String name) {
        if (name == null) {
            throw new IllegalArgumentException(WTPNavigatorResourceHandler.getString("", new Object[]{name}));
        }
        ArrayList result = (ArrayList)this.getUnitMap().get(name);
        if (result == null) {
            result = new ArrayList();
            this.getUnitMap().put(name, result);
        }
        return result;
    }

    protected Map getUnitMap() {
        if (this.unitMap == null) {
            this.unitMap = new HashMap();
        }
        return this.unitMap;
    }

    protected List getGroupList(String name) {
        if (name == null) {
            throw new IllegalArgumentException(WTPNavigatorResourceHandler.getString("4_UI_", new Object[]{name}));
        }
        ArrayList result = (ArrayList)this.getGroupMap().get(name);
        if (result == null) {
            result = new ArrayList();
            this.getGroupMap().put(name, result);
        }
        return result;
    }

    protected Map getGroupMap() {
        if (this.groupMap == null) {
            this.groupMap = new HashMap();
        }
        return this.groupMap;
    }

    public void appendToGroup(String groupName, IContributionItem item) {
        if (this.compressGroups) {
            this.getGroupList(groupName).add(item);
        } else {
            super.appendToGroup(groupName, item);
        }
    }

    public boolean isCompressGroups() {
        return this.compressGroups;
    }

    public void setCompressGroups(boolean compressGroups) {
        this.compressGroups = compressGroups;
    }
}

