/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.navigator.internal.views.extensions.RegistryReader;

public class JavaResources {
    private static Map projectsMap;
    public final IProject parent;
    private static Image icon;

    static {
        icon = null;
    }

    private JavaResources(IProject parent) {
        this.parent = parent;
    }

    public static JavaResources getJavaResources(IProject project) {
        JavaResources javaResources = (JavaResources)JavaResources.getProjectsMap().get(project);
        if (javaResources == null) {
            javaResources = new JavaResources(project);
            JavaResources.getProjectsMap().put(project, javaResources);
        }
        return javaResources;
    }

    private static Map getProjectsMap() {
        if (projectsMap == null) {
            projectsMap = new HashMap();
        }
        return projectsMap;
    }

    public String getText() {
        return "Java Resources";
    }

    public Image getImage() {
        if (icon == null) {
            icon = JavaPluginImages.DESC_OBJS_PACKFRAG_ROOT.createImage();
        }
        return icon;
    }

    public static boolean isCompressed(IProject project) {
        return CompressedProjectsRegistryReader.getInstance().isCompressed(project);
    }

    private static class CompressedProjectsRegistryReader
    extends RegistryReader {
        public static final String COMPRESSED_PROJECT = "compressedProject";
        public static final String ATT_NATURE_ID = "natureId";
        private List compressedNatures;
        private static CompressedProjectsRegistryReader INSTANCE = null;

        public CompressedProjectsRegistryReader() {
            super("org.eclipse.jst.common.navigator.java", COMPRESSED_PROJECT);
        }

        public static CompressedProjectsRegistryReader getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new CompressedProjectsRegistryReader();
                INSTANCE.readRegistry();
            }
            return INSTANCE;
        }

        public boolean readElement(IConfigurationElement element) {
            if (COMPRESSED_PROJECT.equals(element.getName())) {
                this.getCompressedNatures().add(element.getAttribute(ATT_NATURE_ID));
            }
            return true;
        }

        private List getCompressedNatures() {
            if (this.compressedNatures == null) {
                this.compressedNatures = new ArrayList();
            }
            return this.compressedNatures;
        }

        public boolean isCompressed(IProject project) {
            if (this.compressedNatures == null) {
                return false;
            }
            try {
                int i = 0;
                while (i < this.compressedNatures.size()) {
                    if (project.hasNature((String)this.compressedNatures.get(i))) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
            return false;
        }
    }
}

