/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.java;

import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerProblemsDecorator;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jst.common.navigator.internal.java.PackageExplorerContentProvider;

class PackageExplorerLabelProvider
extends AppearanceAwareLabelProvider {
    private boolean fIsFlatLayout;
    private PackageExplorerProblemsDecorator fProblemDecorator = new PackageExplorerProblemsDecorator();
    private final PackageExplorerContentProvider contentProvider;

    PackageExplorerLabelProvider(long theTextFlags, int theImageFlags) {
        super(theTextFlags, theImageFlags);
        this.addLabelDecorator((ILabelDecorator)this.fProblemDecorator);
        this.contentProvider = new PackageExplorerContentProvider();
    }

    PackageExplorerLabelProvider(long theTextFlags, int theImageFlags, PackageExplorerContentProvider aContentProvider) {
        super(theTextFlags, theImageFlags);
        this.addLabelDecorator((ILabelDecorator)this.fProblemDecorator);
        this.contentProvider = aContentProvider;
    }

    public String getText(Object element) {
        if (this.fIsFlatLayout || !(element instanceof IPackageFragment)) {
            return super.getText(element);
        }
        IPackageFragment fragment = (IPackageFragment)element;
        if (fragment.isDefaultPackage()) {
            return super.getText((Object)fragment);
        }
        Object parent = this.contentProvider.getPackageFragmentProvider().getParent((Object)fragment);
        if (parent instanceof IPackageFragment) {
            return this.getNameDelta((IPackageFragment)parent, fragment);
        }
        return super.getText((Object)fragment);
    }

    private String getNameDelta(IPackageFragment topFragment, IPackageFragment bottomFragment) {
        String bottomName;
        String topName = topFragment.getElementName();
        if (topName.equals(bottomName = bottomFragment.getElementName())) {
            return topName;
        }
        String deltaname = bottomName.substring(topName.length() + 1);
        return deltaname;
    }

    void setIsFlatLayout(boolean state) {
        this.fIsFlatLayout = state;
        this.fProblemDecorator.setIsFlatLayout(state);
    }
}

