/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.java;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.IWorkingCopyProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class StandardJavaElementContentProvider
implements ITreeContentProvider,
IWorkingCopyProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers;
    protected boolean fProvideWorkingCopy;

    public StandardJavaElementContentProvider() {
        this(false);
    }

    public StandardJavaElementContentProvider(boolean provideMembers, boolean provideWorkingCopy) {
        this(provideMembers);
    }

    public StandardJavaElementContentProvider(boolean provideMembers) {
        this.fProvideMembers = provideMembers;
        this.fProvideWorkingCopy = provideMembers;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    public void setProvideMembers(boolean b) {
        this.fProvideMembers = b;
    }

    public boolean getProvideWorkingCopy() {
        return this.fProvideWorkingCopy;
    }

    public void setProvideWorkingCopy(boolean b) {
        this.fProvideWorkingCopy = b;
    }

    public boolean providesWorkingCopies() {
        return this.getProvideWorkingCopy();
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return NO_CHILDREN;
        }
        try {
            if (element instanceof IJavaModel) {
                return this.getJavaProjects((IJavaModel)element);
            }
            if (element instanceof IJavaProject) {
                return this.getPackageFragmentRoots((IJavaProject)element);
            }
            if (element instanceof IPackageFragmentRoot) {
                return this.getPackageFragments((IPackageFragmentRoot)element);
            }
            if (element instanceof IPackageFragment) {
                return this.getPackageContents((IPackageFragment)element);
            }
            if (this.getProvideMembers() && element instanceof ISourceReference && element instanceof IParent) {
                return ((IParent)element).getChildren();
            }
        }
        catch (JavaModelException javaModelException) {
            return NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    public boolean hasChildren(Object element) {
        Object[] children;
        IJavaProject jp;
        if (this.getProvideMembers()) {
            if (element instanceof ICompilationUnit || element instanceof IClassFile) {
                return true;
            }
        } else if (element instanceof ICompilationUnit || element instanceof IClassFile || element instanceof IFile) {
            return false;
        }
        if (element instanceof IJavaProject && !(jp = (IJavaProject)element).getProject().isOpen()) {
            return false;
        }
        if (element instanceof IParent) {
            try {
                if (((IParent)element).hasChildren()) {
                    return true;
                }
            }
            catch (JavaModelException javaModelException) {
                return true;
            }
        }
        return (children = this.getChildren(element)) != null && children.length > 0;
    }

    public Object getParent(Object element) {
        if (!this.exists(element)) {
            return null;
        }
        return this.internalGetParent(element);
    }

    private Object[] getPackageFragments(IPackageFragmentRoot root) throws JavaModelException {
        Object[] fragments = root.getChildren();
        Object[] nonJavaResources = root.getNonJavaResources();
        if (nonJavaResources == null) {
            return fragments;
        }
        return StandardJavaElementContentProvider.concatenate(fragments, nonJavaResources);
    }

    protected Object[] getPackageFragmentRoots(IJavaProject project) throws JavaModelException {
        if (!project.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        ArrayList<Object> list = new ArrayList<Object>(roots.length);
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (this.isProjectPackageFragmentRoot(root)) {
                IJavaElement[] children = root.getChildren();
                int k = 0;
                while (k < children.length) {
                    list.add(children[k]);
                    ++k;
                }
            } else if (this.hasChildren(root)) {
                list.add(root);
            }
            ++i;
        }
        return list.toArray();
    }

    protected Object[] getJavaProjects(IJavaModel jm) throws JavaModelException {
        return jm.getJavaProjects();
    }

    private Object[] getPackageContents(IPackageFragment fragment) throws JavaModelException {
        if (fragment.getKind() == 1) {
            return StandardJavaElementContentProvider.concatenate(fragment.getCompilationUnits(), fragment.getNonJavaResources());
        }
        return StandardJavaElementContentProvider.concatenate(fragment.getClassFiles(), fragment.getNonJavaResources());
    }

    protected boolean isClassPathChange(IJavaElementDelta delta) {
        if (delta.getElement().getElementType() != 3) {
            return false;
        }
        int flags = delta.getFlags();
        return delta.getKind() == 4 && (flags & 0x40) != 0 || (flags & 0x80) != 0 || (flags & 0x100) != 0;
    }

    protected Object skipProjectPackageFragmentRoot(IPackageFragmentRoot root) {
        if (this.isProjectPackageFragmentRoot(root)) {
            return root.getParent();
        }
        return root;
    }

    protected boolean isPackageFragmentEmpty(IJavaElement element) throws JavaModelException {
        IPackageFragment fragment;
        return element instanceof IPackageFragment && (fragment = (IPackageFragment)element).exists() && !fragment.hasChildren() && fragment.getNonJavaResources().length <= 0 && fragment.hasSubpackages();
    }

    protected boolean isProjectPackageFragmentRoot(IPackageFragmentRoot root) {
        IResource resource = root.getResource();
        return resource instanceof IProject;
    }

    protected boolean exists(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).exists();
        }
        return true;
    }

    protected Object internalGetParent(Object element) {
        if (element instanceof IResource) {
            IContainer parent = ((IResource)element).getParent();
            IJavaElement jParent = JavaCore.create((IResource)parent);
            if (jParent != null && jParent.exists()) {
                return jParent;
            }
            return parent;
        }
        if (element instanceof IJavaElement) {
            IJavaElement parent = ((IJavaElement)element).getParent();
            if (element instanceof IPackageFragment) {
                return this.skipProjectPackageFragmentRoot((IPackageFragmentRoot)parent);
            }
            return parent;
        }
        return null;
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }
}

