/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.workingsets.EditorTracker;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.PlatformUI;

public class HistoryWorkingSetUpdater
implements IWorkingSetUpdater {
    public static final String ID = "org.eclipse.jst.common.navigator.ui.HistoryWorkingSet";
    private IWorkingSet fWorkingSet;
    private Set fOpenFiles = new HashSet();
    private Tracker fTracker;
    private IElementChangedListener fJavaListener;
    private int fMaxElements = 15;

    public HistoryWorkingSetUpdater() {
        this.initListeners();
    }

    public void add(IWorkingSet workingSet) {
        Assert.isTrue((this.fWorkingSet == null ? 1 : 0) != 0);
        this.fWorkingSet = workingSet;
    }

    public boolean remove(IWorkingSet workingSet) {
        Assert.isTrue((this.fWorkingSet == workingSet ? 1 : 0) != 0);
        this.fWorkingSet = null;
        return true;
    }

    public boolean contains(IWorkingSet workingSet) {
        return this.fWorkingSet == workingSet;
    }

    public void dispose() {
        if (this.fTracker != null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.removeWindowListener((IWindowListener)this.fTracker);
            IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                windows[i].removePageListener((IPageListener)this.fTracker);
                IWorkbenchPage[] pages = windows[i].getPages();
                int j = 0;
                while (j < pages.length) {
                    pages[j].removePartListener((IPartListener)this.fTracker);
                    ++j;
                }
                ++i;
            }
            this.fTracker = null;
        }
        if (this.fJavaListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fJavaListener);
            this.fJavaListener = null;
        }
    }

    private void initListeners() {
        this.fTracker = new Tracker();
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.addWindowListener((IWindowListener)this.fTracker);
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            windows[i].addPageListener((IPageListener)this.fTracker);
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                pages[j].addPartListener((IPartListener)this.fTracker);
                ++j;
            }
            ++i;
        }
        this.fJavaListener = new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent event) {
                if (HistoryWorkingSetUpdater.this.fWorkingSet == null) {
                    return;
                }
                this.processDelta(event.getDelta());
            }

            public void processDelta(IJavaElementDelta delta) {
                int i;
                block9: {
                    int flags;
                    int kind;
                    int type;
                    IJavaElement element;
                    block7: {
                        block8: {
                            element = delta.getElement();
                            type = element.getElementType();
                            kind = delta.getKind();
                            flags = delta.getFlags();
                            if (type != 5) break block7;
                            if (kind != 4 || (flags & 0x40000) == 0) break block8;
                            HistoryWorkingSetUpdater.this.elementSaved((IAdaptable)element);
                            break block9;
                        }
                        if (kind != 2) break block9;
                        if ((delta.getFlags() & 0x20) != 0) {
                            HistoryWorkingSetUpdater.this.elementMoved((IAdaptable)element, (IAdaptable)delta.getMovedToElement());
                        } else {
                            HistoryWorkingSetUpdater.this.elementRemoved((IAdaptable)element);
                        }
                        break block9;
                    }
                    if (type == 2 && kind == 4 && (flags & 0x400) != 0) {
                        HistoryWorkingSetUpdater.this.projectClosed((IJavaProject)element);
                    } else {
                        IJavaElementDelta[] children = delta.getAffectedChildren();
                        i = 0;
                        while (i < children.length) {
                            this.processDelta(children[i]);
                            ++i;
                        }
                    }
                }
                IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
                if (resourceDeltas != null) {
                    i = 0;
                    while (i < resourceDeltas.length) {
                        this.processDelta(resourceDeltas[i]);
                        ++i;
                    }
                }
            }

            private void processDelta(IResourceDelta outerDelta) {
                try {
                    outerDelta.accept(new IResourceDeltaVisitor(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            IResource resource = delta.getResource();
                            if (resource.getType() != 1) {
                                return true;
                            }
                            IFile file = (IFile)resource;
                            if ((delta.getKind() & 4) != 0) {
                                if ((delta.getFlags() & 0x100) != 0) {
                                    HistoryWorkingSetUpdater.access$2(1.access$0(this.this$1), (IAdaptable)file);
                                }
                            } else if ((delta.getKind() & 2) != 0) {
                                if ((delta.getFlags() & 0x2000) != 0) {
                                    IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                                    if (!newFile.exists()) {
                                        HistoryWorkingSetUpdater.access$4(1.access$0(this.this$1), (IAdaptable)file);
                                    } else {
                                        HistoryWorkingSetUpdater.access$3(1.access$0(this.this$1), (IAdaptable)file, (IAdaptable)newFile);
                                    }
                                } else {
                                    HistoryWorkingSetUpdater.access$4(1.access$0(this.this$1), (IAdaptable)file);
                                }
                            }
                            return false;
                        }
                    });
                }
                catch (CoreException coreException) {}
            }

            static /* synthetic */ HistoryWorkingSetUpdater access$0(1 var0) {
                return var0.HistoryWorkingSetUpdater.this;
            }
        };
        JavaCore.addElementChangedListener((IElementChangedListener)this.fJavaListener, (int)1);
    }

    private void elementSaved(IAdaptable element) {
        if (!this.fOpenFiles.contains(element)) {
            return;
        }
        this.updateHistory(element);
    }

    private void elementRemoved(IAdaptable element) {
        this.fOpenFiles.remove(element);
        List elements = this.getElements();
        if (elements.remove(element)) {
            this.setElements(elements);
        }
    }

    private void elementMoved(IAdaptable oldElement, IAdaptable newElement) {
        List elements = this.getElements();
        int index = elements.indexOf(oldElement);
        if (index == -1) {
            return;
        }
        elements.set(index, newElement);
        this.fOpenFiles.remove(oldElement);
        this.fOpenFiles.add(newElement);
        this.setElements(elements);
    }

    private void projectClosed(IJavaProject jProject) {
        IProject project = jProject.getProject();
        List elements = this.getElements();
        int removed = 0;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            IAdaptable element = (IAdaptable)iter.next();
            IProject container = this.getProject(element);
            if (!project.equals((Object)container)) continue;
            iter.remove();
            ++removed;
        }
        if (removed > 0) {
            this.setElements(elements);
        }
    }

    private IProject getProject(IAdaptable element) {
        if (element instanceof IResource) {
            return ((IResource)element).getProject();
        }
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getJavaProject().getProject();
        }
        return null;
    }

    private void updateHistory(IAdaptable element) {
        List elements = this.getElements();
        int index = elements.indexOf(element);
        if (index != -1) {
            elements.remove(index);
            elements.add(0, element);
        } else {
            if (elements.size() == this.fMaxElements) {
                elements.remove(elements.size() - 1);
            }
            elements.add(0, element);
        }
        this.setElements(elements);
    }

    private List getElements() {
        return new ArrayList<IAdaptable>(Arrays.asList(this.fWorkingSet.getElements()));
    }

    private void setElements(List elements) {
        this.fWorkingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
    }

    private class Tracker
    extends EditorTracker {
        Tracker() {
        }

        public void editorOpened(IEditorPart part) {
            IAdaptable file = this.getInput(part);
            if (file == null) {
                return;
            }
            HistoryWorkingSetUpdater.this.fOpenFiles.add(file);
        }

        public void editorClosed(IEditorPart part) {
            IAdaptable file = this.getInput(part);
            if (file == null) {
                return;
            }
            HistoryWorkingSetUpdater.this.fOpenFiles.remove(file);
        }

        private IAdaptable getInput(IEditorPart part) {
            IEditorInput input = part.getEditorInput();
            if (!(input instanceof IFileEditorInput)) {
                return null;
            }
            if (part instanceof CompilationUnitEditor) {
                return JavaCore.create((IFile)((IFileEditorInput)input).getFile());
            }
            return ((IFileEditorInput)input).getFile();
        }
    }
}

