/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.deferred;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.common.navigator.internal.views.NavigatorMessages;
import org.eclipse.wst.common.navigator.internal.views.deferred.IDeferredElementAdapter;
import org.eclipse.wst.common.navigator.internal.views.deferred.IPendingElementCollector;

public class FetchElementsJob
extends Job {
    private Object element = null;
    private IPendingElementCollector elementCollector = null;
    private IDeferredElementAdapter[] deferredAdapters = null;
    static /* synthetic */ Class class$0;

    public FetchElementsJob(Object element, IPendingElementCollector elementCollector, IDeferredElementAdapter[] deferredAdapters) {
        this("Fetching children of {0}", element, elementCollector, deferredAdapters);
    }

    public FetchElementsJob(String name, Object element, IPendingElementCollector elementCollector, IDeferredElementAdapter[] deferredAdapters) {
        super(name);
        this.element = element;
        this.elementCollector = elementCollector;
        this.deferredAdapters = deferredAdapters;
    }

    public IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(NavigatorMessages.getString("FetchElementsJob.0"), this.deferredAdapters.length);
        Object[] children = null;
        int i = 0;
        while (i < this.deferredAdapters.length) {
            children = this.deferredAdapters[i].getChildren(this.element);
            if (children != null && children.length != 0) {
                this.elementCollector.collectChildren(this.element, children);
            }
            monitor.worked(1);
            ++i;
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object ancestor) {
        return this.isParent(ancestor, this.element);
    }

    private boolean isParent(Object family, Object child) {
        if (family.equals(child)) {
            return true;
        }
        IWorkbenchAdapter workbenchAdapter = this.getWorkbenchAdapter(child);
        if (workbenchAdapter == null) {
            return false;
        }
        Object elementParent = workbenchAdapter.getParent(child);
        if (elementParent == null) {
            return false;
        }
        return this.isParent(family, elementParent);
    }

    private IWorkbenchAdapter getWorkbenchAdapter(Object elementArg) {
        Object workbenchAdapter;
        if (elementArg instanceof IWorkbenchAdapter) {
            return (IWorkbenchAdapter)elementArg;
        }
        if (!(elementArg instanceof IAdaptable)) {
            return null;
        }
        IAdaptable iAdaptable = (IAdaptable)elementArg;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((workbenchAdapter = iAdaptable.getAdapter((Class)clazz)) == null) {
            return null;
        }
        return (IWorkbenchAdapter)workbenchAdapter;
    }
}

