/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.dnd;

import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonDropActionDelegate;
import org.eclipse.wst.common.navigator.internal.views.NavigatorMessages;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.dnd.IDropValidator;
import org.eclipse.wst.common.navigator.internal.views.dnd.SerializerCollectionDescriptor;

public class DropHandlerDescriptor {
    private String name;
    private String description;
    private String id = null;
    private IConfigurationElement configurationElement;
    private ActionExpression dragEnablement;
    private ActionExpression dropEnablement;
    private SerializerCollectionDescriptor serializers;
    private IConfigurationElement dropEnablementConfigElement;
    private IDropValidator dropValidator;

    public DropHandlerDescriptor(IConfigurationElement aConfigurationElement) {
        Assert.isLegal((boolean)"dropHandler".equals(aConfigurationElement.getName()));
        this.configurationElement = aConfigurationElement;
        this.init();
    }

    private void init() {
        IConfigurationElement[] serializersChild;
        IConfigurationElement[] dropEnablementChildren;
        this.id = this.configurationElement.getAttribute("id");
        this.name = this.configurationElement.getAttribute("name");
        this.description = this.configurationElement.getAttribute("description");
        IConfigurationElement[] dragEnablementChildren = this.configurationElement.getChildren("dragEnablement");
        if (dragEnablementChildren.length > 0 && dragEnablementChildren[0] != null) {
            this.dragEnablement = new ActionExpression(dragEnablementChildren[0]);
        }
        if ((dropEnablementChildren = this.configurationElement.getChildren("dropEnablement")).length > 0 && dropEnablementChildren[0] != null) {
            this.dropEnablementConfigElement = dropEnablementChildren[0];
            this.dropEnablement = new ActionExpression(dropEnablementChildren[0]);
        }
        if ((serializersChild = this.configurationElement.getChildren("serializers")).length > 0 && serializersChild[0] != null) {
            this.serializers = new SerializerCollectionDescriptor(this.id, serializersChild[0], this.dragEnablement);
        }
    }

    public boolean isDragEnabledFor(Object element) {
        if (this.dragEnablement != null) {
            return this.dragEnablement.isEnabledFor(element);
        }
        return true;
    }

    public boolean isDropEnabledFor(Object element) {
        if (this.dropEnablement != null) {
            return this.dropEnablement.isEnabledFor(element);
        }
        return false;
    }

    protected IDropValidator getDropValidator() {
        if (this.dropValidator == null) {
            try {
                String classValue = this.dropEnablementConfigElement.getAttribute("validatorClass");
                if (classValue != null && classValue.length() > 0) {
                    this.dropValidator = (IDropValidator)this.dropEnablementConfigElement.createExecutableExtension("validatorClass");
                }
            }
            catch (CoreException coreException) {}
        }
        return this.dropValidator;
    }

    public SerializerCollectionDescriptor getSerializersDescriptor() {
        return this.serializers;
    }

    public String getId() {
        return this.id;
    }

    protected ICommonDropActionDelegate createAction() {
        try {
            return (ICommonDropActionDelegate)this.configurationElement.createExecutableExtension("class");
        }
        catch (CoreException e) {
            String msg = NavigatorMessages.format("DropHandlerDescriptor.10", new Object[]{this.getId()});
            NavigatorPlugin.log(msg, e.getStatus());
            return null;
        }
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public String getName() {
        return this.name != null ? this.name : this.id;
    }

    public static interface ExtensionPointElements {
        public static final String DROP_HANDLER = "dropHandler";
        public static final String ATT_ID = "id";
        public static final String ATT_CLASS = "class";
        public static final String ATT_VALIDATOR_CLASS = "validatorClass";
        public static final String DRAG_ENABLEMENT = "dragEnablement";
        public static final String DROP_ENABLEMENT = "dropEnablement";
        public static final String SERIALIZERS = "serializers";
        public static final String SERIALIZER = "serializer";
        public static final String NAME = "name";
        public static final String DESCRIPTION = "description";
    }
}

