/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.extensions;

import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonNavigator;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonOpenListener;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.extensions.INavigatorContentServiceListener;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorInstance;
import org.eclipse.wst.common.navigator.internal.views.extensions.SkeletonOpenListener;

public class CommonOpenService
implements IOpenListener,
INavigatorContentServiceListener {
    private NavigatorContentService contentService;
    private CommonNavigator commonNavigator;

    public CommonOpenService(NavigatorContentService aContentService, CommonNavigator aCommonNavigator) {
        this.contentService = aContentService;
        this.commonNavigator = aCommonNavigator;
        this.init();
    }

    private void init() {
        this.contentService.addListener(this);
    }

    public void open(OpenEvent anEvent) {
        ISelection selection = anEvent.getSelection();
        if (selection instanceof IStructuredSelection) {
            NavigatorContentDescriptorInstance[] contentDescriptorInstances = this.contentService.findRelevantContentDescriptorInstances((IStructuredSelection)selection);
            NavigatorContentDescriptorInstance contentDescriptorInstance = null;
            int x = 0;
            while (x < contentDescriptorInstances.length) {
                contentDescriptorInstance = contentDescriptorInstances[x];
                contentDescriptorInstance.getOpenListener().open(anEvent);
                ++x;
            }
        }
    }

    public void dispose() {
        this.contentService.removeListener(this);
    }

    public void onLoad(NavigatorContentDescriptorInstance aDescriptorInstance) {
        try {
            this.initialize(aDescriptorInstance.getOpenListener());
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
    }

    private void initialize(ICommonOpenListener anOpenListener) {
        if (anOpenListener != null && anOpenListener != SkeletonOpenListener.INSTANCE) {
            anOpenListener.initialize(this.commonNavigator, this.contentService);
        }
    }
}

