/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.java;

import org.eclipse.jem.java.impl.URL;

public class JavaURL
extends URL {
    public static final String JAVA_PROTOCOL_URI_PREFIX = "java:/";

    public JavaURL(String urlString) {
        super(urlString);
    }

    public JavaURL(String nameSpaceName, String iD) {
        super(null, null);
        this.initializeNamespaceString(nameSpaceName);
        this.ID = iD;
    }

    public String getClassName() {
        return this.ID;
    }

    public String getFullString() {
        StringBuffer buf = new StringBuffer();
        if (this.namespaceName != null) {
            buf.append(this.namespaceName);
            if (this.ID != null) {
                buf.append("#");
            }
        }
        if (this.ID != null) {
            buf.append(this.ID);
        }
        return buf.toString();
    }

    public String getPackageName() {
        String internalName = this.namespaceName.substring(JAVA_PROTOCOL_URI_PREFIX.length(), this.namespaceName.length());
        return "_-javaprim".equals(internalName) ? "" : internalName;
    }

    public void initializeFromString(String url) {
        if (url.indexOf("#") != -1) {
            super.initializeFromString(url);
        } else {
            int endOfPackageName = url.lastIndexOf(46);
            if (endOfPackageName == -1) {
                this.initializeNamespaceString(null);
            } else {
                this.initializeNamespaceString(url.substring(0, endOfPackageName));
            }
            this.ID = url.substring(endOfPackageName + 1);
        }
    }

    public void initializeNamespaceString(String aNamespaceName) {
        this.namespaceName = aNamespaceName == null ? JAVA_PROTOCOL_URI_PREFIX : JAVA_PROTOCOL_URI_PREFIX + aNamespaceName;
    }

    public static boolean isJavaURL(String aUrlString) {
        if (aUrlString == null) {
            return false;
        }
        return aUrlString.startsWith(JAVA_PROTOCOL_URI_PREFIX);
    }

    public String toString() {
        return "URL(" + this.getFullString() + ")";
    }
}

