/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.java.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jem.internal.java.instantiation.IInstantiationInstance;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaDataType;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.JavaRefPackage;

public class JavaDataTypeImpl
extends EClassImpl
implements JavaDataType {
    static final String FALSE = "false";
    static final String DOUBLE_ZERO = "0.0";
    static final String FLOAT_ZERO = "0.0f";
    static final String CHAR_ZERO = "'0'";
    static final String ZERO = "0";
    private int primitive_type = 0;
    static /* synthetic */ Class class$0;

    protected JavaDataTypeImpl() {
    }

    protected EClass eStaticClass() {
        return JavaRefPackage.eINSTANCE.getJavaDataType();
    }

    public String getDefaultValueString() {
        String typeName = this.getJavaName();
        if (typeName.equals("boolean")) {
            return FALSE;
        }
        if (typeName.equals("double")) {
            return DOUBLE_ZERO;
        }
        if (typeName.equals("float")) {
            return FLOAT_ZERO;
        }
        if (typeName.equals("char")) {
            return CHAR_ZERO;
        }
        return ZERO;
    }

    public String getJavaName() {
        return this.getName();
    }

    public JavaDataType getPrimitive() {
        return this;
    }

    public int getPrimitiveID() {
        if (this.primitive_type == 0) {
            String name = this.getName();
            if (name.equals("boolean")) {
                this.primitive_type = 1;
            }
            if (name.equals("char")) {
                this.primitive_type = 2;
            }
            if (name.equals("byte")) {
                this.primitive_type = 3;
            }
            if (name.equals("short")) {
                this.primitive_type = 8;
            }
            if (name.equals("int")) {
                this.primitive_type = 6;
            }
            if (name.equals("long")) {
                this.primitive_type = 7;
            }
            if (name.equals("float")) {
                this.primitive_type = 5;
            }
            if (name.equals("double")) {
                this.primitive_type = 4;
            }
        }
        return this.primitive_type;
    }

    public String getSimpleName() {
        return this.getName();
    }

    public String getQualifiedName() {
        return this.getJavaName();
    }

    public JavaClass getWrapper() {
        String wrapperName = this.getWrapperQualifiedName();
        if (wrapperName != null) {
            return (JavaClass)JavaRefFactory.eINSTANCE.reflectType(wrapperName, (EObject)this);
        }
        return null;
    }

    protected String getWrapperQualifiedName() {
        switch (this.getPrimitiveID()) {
            case 6: {
                return "java.lang.Integer";
            }
            case 2: {
                return "java.lang.Character";
            }
            case 1: {
                return "java.lang.Boolean";
            }
            case 3: {
                return "java.lang.Byte";
            }
            case 8: {
                return "java.lang.Short";
            }
            case 7: {
                return "java.lang.Long";
            }
            case 5: {
                return "java.lang.Float";
            }
            case 4: {
                return "java.lang.Double";
            }
        }
        return null;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isAssignableFrom(EClassifier aClass) {
        return this == aClass;
    }

    public boolean isInstance(Object o) {
        return o instanceof IInstantiationInstance ? this.isAssignableFrom((EClassifier)((IInstantiationInstance)o).getJavaType()) : false;
    }

    public boolean isPrimitive() {
        return true;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicAdd((Object)otherEnd, msgs);
                }
                case 5: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 5, msgs);
                }
                case 9: {
                    return ((InternalEList)this.getEOperations()).basicAdd((Object)otherEnd, msgs);
                }
                case 19: {
                    return ((InternalEList)this.getEStructuralFeatures()).basicAdd((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicRemove((Object)otherEnd, msgs);
                }
                case 5: {
                    return this.eBasicSetContainer(null, 5, msgs);
                }
                case 9: {
                    return ((InternalEList)this.getEOperations()).basicRemove((Object)otherEnd, msgs);
                }
                case 19: {
                    return ((InternalEList)this.getEStructuralFeatures()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        block6: {
            if (this.eContainerFeatureID < 0) break block6;
            switch (this.eContainerFeatureID) {
                case 5: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.emf.ecore.EPackage");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return this.eContainer.eInverseRemove((InternalEObject)this, 5, (Class)clazz, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getInstanceClassName();
            }
            case 3: {
                return this.getInstanceClass();
            }
            case 4: {
                return this.getDefaultValue();
            }
            case 5: {
                return this.getEPackage();
            }
            case 6: {
                return this.isAbstract() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return this.isInterface() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return this.getESuperTypes();
            }
            case 9: {
                return this.getEOperations();
            }
            case 10: {
                return this.getEAllAttributes();
            }
            case 11: {
                return this.getEAllReferences();
            }
            case 12: {
                return this.getEReferences();
            }
            case 13: {
                return this.getEAttributes();
            }
            case 14: {
                return this.getEAllContainments();
            }
            case 15: {
                return this.getEAllOperations();
            }
            case 16: {
                return this.getEAllStructuralFeatures();
            }
            case 17: {
                return this.getEAllSuperTypes();
            }
            case 18: {
                return this.getEIDAttribute();
            }
            case 19: {
                return this.getEStructuralFeatures();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setInstanceClassName((String)newValue);
                return;
            }
            case 6: {
                this.setAbstract((Boolean)newValue);
                return;
            }
            case 7: {
                this.setInterface((Boolean)newValue);
                return;
            }
            case 8: {
                this.getESuperTypes().clear();
                this.getESuperTypes().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getEOperations().clear();
                this.getEOperations().addAll((Collection)newValue);
                return;
            }
            case 19: {
                this.getEStructuralFeatures().clear();
                this.getEStructuralFeatures().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setInstanceClassName(INSTANCE_CLASS_NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setAbstract(false);
                return;
            }
            case 7: {
                this.setInterface(false);
                return;
            }
            case 8: {
                this.getESuperTypes().clear();
                return;
            }
            case 9: {
                this.getEOperations().clear();
                return;
            }
            case 19: {
                this.getEStructuralFeatures().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.eAnnotations != null && !this.eAnnotations.isEmpty();
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return INSTANCE_CLASS_NAME_EDEFAULT == null ? this.instanceClassName != null : !INSTANCE_CLASS_NAME_EDEFAULT.equals(this.instanceClassName);
            }
            case 3: {
                return INSTANCE_CLASS_EDEFAULT == null ? this.getInstanceClass() != null : !INSTANCE_CLASS_EDEFAULT.equals(this.getInstanceClass());
            }
            case 4: {
                return DEFAULT_VALUE_EDEFAULT == null ? this.getDefaultValue() != null : !DEFAULT_VALUE_EDEFAULT.equals(this.getDefaultValue());
            }
            case 5: {
                return this.getEPackage() != null;
            }
            case 6: {
                return (this.eFlags & 0x100) != 0;
            }
            case 7: {
                return (this.eFlags & 0x200) != 0;
            }
            case 8: {
                return this.eSuperTypes != null && !this.eSuperTypes.isEmpty();
            }
            case 9: {
                return this.eOperations != null && !this.eOperations.isEmpty();
            }
            case 10: {
                return !this.getEAllAttributes().isEmpty();
            }
            case 11: {
                return !this.getEAllReferences().isEmpty();
            }
            case 12: {
                return !this.getEReferences().isEmpty();
            }
            case 13: {
                return !this.getEAttributes().isEmpty();
            }
            case 14: {
                return !this.getEAllContainments().isEmpty();
            }
            case 15: {
                return !this.getEAllOperations().isEmpty();
            }
            case 16: {
                return !this.getEAllStructuralFeatures().isEmpty();
            }
            case 17: {
                return !this.getEAllSuperTypes().isEmpty();
            }
            case 18: {
                return this.getEIDAttribute() != null;
            }
            case 19: {
                return this.eStructuralFeatures != null && !this.eStructuralFeatures.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String getQualifiedNameForReflection() {
        return this.getJavaName();
    }
}

