/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.widgets.skeleton;

import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;

public class SkeletonConfigWidgetDefaultingCommand
extends SimpleCommand {
    private String wsdlURI;
    private IProject serverProject;
    private JavaWSDLParameter javaWSDLParam;
    private String moduleName_;

    public SkeletonConfigWidgetDefaultingCommand(String moduleName) {
        this.moduleName_ = moduleName;
    }

    public Status execute(Environment env) {
        String root = this.getRootURL();
        this.javaWSDLParam.setOutput(String.valueOf(root) + this.getOutputWSDLFolder());
        this.javaWSDLParam.setJavaOutput(String.valueOf(root) + this.getOutputJavaFolder());
        return new SimpleStatus("");
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public void setServerProject(String serverProject) {
        this.serverProject = ResourcesPlugin.getWorkspace().getRoot().getProject(serverProject);
    }

    public String getEndpointURI() {
        return null;
    }

    public String getOutputWSDLFolder() {
        IPath wsdlPath = J2EEUtils.getWebContentPath((IProject)this.serverProject, (String)this.moduleName_).append("wsdl");
        return wsdlPath.toString();
    }

    public String getOutputWSDLFile() {
        int index = this.wsdlURI.lastIndexOf(47);
        if (index == -1) {
            index = this.wsdlURI.lastIndexOf(92);
        }
        return this.wsdlURI.substring(index + 1, this.wsdlURI.length());
    }

    public String getOutputJavaFolder() {
        if (this.serverProject != null) {
            return ResourceUtils.getJavaSourceLocation((IProject)this.serverProject, (String)this.moduleName_).toString();
        }
        return null;
    }

    public boolean getShowMapping() {
        return false;
    }

    public boolean isShowMapping() {
        return this.getShowMapping();
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    private String getRootURL() {
        String rootURL = ResourcesPlugin.getWorkspace().getRoot().getLocation().removeTrailingSeparator().toString();
        File file = new File(rootURL);
        try {
            rootURL = file.toURL().toString();
            char lastChar = rootURL.charAt(rootURL.length() - 1);
            if (lastChar == '/' || lastChar == '\\') {
                rootURL = rootURL.substring(0, rootURL.length() - 1);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return rootURL;
    }
}

