/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.ILiveHelpAction;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.appserver.WebappManager;
import org.eclipse.help.internal.base.BookmarkManager;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.base.HelpDisplay;
import org.eclipse.help.internal.base.util.IErrorUtil;
import org.eclipse.help.internal.browser.BrowserManager;
import org.eclipse.help.internal.search.SearchManager;
import org.eclipse.help.internal.workingset.WorkingSetManager;
import org.osgi.framework.Bundle;

public final class BaseHelpSystem {
    protected static final BaseHelpSystem instance = new BaseHelpSystem();
    private static final String WEBAPP_EXTENSION_ID = "org.eclipse.help.base.webapp";
    private static final String WEBAPP_DEFAULT_ATTRIBUTE = "default";
    public static final String BOOKMARKS = "bookmarks";
    public static final String WORKING_SETS = "workingSets";
    public static final String WORKING_SET = "workingSet";
    public static final int MODE_WORKBENCH = 0;
    public static final int MODE_INFOCENTER = 1;
    public static final int MODE_STANDALONE = 2;
    protected SearchManager searchManager;
    protected WorkingSetManager workingSetManager;
    protected BookmarkManager bookmarkManager;
    private int mode = 0;
    private boolean webappStarted = false;
    private IErrorUtil defaultErrorMessenger;
    private IBrowser browser;
    private IBrowser internalBrowser;
    private HelpDisplay helpDisplay = null;
    private boolean webappRunning = false;
    private boolean rtl = BaseHelpSystem.initializeRTL();
    static /* synthetic */ Class class$0;

    private BaseHelpSystem() {
    }

    public static BaseHelpSystem getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchManager getSearchManager() {
        if (BaseHelpSystem.getInstance().searchManager != null) return BaseHelpSystem.getInstance().searchManager;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.help.internal.base.BaseHelpSystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (BaseHelpSystem.getInstance().searchManager != null) return BaseHelpSystem.getInstance().searchManager;
            BaseHelpSystem.getInstance().searchManager = new SearchManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return BaseHelpSystem.getInstance().searchManager;
        }
    }

    public static synchronized WorkingSetManager getWorkingSetManager() {
        if (BaseHelpSystem.getInstance().workingSetManager == null) {
            BaseHelpSystem.getInstance().workingSetManager = new WorkingSetManager();
        }
        return BaseHelpSystem.getInstance().workingSetManager;
    }

    public static synchronized BookmarkManager getBookmarkManager() {
        if (BaseHelpSystem.getInstance().bookmarkManager == null) {
            BaseHelpSystem.getInstance().bookmarkManager = new BookmarkManager();
        }
        return BaseHelpSystem.getInstance().bookmarkManager;
    }

    public synchronized void setBrowserInstance(IBrowser browser) {
        this.browser = browser;
    }

    public static synchronized IBrowser getHelpBrowser(boolean forceExternal) {
        if (!forceExternal && !BrowserManager.getInstance().isAlwaysUseExternal()) {
            if (BaseHelpSystem.getInstance().internalBrowser == null) {
                BaseHelpSystem.getInstance().internalBrowser = BrowserManager.getInstance().createBrowser(false);
            }
            return BaseHelpSystem.getInstance().internalBrowser;
        }
        if (BaseHelpSystem.getInstance().browser == null) {
            BaseHelpSystem.getInstance().browser = BrowserManager.getInstance().createBrowser(true);
        }
        return BaseHelpSystem.getInstance().browser;
    }

    public static synchronized HelpDisplay getHelpDisplay() {
        if (BaseHelpSystem.getInstance().helpDisplay == null) {
            BaseHelpSystem.getInstance().helpDisplay = new HelpDisplay();
        }
        return BaseHelpSystem.getInstance().helpDisplay;
    }

    public BaseHelpSystem newInstance() {
        return null;
    }

    public static void shutdown() throws CoreException {
        if (HelpBasePlugin.DEBUG) {
            System.out.println("Base Help System is shutting down.");
        }
        if (BaseHelpSystem.getInstance().bookmarkManager != null) {
            BaseHelpSystem.getInstance().bookmarkManager.close();
            BaseHelpSystem.getInstance().bookmarkManager = null;
        }
        if (BaseHelpSystem.getInstance().searchManager != null) {
            BaseHelpSystem.getInstance().searchManager.close();
            BaseHelpSystem.getInstance().searchManager = null;
        }
        if (BaseHelpSystem.getInstance().webappStarted) {
            WebappManager.stop((String)"help");
            if (BaseHelpSystem.getMode() != 0) {
                WebappManager.stop((String)"helpControl");
            }
        }
        if (HelpBasePlugin.DEBUG) {
            System.out.println("Help System is shut down.");
        }
    }

    public static void startup() {
        try {
            BaseHelpSystem.setDefaultErrorUtil(new IErrorUtil(){

                public void displayError(String msg) {
                    System.out.println(msg);
                }

                public void displayError(String msg, Thread uiThread) {
                    System.out.println(msg);
                }
            });
            HelpBasePlugin.getDefault().getPluginPreferences();
        }
        catch (Exception e) {
            HelpBasePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.help.base", 0, "Error in launching help.", (Throwable)e));
        }
        if (HelpBasePlugin.DEBUG) {
            System.out.println("Base Help System started.");
        }
    }

    public static boolean ensureWebappRunning() {
        if (!BaseHelpSystem.getInstance().webappStarted) {
            BaseHelpSystem.getInstance().webappStarted = true;
            String webappPlugin = BaseHelpSystem.getWebappPlugin();
            if (BaseHelpSystem.getMode() != 0) {
                try {
                    WebappManager.start((String)"helpControl", (String)webappPlugin, (IPath)Path.EMPTY);
                }
                catch (CoreException e) {
                    HelpBasePlugin.logError("Stand-alone help control web application failed to run.", e);
                    return false;
                }
            }
            try {
                WebappManager.start((String)"help", (String)webappPlugin, (IPath)Path.EMPTY);
            }
            catch (CoreException e) {
                HelpBasePlugin.logError("The embedded application server could not run help web application.", e);
                BaseHelpSystem.getDefaultErrorUtil().displayError(HelpBaseResources.HelpWebappNotStarted);
                return false;
            }
            BaseHelpSystem.getInstance().webappRunning = true;
        }
        return BaseHelpSystem.getInstance().webappRunning;
    }

    public static URL resolve(String href, boolean documentOnly) {
        String url = null;
        if (href == null || href.indexOf("://") != -1) {
            url = href;
        } else {
            BaseHelpSystem.ensureWebappRunning();
            String base = BaseHelpSystem.getBase(documentOnly);
            url = href.startsWith("/") ? String.valueOf(base) + href : String.valueOf(base) + "/" + href;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URL resolve(String href, String servlet) {
        String url = null;
        if (href == null || href.indexOf("://") != -1) {
            url = href;
        } else {
            BaseHelpSystem.ensureWebappRunning();
            String base = BaseHelpSystem.getBase(servlet);
            url = href.startsWith("/") ? String.valueOf(base) + href : String.valueOf(base) + "/" + href;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String unresolve(URL url) {
        return BaseHelpSystem.unresolve(url.toString());
    }

    public static String unresolve(String href) {
        String[] baseVariants = new String[]{BaseHelpSystem.getBase("/help/topic"), BaseHelpSystem.getBase("/help/nftopic"), BaseHelpSystem.getBase("/help/ntopic")};
        int i = 0;
        while (i < baseVariants.length) {
            if (href.startsWith(baseVariants[i])) {
                return href.substring(baseVariants[i].length());
            }
            ++i;
        }
        return href;
    }

    private static String getBase(boolean documentOnly) {
        String servlet = documentOnly ? "/help/nftopic" : "/help/topic";
        return BaseHelpSystem.getBase(servlet);
    }

    private static String getBase(String servlet) {
        return "http://" + WebappManager.getHost() + ":" + WebappManager.getPort() + servlet;
    }

    public static int getMode() {
        return BaseHelpSystem.getInstance().mode;
    }

    public static void setMode(int mode) {
        BaseHelpSystem.getInstance().mode = mode;
    }

    public static void setDefaultErrorUtil(IErrorUtil em) {
        BaseHelpSystem.getInstance().defaultErrorMessenger = em;
    }

    public static IErrorUtil getDefaultErrorUtil() {
        return BaseHelpSystem.getInstance().defaultErrorMessenger;
    }

    private static String getWebappPlugin() {
        IExtension[] extensions;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(WEBAPP_EXTENSION_ID);
        if (point != null && (extensions = point.getExtensions()).length != 0) {
            IConfigurationElement[] elements = extensions[0].getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String defaultValue = elements[i].getAttribute(WEBAPP_DEFAULT_ATTRIBUTE);
                if (defaultValue == null || defaultValue.equals("false")) {
                    return elements[i].getNamespace();
                }
                ++i;
            }
            if (elements.length > 0) {
                return elements[0].getNamespace();
            }
        }
        return "org.eclipse.help.webapp";
    }

    public static String getProductName() {
        IProduct product = Platform.getProduct();
        if (product == null) {
            return "";
        }
        String name = product.getName();
        return name == null ? "" : name;
    }

    private static boolean initializeRTL() {
        String orientation = System.getProperty("eclipse.orientation");
        if ("rtl".equals(orientation)) {
            return true;
        }
        if ("ltr".equals(orientation)) {
            return false;
        }
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length) {
            if ("-dir".equalsIgnoreCase(args[i])) {
                return i + 1 < args.length && "rtl".equalsIgnoreCase(args[i + 1]);
            }
            ++i;
        }
        if (System.getProperty("osgi.nl.user") == null) {
            return false;
        }
        String locale = Platform.getNL();
        if (locale == null) {
            locale = Locale.getDefault().toString();
        }
        return locale.startsWith("ar") || locale.startsWith("fa") || locale.startsWith("he") || locale.startsWith("iw") || locale.startsWith("ur");
    }

    public static boolean isRTL() {
        return BaseHelpSystem.getInstance().rtl;
    }

    public static void runLiveHelp(String pluginID, String className, String arg) {
        Bundle bundle = Platform.getBundle((String)pluginID);
        if (bundle == null) {
            return;
        }
        try {
            Class c = bundle.loadClass(className);
            Object o = c.newInstance();
            if (o != null && o instanceof ILiveHelpAction) {
                ILiveHelpAction helpExt = (ILiveHelpAction)o;
                if (arg != null) {
                    helpExt.setInitializationString(arg);
                }
                Thread runnableLiveHelp = new Thread((Runnable)helpExt);
                runnableLiveHelp.setDaemon(true);
                runnableLiveHelp.start();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Exception exception) {}
    }
}

