/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.internal.core.refactoring.Assert;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public class ParticipantDescriptor {
    private IConfigurationElement fConfigurationElement;
    private boolean fEnabled;
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String PROCESS_ON_CANCEL = "processOnCancel";

    public ParticipantDescriptor(IConfigurationElement element) {
        this.fConfigurationElement = element;
        this.fEnabled = true;
    }

    public String getId() {
        return this.fConfigurationElement.getAttribute(ID);
    }

    public String getName() {
        return this.fConfigurationElement.getAttribute(NAME);
    }

    public IStatus checkSyntax() {
        if (this.fConfigurationElement.getAttribute(ID) == null) {
            return new Status(4, RefactoringCorePlugin.getPluginId(), 4, RefactoringCoreMessages.ParticipantDescriptor_error_id_missing, null);
        }
        if (this.fConfigurationElement.getAttribute(NAME) == null) {
            return new Status(4, RefactoringCorePlugin.getPluginId(), 4, Messages.format(RefactoringCoreMessages.ParticipantDescriptor_error_name_missing, this.getId()), null);
        }
        if (this.fConfigurationElement.getAttribute(CLASS) == null) {
            return new Status(4, RefactoringCorePlugin.getPluginId(), 4, Messages.format(RefactoringCoreMessages.ParticipantDescriptor_error_class_missing, this.getId()), null);
        }
        return new Status(0, RefactoringCorePlugin.getPluginId(), 0, RefactoringCoreMessages.ParticipantDescriptor_correct, null);
    }

    public boolean matches(IEvaluationContext context) throws CoreException {
        IConfigurationElement[] elements = this.fConfigurationElement.getChildren("enablement");
        if (elements.length == 0) {
            return false;
        }
        Assert.isTrue(elements.length == 1);
        Expression exp = ExpressionConverter.getDefault().perform(elements[0]);
        return this.convert(exp.evaluate(context));
    }

    public RefactoringParticipant createParticipant() throws CoreException {
        return (RefactoringParticipant)((Object)this.fConfigurationElement.createExecutableExtension(CLASS));
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void disable() {
        this.fEnabled = false;
    }

    public boolean processOnCancel() {
        String attr = this.fConfigurationElement.getAttribute(PROCESS_ON_CANCEL);
        if (attr == null) {
            return false;
        }
        return Boolean.valueOf(attr);
    }

    private boolean convert(EvaluationResult eval) {
        return eval != EvaluationResult.FALSE;
    }
}

