/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.debug.ui.CodeSnippetCompletionProcessor;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.DetailFormatter;
import org.eclipse.jdt.internal.debug.ui.ExceptionHandler;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.AbstractHandler;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.commands.Priority;
import org.eclipse.ui.dialogs.SelectionDialog;

public class DetailFormatterDialog
extends StatusDialog
implements CodeSnippetCompletionProcessor.ITypeProvider {
    private DetailFormatter fDetailFormatter;
    private Text fTypeNameText;
    private JDISourceViewer fSnippetViewer;
    private Button fCheckBox;
    private boolean fTypeSearched;
    private boolean fEditTypeName;
    private IType fType;
    private List fDefinedTypes;
    private HandlerSubmission submission;

    public DetailFormatterDialog(Shell parent, DetailFormatter detailFormatter, List definedTypes, boolean editDialog) {
        this(parent, detailFormatter, definedTypes, true, editDialog);
    }

    public DetailFormatterDialog(Shell parent, DetailFormatter detailFormatter, List definedTypes, boolean editTypeName, boolean editDialog) {
        super(parent);
        this.fDetailFormatter = detailFormatter;
        this.fTypeSearched = false;
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        if (editDialog) {
            this.setTitle(DebugUIMessages.DetailFormatterDialog_Edit_Detail_Formatter_1);
        } else {
            this.setTitle(DebugUIMessages.DetailFormatterDialog_Add_Detail_Formatter_2);
        }
        this.fEditTypeName = editTypeName;
        this.fDefinedTypes = definedTypes;
    }

    protected Control createDialogArea(Composite parent) {
        List keyBindings;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IJavaDebugHelpContextIds.EDIT_DETAIL_FORMATTER_DIALOG);
        Font font = parent.getFont();
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(Map parameterValuesByName) throws ExecutionException {
                DetailFormatterDialog.this.findCorrespondingType();
                DetailFormatterDialog.this.fSnippetViewer.doOperation(13);
                return null;
            }
        };
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchCommandSupport commandSupport = workbench.getCommandSupport();
        this.submission = new HandlerSubmission(null, parent.getShell(), null, "org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)handler, Priority.MEDIUM);
        commandSupport.addHandlerSubmission(this.submission);
        Composite container = (Composite)super.createDialogArea(parent);
        Label label = new Label(container, 0);
        label.setText(DebugUIMessages.DetailFormatterDialog_Qualified_type__name__2);
        GridData gd = new GridData(1);
        label.setLayoutData((Object)gd);
        label.setFont(font);
        Composite innerContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        innerContainer.setLayout((Layout)layout);
        gd = new GridData(768);
        innerContainer.setLayoutData((Object)gd);
        this.fTypeNameText = new Text(innerContainer, 2052);
        this.fTypeNameText.setEditable(this.fEditTypeName);
        this.fTypeNameText.setText(this.fDetailFormatter.getTypeName());
        gd = new GridData(768);
        this.fTypeNameText.setLayoutData((Object)gd);
        this.fTypeNameText.setFont(font);
        this.fTypeNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DetailFormatterDialog.this.fTypeSearched = false;
                DetailFormatterDialog.this.checkValues();
            }
        });
        Button typeSearchButton = new Button(innerContainer, 8);
        typeSearchButton.setText(DebugUIMessages.DetailFormatterDialog_Select__type_4);
        this.setButtonLayoutData(typeSearchButton);
        gd = (GridData)typeSearchButton.getLayoutData();
        gd.horizontalAlignment = 3;
        typeSearchButton.setEnabled(this.fEditTypeName);
        typeSearchButton.setLayoutData((Object)gd);
        typeSearchButton.setFont(font);
        typeSearchButton.setEnabled(this.fEditTypeName);
        typeSearchButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                DetailFormatterDialog.this.selectType();
            }
        });
        String labelText = null;
        ICommandManager commandManager = PlatformUI.getWorkbench().getCommandSupport().getCommandManager();
        ICommand command = commandManager.getCommand("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (command != null && (keyBindings = command.getKeySequenceBindings()) != null && keyBindings.size() > 0) {
            IKeySequenceBinding binding = (IKeySequenceBinding)keyBindings.get(0);
            labelText = MessageFormat.format(DebugUIMessages.DetailFormatterDialog_17, binding.getKeySequence().format());
        }
        if (labelText == null) {
            labelText = DebugUIMessages.DetailFormatterDialog_Detail_formatter__code_snippet__1;
        }
        label = new Label(container, 0);
        label.setText(labelText);
        gd = new GridData(1);
        label.setLayoutData((Object)gd);
        label.setFont(font);
        this.fSnippetViewer = new JDISourceViewer(container, null, 2816);
        this.fSnippetViewer.setInput(this);
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        Document document = new Document();
        IDocumentPartitioner partitioner = tools.createDocumentPartitioner();
        document.setDocumentPartitioner(partitioner);
        partitioner.connect((IDocument)document);
        this.fSnippetViewer.configure((SourceViewerConfiguration)new DisplayViewerConfiguration(){

            public IContentAssistProcessor getContentAssistantProcessor() {
                return new CodeSnippetCompletionProcessor(DetailFormatterDialog.this);
            }
        });
        this.fSnippetViewer.setEditable(true);
        this.fSnippetViewer.setDocument((IDocument)document);
        Control control = this.fSnippetViewer.getControl();
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        control.setLayoutData((Object)gd);
        document.set(this.fDetailFormatter.getSnippet());
        this.fSnippetViewer.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                DetailFormatterDialog.this.checkValues();
            }
        });
        if (this.fDetailFormatter.getTypeName().length() > 0) {
            this.fSnippetViewer.getControl().setFocus();
        }
        this.fCheckBox = new Button(container, 16416);
        this.fCheckBox.setText(DebugUIMessages.DetailFormatterDialog__Enable_1);
        this.fCheckBox.setSelection(this.fDetailFormatter.isEnabled());
        this.fCheckBox.setFont(font);
        this.checkValues();
        return container;
    }

    private void checkValues() {
        StatusInfo status = new StatusInfo();
        String typeName = this.fTypeNameText.getText().trim();
        if (typeName.length() == 0) {
            status.setError(DebugUIMessages.DetailFormatterDialog_Qualified_type_name_must_not_be_empty__3);
        } else if (this.fDefinedTypes != null && this.fDefinedTypes.contains(typeName)) {
            status.setError(DebugUIMessages.DetailFormatterDialog_A_detail_formatter_is_already_defined_for_this_type_2);
        } else if (this.fSnippetViewer.getDocument().get().trim().length() == 0) {
            status.setError(DebugUIMessages.DetailFormatterDialog_Associated_code_must_not_be_empty_3);
        } else if (this.fType == null && this.fTypeSearched) {
            status.setWarning(DebugUIMessages.No_type_with_the_given_name_found_in_the_workspace__1);
        }
        this.updateStatus((IStatus)status);
    }

    protected void okPressed() {
        this.fDetailFormatter.setEnabled(this.fCheckBox.getSelection());
        this.fDetailFormatter.setTypeName(this.fTypeNameText.getText().trim());
        this.fDetailFormatter.setSnippet(this.fSnippetViewer.getDocument().get());
        super.okPressed();
    }

    private void selectType() {
        Shell shell = this.getShell();
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)256, (boolean)false, (String)this.fTypeNameText.getText());
        }
        catch (JavaModelException jme) {
            String title = DebugUIMessages.DetailFormatterDialog_Select_type_6;
            String message = DebugUIMessages.DetailFormatterDialog_Could_not_open_type_selection_dialog_for_detail_formatters_7;
            ExceptionHandler.handle((CoreException)((Object)jme), title, message);
            return;
        }
        dialog.setTitle(DebugUIMessages.DetailFormatterDialog_Select_type_8);
        dialog.setMessage(DebugUIMessages.DetailFormatterDialog_Select_a_type_to_format_when_displaying_its_detail_9);
        if (dialog.open() == 1) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            this.fType = (IType)types[0];
            this.fTypeNameText.setText(this.fType.getFullyQualifiedName());
            this.fTypeSearched = true;
        }
    }

    private void findCorrespondingType() {
        if (this.fTypeSearched) {
            return;
        }
        this.fType = null;
        this.fTypeSearched = true;
        String pattern = this.fTypeNameText.getText().trim().replace('$', '.');
        if (pattern == null || "".equals(pattern)) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        SearchRequestor collector = new SearchRequestor((IProgressMonitor)monitor){
            private boolean fFirst = true;
            private final /* synthetic */ IProgressMonitor val$monitor;
            {
                this.val$monitor = iProgressMonitor;
            }

            public void endReporting() {
                DetailFormatterDialog.this.checkValues();
            }

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object enclosingElement = match.getElement();
                if (!this.fFirst) {
                    return;
                }
                this.fFirst = false;
                if (enclosingElement instanceof IType) {
                    DetailFormatterDialog.this.fType = (IType)enclosingElement;
                }
                this.val$monitor.setCanceled(true);
            }
        };
        SearchEngine engine = new SearchEngine(JavaCore.getWorkingCopies(null));
        SearchPattern searchPattern = SearchPattern.createPattern((String)pattern, (int)0, (int)0, (int)8);
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        try {
            engine.search(searchPattern, participants, scope, collector, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    public IType getType() {
        if (!this.fTypeSearched) {
            this.findCorrespondingType();
        }
        return this.fType;
    }

    public boolean close() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchCommandSupport commandSupport = workbench.getCommandSupport();
        commandSupport.removeHandlerSubmission(this.submission);
        this.fSnippetViewer.dispose();
        return super.close();
    }
}

