/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.debug.ui.JavaUISourceLocator;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.AddAdvancedAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddExternalFolderAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddExternalJarAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddFolderAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddJarAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddLibraryAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddProjectAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddVariableAction;
import org.eclipse.jdt.internal.debug.ui.actions.AttachSourceAction;
import org.eclipse.jdt.internal.debug.ui.actions.MoveDownAction;
import org.eclipse.jdt.internal.debug.ui.actions.MoveUpAction;
import org.eclipse.jdt.internal.debug.ui.actions.RemoveAction;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaLaunchConfigurationTab;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.RuntimeClasspathViewer;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SourceLookupBlock
extends JavaLaunchConfigurationTab
implements ILaunchConfigurationTab {
    protected ILaunchConfiguration fConfig;
    protected RuntimeClasspathViewer fPathViewer;
    protected Button fDefaultButton;
    protected Button fDuplicatesButton;
    protected static final String DIALOG_SETTINGS_PREFIX = "SourceLookupBlock";

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        Label viewerLabel = new Label(comp, 16384);
        viewerLabel.setText(LauncherMessages.SourceLookupBlock__Source_Lookup_Path__1);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        viewerLabel.setLayoutData((Object)gd);
        viewerLabel.setFont(font);
        this.fPathViewer = new RuntimeClasspathViewer(comp);
        this.fPathViewer.addEntriesChangedListener(this);
        gd = new GridData(1808);
        this.fPathViewer.getControl().setLayoutData((Object)gd);
        this.fPathViewer.getControl().setFont(font);
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.createVerticalSpacer(comp, 2);
        this.fDefaultButton = new Button(comp, 32);
        this.fDefaultButton.setText(LauncherMessages.SourceLookupBlock_Use_defau_lt_source_lookup_path_1);
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.fDefaultButton.setLayoutData((Object)gd);
        this.fDefaultButton.setFont(font);
        this.fDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SourceLookupBlock.this.handleDefaultButtonSelected();
            }
        });
        this.fDuplicatesButton = new Button(comp, 32);
        this.fDuplicatesButton.setText(LauncherMessages.SourceLookupBlock__Search_for_duplicate_source_files_on_path_1);
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.fDuplicatesButton.setLayoutData((Object)gd);
        this.fDuplicatesButton.setFont(font);
        this.fDuplicatesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SourceLookupBlock.this.setDirty(true);
                SourceLookupBlock.this.updateLaunchConfigurationDialog();
            }
        });
        ArrayList<RuntimeClasspathAction> advancedActions = new ArrayList<RuntimeClasspathAction>(5);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        RuntimeClasspathAction action = new MoveUpAction(this.fPathViewer);
        Button button = this.createPushButton(pathButtonComp, action.getText(), fontMetrics);
        action.setButton(button);
        action = new MoveDownAction(this.fPathViewer);
        button = this.createPushButton(pathButtonComp, action.getText(), fontMetrics);
        action.setButton(button);
        action = new RemoveAction(this.fPathViewer);
        button = this.createPushButton(pathButtonComp, action.getText(), fontMetrics);
        action.setButton(button);
        action = new AddProjectAction(this.fPathViewer);
        button = this.createPushButton(pathButtonComp, action.getText(), fontMetrics);
        action.setButton(button);
        action = new AddJarAction(this.fPathViewer);
        button = this.createPushButton(pathButtonComp, action.getText(), fontMetrics);
        action.setButton(button);
        action = new AddExternalJarAction(this.fPathViewer, DIALOG_SETTINGS_PREFIX);
        button = this.createPushButton(pathButtonComp, action.getText(), fontMetrics);
        action.setButton(button);
        action = new AddFolderAction(this.fPathViewer);
        advancedActions.add(action);
        action = new AddExternalFolderAction(this.fPathViewer, DIALOG_SETTINGS_PREFIX);
        advancedActions.add(action);
        action = new AddVariableAction(this.fPathViewer);
        advancedActions.add(action);
        action = new AddLibraryAction(null);
        advancedActions.add(action);
        action = new AttachSourceAction(this.fPathViewer, 16);
        advancedActions.add(action);
        IAction[] adv = advancedActions.toArray(new IAction[advancedActions.size()]);
        action = new AddAdvancedAction(this.fPathViewer, adv);
        button = this.createPushButton(pathButtonComp, action.getText(), fontMetrics);
        action.setButton(button);
        this.setControl((Control)comp);
    }

    protected void handleDefaultButtonSelected() {
        this.setDirty(true);
        boolean def = this.fDefaultButton.getSelection();
        if (def) {
            try {
                ILaunchConfiguration config = this.getLaunchConfiguration();
                ILaunchConfigurationWorkingCopy wc = null;
                wc = config.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)config : config.getWorkingCopy();
                this.performApply(wc);
                IRuntimeClasspathEntry[] defs = JavaRuntime.computeUnresolvedSourceLookupPath((ILaunchConfiguration)wc);
                this.fPathViewer.setEntries(defs);
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        this.fPathViewer.setEnabled(!def);
        this.updateLaunchConfigurationDialog();
    }

    protected Button createPushButton(Composite parent, String label, FontMetrics fontMetrics) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        GridData gd = this.getButtonGridData(button, fontMetrics);
        button.setLayoutData((Object)gd);
        return button;
    }

    private GridData getButtonGridData(Button button, FontMetrics fontMetrics) {
        GridData gd = new GridData(770);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        gd.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        return gd;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        boolean useDefault = true;
        this.setErrorMessage(null);
        try {
            useDefault = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_SOURCE_PATH, true);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        if (config == this.getLaunchConfiguration() && !useDefault && !this.fDefaultButton.getSelection()) {
            this.setDirty(false);
            return;
        }
        this.setLaunchConfiguration(config);
        this.fDefaultButton.setSelection(useDefault);
        try {
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedSourceLookupPath((ILaunchConfiguration)config);
            this.fPathViewer.setEntries(entries);
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
        this.fPathViewer.setEnabled(!useDefault);
        this.fPathViewer.setLaunchConfiguration(config);
        try {
            this.fDuplicatesButton.setSelection(config.getAttribute(JavaUISourceLocator.ATTR_FIND_ALL_SOURCE_ELEMENTS, false));
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        this.setDirty(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isDirty()) {
            boolean def = this.fDefaultButton.getSelection();
            if (def) {
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_SOURCE_PATH, null);
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH, null);
            } else {
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_SOURCE_PATH, def);
                try {
                    IRuntimeClasspathEntry[] entries = this.fPathViewer.getEntries();
                    ArrayList<String> mementos = new ArrayList<String>(entries.length);
                    int i = 0;
                    while (i < entries.length) {
                        mementos.add(entries[i].getMemento());
                        ++i;
                    }
                    configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH, mementos);
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.errorDialog(LauncherMessages.SourceLookupBlock_Unable_to_save_source_lookup_path_1, e);
                }
            }
            boolean dup = this.fDuplicatesButton.getSelection();
            if (dup) {
                configuration.setAttribute(JavaUISourceLocator.ATTR_FIND_ALL_SOURCE_ELEMENTS, true);
            } else {
                configuration.setAttribute(JavaUISourceLocator.ATTR_FIND_ALL_SOURCE_ELEMENTS, null);
            }
        }
    }

    public IRuntimeClasspathEntry[] getEntries() {
        return this.fPathViewer.getEntries();
    }

    private void setLaunchConfiguration(ILaunchConfiguration configuration) {
        this.fConfig = configuration;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fConfig;
    }

    public String getName() {
        return LauncherMessages.SourceLookupBlock_Source_1;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_SOURCE_PATH, null);
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH, null);
        configuration.setAttribute(JavaUISourceLocator.ATTR_FIND_ALL_SOURCE_ELEMENTS, null);
    }

    protected void updateLaunchConfigurationDialog() {
        if (this.getLaunchConfigurationDialog() != null) {
            super.updateLaunchConfigurationDialog();
        }
    }

    public void dispose() {
        this.fPathViewer.removeEntriesChangedListener(this);
        super.dispose();
    }
}

