/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.enablement;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.internal.WTPResourceHandler;
import org.eclipse.wst.common.frameworks.internal.enablement.FunctionGroupPatternBinding;
import org.eclipse.wst.common.frameworks.internal.enablement.IGroupInitializer;
import org.eclipse.wst.common.frameworks.internal.enablement.Util;

public class FunctionGroup
implements Comparable {
    public static final String GROUP_NAME_ATTR = "name";
    public static final String GROUP_DESC_ATTR = "description";
    public static final String GROUP_ENABLED_BY_DEFAULT_ATTR = "enabledByDefault";
    public static final String GROUP_PRIORITY_ATTR = "priority";
    public static final String GROUP_INTIALIZER_CLASS_ATTR = "initializerClassName";
    private static final int NEGATIVE_PRIORITY = -1;
    private String groupID;
    private String name;
    private String description;
    private String intializerClassName;
    private String declaringExtension;
    private int priority = -1;
    private IConfigurationElement element;
    private IGroupInitializer groupInterface;
    private Set functionGroupPatternBindings;
    private transient FunctionGroupPatternBinding[] functionGroupPatternBindingsAsArray;
    private boolean errorReported = false;
    static /* synthetic */ Class class$0;

    public FunctionGroup(String groupID, IConfigurationElement element) {
        this.groupID = groupID;
        this.element = element;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.element.getAttribute(GROUP_DESC_ATTR);
        }
        return this.description;
    }

    String getInitalizerClassName() {
        if (this.intializerClassName == null) {
            this.intializerClassName = this.element.getAttribute(GROUP_INTIALIZER_CLASS_ATTR);
        }
        return this.intializerClassName;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.element.getAttribute(GROUP_NAME_ATTR);
        }
        return this.name;
    }

    private String getDeclaringExtensionName() {
        if (this.declaringExtension == null) {
            if (this.element.getDeclaringExtension() == null) {
                return "";
            }
            this.declaringExtension = this.element.getDeclaringExtension().toString();
        }
        return this.declaringExtension;
    }

    public String getGroupID() {
        return this.groupID;
    }

    IGroupInitializer getInitializerClass() {
        if (this.groupInterface == null) {
            try {
                this.groupInterface = (IGroupInitializer)this.element.createExecutableExtension(GROUP_INTIALIZER_CLASS_ATTR);
            }
            catch (CoreException e) {
                Logger.getLogger().logError(String.valueOf(WTPResourceHandler.getString("29", new Object[]{GROUP_INTIALIZER_CLASS_ATTR, this.getInitalizerClassName(), this.getDeclaringExtensionName()})) + "\r\n");
                Logger.getLogger().logError((Throwable)e);
            }
        }
        return this.groupInterface;
    }

    public String toString() {
        return "\"" + this.getName() + "\" (" + this.getGroupID() + ")";
    }

    public int getPriority() {
        if (this.priority == -1) {
            this.priority = Integer.parseInt(this.element.getAttribute(GROUP_PRIORITY_ATTR));
        }
        return this.priority;
    }

    public boolean isEnabled(IProject project) {
        if (this.getInitializerClass() != null) {
            return this.getInitializerClass().isGroupEnabled(project);
        }
        return false;
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        if (!(o instanceof FunctionGroup)) {
            return 1;
        }
        FunctionGroup group = (FunctionGroup)o;
        if (this.getPriority() == group.getPriority()) {
            return this.getGroupID().compareTo(group.getGroupID());
        }
        if (this.getPriority() < group.getPriority()) {
            return -1;
        }
        return 1;
    }

    public boolean isMatch(String string) {
        if (this.functionGroupPatternBindings == null) {
            if (!this.errorReported) {
                Logger.getLogger().logError(WTPResourceHandler.getString("30", new Object[]{this.getGroupID()}));
                this.errorReported = true;
            }
            return false;
        }
        Iterator iterator = this.functionGroupPatternBindings.iterator();
        while (iterator.hasNext()) {
            FunctionGroupPatternBinding functionGroupPatternBinding = (FunctionGroupPatternBinding)iterator.next();
            if (!functionGroupPatternBinding.getPattern().matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    boolean setFunctionGroupPatternBindings(Set functionGroupPatternBindings) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.frameworks.internal.enablement.FunctionGroupPatternBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Util.equals(functionGroupPatternBindings = Util.safeCopy(functionGroupPatternBindings, (Class)clazz), this.functionGroupPatternBindings)) {
            this.functionGroupPatternBindings = functionGroupPatternBindings;
            this.functionGroupPatternBindingsAsArray = this.functionGroupPatternBindings.toArray(new FunctionGroupPatternBinding[this.functionGroupPatternBindings.size()]);
            return true;
        }
        return false;
    }
}

