/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.internal.util.emf.workbench.nls.EMFWorkbenchResourceHandler;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.IEditModelHandler;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;
import org.eclipse.wst.common.internal.emfworkbench.edit.EditModelRegistry;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;
import org.eclipse.wst.common.internal.emfworkbench.integration.IEditModelFactory;

public class ArtifactEdit
implements IEditModelHandler,
IAdaptable {
    public static final Class ADAPTER_TYPE;
    private final ArtifactEditModel artifactEditModel;
    private boolean isReadOnly;
    private boolean isArtifactEditModelSelfManaged;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.componentcore.ArtifactEdit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ADAPTER_TYPE = clazz;
    }

    protected ArtifactEdit() {
        this.artifactEditModel = null;
    }

    public static ArtifactEdit getArtifactEditForRead(IVirtualComponent aModule) {
        if (ArtifactEdit.isValidEditableModule(aModule)) {
            IProject project = aModule.getProject();
            ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature(project);
            return new ArtifactEdit(nature, aModule, true);
        }
        return null;
    }

    public static ArtifactEdit getArtifactEditForWrite(IVirtualComponent aModule) {
        if (ArtifactEdit.isValidEditableModule(aModule)) {
            IProject project = aModule.getProject();
            ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature(project);
            return new ArtifactEdit(nature, aModule, false);
        }
        return null;
    }

    public static ArtifactEdit getArtifactEditForRead(ComponentHandle aHandle) {
        ArtifactEdit artifactEdit = null;
        try {
            artifactEdit = new ArtifactEdit(aHandle, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static ArtifactEdit getArtifactEditForWrite(ComponentHandle aHandle) {
        ArtifactEdit artifactEdit = null;
        try {
            artifactEdit = new ArtifactEdit(aHandle, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static boolean isValidEditableModule(IVirtualComponent aModule) {
        if (aModule.getComponentTypeId() == null) {
            return false;
        }
        if (ModuleURIUtil.fullyQualifyURI(aModule.getProject(), aModule.getName()) == null) {
            return false;
        }
        IProject project = aModule.getProject();
        if (project == null || !project.isAccessible()) {
            return false;
        }
        IEditModelFactory factory = EditModelRegistry.getInstance().findEditModelFactoryByKey((Object)aModule.getComponentTypeId());
        return factory != null;
    }

    public ArtifactEdit(ArtifactEditModel anArtifactEditModel) {
        this.artifactEditModel = anArtifactEditModel;
        this.isReadOnly = this.artifactEditModel.isReadOnly();
        this.isArtifactEditModelSelfManaged = false;
    }

    public ArtifactEdit(ModuleCoreNature aNature, IVirtualComponent aModule, boolean toAccessAsReadOnly) {
        this.artifactEditModel = toAccessAsReadOnly ? aNature.getArtifactEditModelForRead(ModuleURIUtil.fullyQualifyURI(aModule.getProject(), aModule.getName()), this) : aNature.getArtifactEditModelForWrite(ModuleURIUtil.fullyQualifyURI(aModule.getProject(), aModule.getName()), this);
        this.isReadOnly = toAccessAsReadOnly;
        this.isArtifactEditModelSelfManaged = true;
    }

    public ArtifactEdit(ComponentHandle aHandle, boolean toAccessAsReadOnly) throws IllegalArgumentException {
        if (aHandle.getProject() == null || !aHandle.getProject().isAccessible()) {
            throw new IllegalArgumentException("Invalid project specified by handle: " + aHandle.getProject());
        }
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature(aHandle.getProject());
        if (nature == null) {
            throw new IllegalArgumentException("Project does not have ModuleCoreNature." + aHandle.getProject());
        }
        IVirtualComponent component = ComponentCore.createComponent(aHandle.getProject(), aHandle.getName());
        if (component == null) {
            throw new IllegalArgumentException("Invalid component handle: " + aHandle);
        }
        if (!ArtifactEdit.isValidEditableModule(component)) {
            throw new IllegalArgumentException("Invalid component handle: " + aHandle);
        }
        URI componentURI = ModuleURIUtil.fullyQualifyURI(aHandle);
        this.artifactEditModel = toAccessAsReadOnly ? nature.getArtifactEditModelForRead(componentURI, this) : nature.getArtifactEditModelForWrite(componentURI, this);
        this.isReadOnly = toAccessAsReadOnly;
        this.isArtifactEditModelSelfManaged = true;
    }

    public void save(IProgressMonitor aMonitor) {
        if (this.isReadOnly()) {
            this.throwAttemptedReadOnlyModification();
        }
        this.artifactEditModel.save(aMonitor, this);
    }

    public void saveIfNecessary(IProgressMonitor aMonitor) {
        if (this.isReadOnly()) {
            this.throwAttemptedReadOnlyModification();
        }
        this.artifactEditModel.saveIfNecessary(aMonitor, this);
    }

    public void saveIfNecessaryWithPrompt(IProgressMonitor monitor, IOperationHandler operationHandler, boolean wasDirty) {
        if (this.shouldSave(operationHandler, wasDirty)) {
            this.saveIfNecessary(monitor);
        } else {
            this.handleSaveIfNecessaryDidNotSave(monitor);
        }
    }

    private void handleSaveIfNecessaryDidNotSave(IProgressMonitor monitor) {
    }

    private boolean shouldSave(IOperationHandler operationHandler, boolean wasDirty) {
        return !wasDirty ? this.shouldSave() : this.shouldSave(operationHandler);
    }

    private boolean promptToSave(IOperationHandler operationHandler) {
        if (operationHandler == null) {
            return false;
        }
        return operationHandler.canContinue(EMFWorkbenchResourceHandler.getString((String)"The_following_resources_ne_UI_"), this.getArtifactEditModel().getResourceURIs(true));
    }

    private boolean shouldSave(IOperationHandler operationHandler) {
        return this.shouldSave() || this.promptToSave(operationHandler);
    }

    private boolean shouldSave() {
        return !this.isReadOnly() && this.isArtifactEditModelSelfManaged;
    }

    public void dispose() {
        if (this.isArtifactEditModelSelfManaged) {
            this.artifactEditModel.releaseAccess(this);
        }
    }

    public EObject getContentModelRoot() {
        return this.artifactEditModel.getPrimaryRootObject();
    }

    public void addListener(EditModelListener listener) {
        this.artifactEditModel.addListener(listener);
    }

    public void removeListener(EditModelListener listener) {
        this.artifactEditModel.removeListener(listener);
    }

    public boolean hasEditModel(EditModel editModel) {
        return this.artifactEditModel == editModel;
    }

    public ComponentHandle getComponentHandle() {
        return this.getArtifactEditModel().getComponentHandle();
    }

    public IVirtualComponent getComponent() {
        return this.getArtifactEditModel().getVirtualComponent();
    }

    protected ArtifactEditModel getArtifactEditModel() {
        return this.artifactEditModel;
    }

    public CommandStack getCommandStack() {
        return this.artifactEditModel.getCommandStack();
    }

    public void deleteResource(Resource aResource) {
        this.artifactEditModel.deleteResource(aResource);
    }

    public boolean isDirty() {
        return this.artifactEditModel.isDirty();
    }

    private void throwAttemptedReadOnlyModification() {
        throw new IllegalStateException("Attempt to modify an ArtifactEdit instance facade that was loaded as read-only.");
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void forceLoadKnownResources() {
        List uris = this.getArtifactEditModel().getKnownResourceUris();
        URI uri = null;
        int i = 0;
        while (i < uris.size()) {
            uri = (URI)uris.get(i);
            this.getArtifactEditModel().getResource(uri);
            ++i;
        }
    }

    public Resource getResource(URI aUri) {
        return this.getArtifactEditModel().getResource(aUri);
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }
}

