/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.correction;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.SourceEditingRuntimeException;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.correction.IQuickAssistProcessor;
import org.eclipse.wst.sse.ui.internal.correction.IQuickFixProcessor;
import org.eclipse.wst.sse.ui.internal.correction.NoModificationCompletionProposal;

public class StructuredCorrectionProcessor
implements IContentAssistProcessor {
    protected IAnnotationModel fAnnotationModel;
    protected IQuickAssistProcessor fQuickAssistProcessor;
    protected IQuickFixProcessor fQuickFixProcessor;

    public StructuredCorrectionProcessor(ITextEditor editor) {
        IAnnotationModel annotationModel;
        IEditorInput input = editor.getEditorInput();
        this.fAnnotationModel = annotationModel = editor.getDocumentProvider().getAnnotationModel((Object)input);
    }

    protected void addQuickAssistProposals(StructuredTextViewer viewer, ArrayList proposals, int documentOffset) {
        try {
            ICompletionProposal[] res;
            IQuickAssistProcessor processor = this.getQuickAssistProcessor();
            if (processor != null && processor.canAssist(viewer, documentOffset) && (res = processor.getProposals(viewer, documentOffset)) != null) {
                int k = 0;
                while (k < res.length) {
                    proposals.add(res[k]);
                    ++k;
                }
            }
        }
        catch (Exception exception) {
            throw new SourceEditingRuntimeException();
        }
    }

    protected void addQuickFixProposals(StructuredTextViewer viewer, ArrayList proposals, int documentOffset) {
        Iterator iter = this.fAnnotationModel.getAnnotationIterator();
        while (iter.hasNext()) {
            IQuickFixProcessor processor;
            Annotation annotation = (Annotation)iter.next();
            Position pos = this.fAnnotationModel.getPosition(annotation);
            if (pos == null || documentOffset < pos.offset || documentOffset > pos.offset + pos.length || (processor = this.getQuickFixProcessor()) == null || !processor.canFix(annotation)) continue;
            try {
                ICompletionProposal[] res = processor.getProposals(annotation);
                if (res == null) continue;
                int k = 0;
                while (k < res.length) {
                    proposals.add(res[k]);
                    ++k;
                }
            }
            catch (CoreException coreException) {
                throw new SourceEditingRuntimeException();
            }
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        ArrayList<NoModificationCompletionProposal> proposals = new ArrayList<NoModificationCompletionProposal>();
        if (viewer instanceof StructuredTextViewer) {
            this.addQuickFixProposals((StructuredTextViewer)viewer, proposals, documentOffset);
            if (proposals.isEmpty()) {
                this.addQuickAssistProposals((StructuredTextViewer)viewer, proposals, documentOffset);
            }
        }
        if (proposals.isEmpty()) {
            proposals.add(new NoModificationCompletionProposal());
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    protected IQuickAssistProcessor getQuickAssistProcessor() {
        return null;
    }

    protected IQuickFixProcessor getQuickFixProcessor() {
        return null;
    }
}

