/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.provisional.contentproperties;

import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.wst.sse.ui.internal.provisional.contentproperties.ContentSettingsCreator;
import org.eclipse.wst.sse.ui.internal.provisional.contentproperties.IContentSettings;
import org.eclipse.wst.sse.ui.internal.provisional.contentproperties.IContentSettingsHandler;

abstract class AbstractContentSettingsHandler
implements IContentSettingsHandler {
    private IContentSettings contentSettings = ContentSettingsCreator.create();
    private IResourceDelta fDelta;

    AbstractContentSettingsHandler() {
    }

    private void commonWithRespectToKind() {
        this.getContentSettings().releaseCache();
    }

    protected final IContentSettings getContentSettings() {
        return this.contentSettings;
    }

    protected final IResourceDelta getDelta() {
        return this.fDelta;
    }

    public void handle(IResourceDelta delta) {
        this.fDelta = delta;
        int kind = delta.getKind();
        switch (kind) {
            case 4: {
                this.handleChanged();
                break;
            }
            case 2: {
                this.handleRemoved();
                break;
            }
            case 1: {
                this.handleAdded();
            }
        }
    }

    protected void handleAdded() {
        this.commonWithRespectToKind();
    }

    protected void handleChanged() {
        this.commonWithRespectToKind();
    }

    protected void handleRemoved() {
        this.commonWithRespectToKind();
    }
}

