/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.selection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.internal.selection.StructureSelectHistoryAction;

public class SelectionHistory {
    private ITextEditor fEditor;
    private List fHistory;
    private StructureSelectHistoryAction fHistoryAction;
    private int fSelectionChangeListenerCounter;
    private ISelectionChangedListener fSelectionListener;

    public SelectionHistory(ITextEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fHistory = new ArrayList(3);
        this.fSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SelectionHistory.this.fSelectionChangeListenerCounter == 0) {
                    SelectionHistory.this.flush();
                }
            }
        };
        this.fEditor.getSelectionProvider().addSelectionChangedListener(this.fSelectionListener);
    }

    public void dispose() {
        this.fEditor.getSelectionProvider().removeSelectionChangedListener(this.fSelectionListener);
    }

    public void flush() {
        if (this.fHistory.isEmpty()) {
            return;
        }
        this.fHistory.clear();
        this.fHistoryAction.update();
    }

    public IRegion getLast() {
        if (this.isEmpty()) {
            return null;
        }
        int size = this.fHistory.size();
        IRegion result = (IRegion)this.fHistory.remove(size - 1);
        this.fHistoryAction.update();
        return result;
    }

    public void ignoreSelectionChanges() {
        ++this.fSelectionChangeListenerCounter;
    }

    public boolean isEmpty() {
        return this.fHistory.isEmpty();
    }

    public void listenToSelectionChanges() {
        --this.fSelectionChangeListenerCounter;
    }

    public void remember(IRegion region) {
        this.fHistory.add(region);
        this.fHistoryAction.update();
    }

    public void setHistoryAction(StructureSelectHistoryAction action) {
        Assert.isNotNull((Object)((Object)action));
        this.fHistoryAction = action;
    }
}

