/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.task;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseProgressMonitor;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.ProgressMonitor;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class AddJarsToProjectBuildPathTask
extends SimpleCommand {
    private String DESCRIPTION = "TASK_DESC_JARS_TO_PROJECT";
    private String LABEL = "TASK_LABEL_JARS_TO_PROJECT";
    private IJavaProject javaProject_;
    private IClasspathEntry[] oldClasspath_;
    private IClasspathEntry[] newClasspath_;
    private JavaWSDLParameter javaWSDLParam_;
    private boolean isJ2EE_13 = true;
    private MessageUtils msgUtils_;
    private IProject project;
    private String module_;

    public AddJarsToProjectBuildPathTask() {
        String pluginId = "org.eclipse.jst.ws.axis.consumption.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.setDescription(this.msgUtils_.getMessage(this.DESCRIPTION));
        this.setName(this.msgUtils_.getMessage(this.LABEL));
        this.module_ = J2EEUtils.getFirstWebModuleName((IProject)this.project);
    }

    public AddJarsToProjectBuildPathTask(String module) {
        String pluginId = "org.eclipse.jst.ws.axis.consumption.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.setDescription(this.msgUtils_.getMessage(this.DESCRIPTION));
        this.setName(this.msgUtils_.getMessage(this.LABEL));
        this.module_ = module;
    }

    public org.eclipse.wst.command.internal.provisional.env.core.common.Status execute(Environment env) {
        SimpleStatus status;
        block15: {
            status = new SimpleStatus("");
            this.javaProject_ = null;
            this.oldClasspath_ = null;
            try {
                this.javaProject_ = JavaCore.create((IProject)this.project);
                if (this.javaProject_ != null) {
                    this.oldClasspath_ = this.javaProject_.getRawClasspath();
                    break block15;
                }
                status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_WARN_NO_JAVA_NATURE"), 4);
                env.getStatusHandler().reportError((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status);
                return status;
            }
            catch (JavaModelException javaModelException) {
                status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_WARN_NO_JAVA_NATURE"), 4);
                env.getStatusHandler().reportError((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status);
                return status;
            }
        }
        try {
            int newListSize;
            int i;
            IVirtualFolder webInfLib;
            ArrayList<String> aList = new ArrayList<String>();
            String classpathEntry = null;
            IVirtualComponent component = ComponentCore.createComponent((IProject)this.project, (String)this.module_);
            if (component != null && (webInfLib = component.getRootFolder().getFolder((IPath)new Path("/WEB-INF/lib"))) != null) {
                IVirtualResource[] resources = webInfLib.members();
                IResource aResource = null;
                i = 0;
                while (i < resources.length) {
                    aResource = resources[i].getUnderlyingResource();
                    classpathEntry = aResource.getLocation().toString();
                    if (!this.FoundClasspathEntry(classpathEntry)) {
                        aList.add(classpathEntry);
                    }
                    ++i;
                }
            }
            if ((newListSize = aList.size()) == 0) {
                return status;
            }
            this.newClasspath_ = new IClasspathEntry[this.oldClasspath_.length + newListSize];
            Iterator iter = aList.iterator();
            int j = 0;
            while (iter.hasNext()) {
                this.newClasspath_[j] = JavaCore.newLibraryEntry((IPath)new Path((String)iter.next()), null, null);
                ++j;
            }
            i = 0;
            while (i < this.oldClasspath_.length) {
                this.newClasspath_[j + i] = this.oldClasspath_[i];
                ++i;
            }
            ProgressMonitor monitor = env.getProgressMonitor();
            IProgressMonitor eclipseMonitor = null;
            if (monitor instanceof EclipseProgressMonitor) {
                eclipseMonitor = ((EclipseProgressMonitor)monitor).getMonitor();
            }
            this.javaProject_.setRawClasspath(this.newClasspath_, eclipseMonitor);
        }
        catch (JavaModelException e) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_BAD_BUILDPATH"), 2, (Throwable)e);
            try {
                env.getStatusHandler().report((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status);
            }
            catch (StatusException statusException) {
                status = new SimpleStatus("", "User aborted", 4);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return status;
    }

    private boolean FoundClasspathEntry(String classpathEntry) {
        boolean found = false;
        int i = 0;
        while (i < this.oldClasspath_.length && !found) {
            if (this.oldClasspath_[i].getPath().toString().toLowerCase().equals(classpathEntry.toLowerCase())) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    private void AddJar(IProject webProject, String pluginId, String jarName, org.eclipse.wst.command.internal.provisional.env.core.common.Status status, Environment env) {
        block15: {
            this.javaProject_ = null;
            this.oldClasspath_ = null;
            try {
                this.javaProject_ = JavaCore.create((IProject)webProject);
                if (this.javaProject_ != null) {
                    this.oldClasspath_ = this.javaProject_.getRawClasspath();
                    break block15;
                }
                status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_WARN_NO_JAVA_NATURE"), 4);
                env.getStatusHandler().reportError(status);
                return;
            }
            catch (JavaModelException javaModelException) {
                status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_WARN_NO_JAVA_NATURE"), 4);
                env.getStatusHandler().reportError(status);
                return;
            }
        }
        boolean found = false;
        int i = 0;
        while (i < this.oldClasspath_.length) {
            found = found || this.oldClasspath_[i].getPath().toString().toLowerCase().endsWith(jarName.toLowerCase());
            ++i;
        }
        if (found) {
            return;
        }
        this.newClasspath_ = new IClasspathEntry[this.oldClasspath_.length + 1];
        i = 0;
        while (i < this.oldClasspath_.length) {
            this.newClasspath_[i] = this.oldClasspath_[i];
            ++i;
        }
        try {
            this.newClasspath_[i++] = pluginId != null ? JavaCore.newLibraryEntry((IPath)this.getTheJarPath(pluginId, jarName), null, null) : JavaCore.newVariableEntry((IPath)this.getTheJarPath(pluginId, jarName), null, null);
        }
        catch (CoreException e) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_BAD_BUILDPATH"), 2, (Throwable)e);
            try {
                env.getStatusHandler().report(status);
            }
            catch (StatusException statusException) {
                status = new SimpleStatus("", "User aborted", 4);
            }
            return;
        }
        try {
            ProgressMonitor monitor = env.getProgressMonitor();
            IProgressMonitor eclipseMonitor = null;
            if (monitor instanceof EclipseProgressMonitor) {
                eclipseMonitor = ((EclipseProgressMonitor)monitor).getMonitor();
            }
            this.javaProject_.setRawClasspath(this.newClasspath_, eclipseMonitor);
        }
        catch (JavaModelException e) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_BAD_BUILDPATH"), 2, (Throwable)e);
            try {
                env.getStatusHandler().report(status);
            }
            catch (StatusException statusException) {
                status = new SimpleStatus("", "User aborted", 4);
            }
            return;
        }
    }

    private IPath getTheJarPath(String pluginId, String theJar) throws CoreException {
        try {
            if (pluginId != null) {
                IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
                IPluginDescriptor pluginDescriptor = pluginRegistry.getPluginDescriptor(pluginId);
                URL localURL = Platform.asLocalURL((URL)new URL(pluginDescriptor.getInstallURL(), theJar));
                return new Path(localURL.getFile());
            }
            return new Path(theJar);
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.jst.ws.axis.consumption.ui", 0, this.msgUtils_.getMessage("MSG_BAD_AXIS_JAR_URL"), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.jst.ws.axis.consumption.ui", 0, this.msgUtils_.getMessage("MSG_BAD_AXIS_JAR_URL"), (Throwable)e));
        }
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

