/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.task;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.ws.internal.common.EnvironmentUtils;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusException;

public class CheckAxisDeploymentDescriptorsTask
extends SimpleCommand {
    private MessageUtils msgUtils_;
    private MessageUtils coreMsgUtils_;
    private IProject serverProject;
    private String moduleName_;

    public CheckAxisDeploymentDescriptorsTask(String moduleName) {
        String pluginId = "org.eclipse.jst.ws.axis.consumption.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.coreMsgUtils_ = new MessageUtils("org.eclipse.jst.ws.axis.consumption.core.consumption", (Object)this);
        this.setDescription(this.msgUtils_.getMessage("CHECK_WS_DD_TASK_DESCRIPTION"));
        this.setName(this.msgUtils_.getMessage("CHECK_WS_DD_TASK_LABEL"));
        this.moduleName_ = moduleName;
    }

    public Status execute(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        if (EnvironmentUtils.getResourceContext((Environment)env).isOverwriteFilesEnabled()) {
            return status;
        }
        IPath filePath = null;
        IProject project = this.serverProject;
        filePath = J2EEUtils.getWebInfPath((IProject)project, (String)this.moduleName_);
        if ((filePath = filePath.append("/server-config.wsdd")) == null || filePath.isEmpty()) {
            status = new SimpleStatus("", this.coreMsgUtils_.getMessage("MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET"), 4);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        if (file.exists() && !EnvironmentUtils.getResourceContext((Environment)env).isOverwriteFilesEnabled()) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_XML_FILE_OVERWRITE_DISABLED"), 2);
            try {
                env.getStatusHandler().report((Status)status);
            }
            catch (StatusException statusException) {
                status = new SimpleStatus("", "User aborted", 4);
            }
            return status;
        }
        return status;
    }

    public void setServerProject(IProject serverProject) {
        this.serverProject = serverProject;
    }
}

