/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.datamodel.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.AdaptabilityUtility;
import org.eclipse.wst.common.frameworks.internal.datamodel.ExtendableOperationImpl;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMExtendedPageHandler;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMExtendedWizardPage;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementManager;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.DMWizardPageElement;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.DMWizardPageExtensionManager;
import org.eclipse.wst.common.frameworks.internal.ui.ErrorDialog;
import org.eclipse.wst.common.frameworks.internal.ui.RunnableOperationWrapper;
import org.eclipse.wst.common.frameworks.internal.ui.WTPCommonUIResourceHandler;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;

public abstract class DataModelWizard
extends Wizard {
    private IDMExtendedWizardPage[] extendedPages = null;
    private IDMExtendedPageHandler[] extendedPageHandlers = null;
    private IDataModel dataModel;
    static /* synthetic */ Class class$0;

    public DataModelWizard(IDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public DataModelWizard() {
    }

    protected abstract IDataModelProvider getDefaultProvider();

    public final String getWizardID() {
        return this.getDataModel().getID();
    }

    public void createPageControls(Composite pageContainer) {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            block5: {
                block4: {
                    if (this.isExtendedPage(pages[i])) {
                        try {
                            pages[i].createControl(pageContainer);
                            break block4;
                        }
                        catch (Exception e) {
                            Logger.getLogger().logError((Throwable)e);
                            break block5;
                        }
                    }
                    pages[i].createControl(pageContainer);
                }
                Assert.isNotNull((Object)pages[i].getControl());
            }
            ++i;
        }
    }

    protected boolean isExtendedPage(IWizardPage page) {
        int i = 0;
        while (this.extendedPages != null && i < this.extendedPages.length) {
            if (page == this.extendedPages[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final void addPages() {
        this.doAddPages();
        this.addExtensionPages();
    }

    protected void doAddPages() {
    }

    private void addExtensionPages() {
        String wizardID = this.getWizardID();
        DMWizardPageElement wizElement = null;
        if (wizardID == null) {
            return;
        }
        DMWizardPageElement[] elements = DMWizardPageExtensionManager.getInstance().getPageElements(this.getWizardID());
        IDMExtendedWizardPage[] extendedPagesLocal = null;
        IDMExtendedPageHandler extendedPageHandler = null;
        ArrayList<IDMExtendedWizardPage> extendedPagesList = new ArrayList<IDMExtendedWizardPage>();
        ArrayList<IDMExtendedPageHandler> extendedPageHandlerList = new ArrayList<IDMExtendedPageHandler>();
        int i = 0;
        while (i < elements.length) {
            wizElement = elements[i];
            try {
                extendedPagesLocal = wizElement.createPageGroup(this.getDataModel());
                if (extendedPagesLocal != null) {
                    int j = 0;
                    while (j < extendedPagesLocal.length) {
                        this.addPage(extendedPagesLocal[j]);
                        extendedPagesList.add(extendedPagesLocal[j]);
                        ++j;
                    }
                }
                if ((extendedPageHandler = wizElement.createPageHandler(this.getDataModel())) != null && !extendedPageHandlerList.contains(extendedPageHandler)) {
                    extendedPageHandlerList.add(extendedPageHandler);
                }
            }
            catch (RuntimeException runtime) {
                Logger.getLogger().logError(WTPCommonUIResourceHandler.getString("ExtendableWizard_UI_0", new Object[]{wizElement.getPluginID(), wizElement.pageGroupID}));
                Logger.getLogger().logError((Throwable)runtime);
            }
            ++i;
        }
        this.extendedPages = new IDMExtendedWizardPage[extendedPagesList.size()];
        i = 0;
        while (i < this.extendedPages.length) {
            this.extendedPages[i] = (IDMExtendedWizardPage)extendedPagesList.get(i);
            ++i;
        }
        this.extendedPageHandlers = new IDMExtendedPageHandler[extendedPageHandlerList.size()];
        i = 0;
        while (i < this.extendedPageHandlers.length) {
            this.extendedPageHandlers[i] = (IDMExtendedPageHandler)extendedPageHandlerList.get(i);
            ++i;
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage expectedPage = super.getNextPage(page);
        if (expectedPage instanceof IDMExtendedWizardPage) {
            IDMExtendedWizardPage extendedWizardPage = (IDMExtendedWizardPage)expectedPage;
            List extendedContext = this.getDataModel().getExtendedContext();
            boolean enabled = true;
            int contextCount = 0;
            while (enabled && contextCount < extendedContext.size()) {
                IProject project;
                Object e = extendedContext.get(contextCount);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IProject");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((project = (IProject)AdaptabilityUtility.getAdapter(e, (Class)clazz)) != null && !IEnablementManager.INSTANCE.getIdentifier(extendedWizardPage.getGroupID(), project).isEnabled()) {
                    enabled = false;
                }
                ++contextCount;
            }
            if (!enabled) {
                return this.getNextPage(expectedPage);
            }
        }
        String expectedPageName = expectedPage == null ? null : expectedPage.getName();
        String nextPageName = null;
        int i = 0;
        while (this.extendedPageHandlers != null && i < this.extendedPageHandlers.length) {
            nextPageName = this.extendedPageHandlers[i].getNextPage(page.getName(), expectedPageName);
            if (nextPageName != null) {
                if (nextPageName.equals("IDMExtendedPageHandler.SKIP_PAGE")) {
                    return this.getNextPage(expectedPage);
                }
                if (nextPageName.startsWith("IDMExtendedPageHandler.PAGE_AFTER")) {
                    String tempNextPageName = nextPageName.substring("IDMExtendedPageHandler.PAGE_AFTER".length());
                    IWizardPage tempNextPage = this.getPage(tempNextPageName);
                    return tempNextPage == null ? null : super.getNextPage(tempNextPage);
                }
                return this.getPage(nextPageName);
            }
            ++i;
        }
        return expectedPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage expectedPage = super.getPreviousPage(page);
        String expectedPageName = expectedPage == null ? null : expectedPage.getName();
        String previousPageName = null;
        int i = 0;
        while (this.extendedPageHandlers != null && i < this.extendedPageHandlers.length) {
            previousPageName = this.extendedPageHandlers[i].getPreviousPage(page.getName(), expectedPageName);
            if (previousPageName != null) {
                if (previousPageName.equals("IDMExtendedPageHandler.SKIP_PAGE")) {
                    return this.getPreviousPage(expectedPage);
                }
                if (previousPageName.startsWith("IDMExtendedPageHandler.PAGE_AFTER")) {
                    String tempPreviousPageName = previousPageName.substring("IDMExtendedPageHandler.PAGE_AFTER".length());
                    IWizardPage tempPreviousPage = this.getPage(tempPreviousPageName);
                    return tempPreviousPage == null ? null : super.getPreviousPage(tempPreviousPage);
                }
                return this.getPage(previousPageName);
            }
            ++i;
        }
        return expectedPage;
    }

    public boolean canFinish() {
        if (!super.canFinish() || !this.getDataModel().isValid()) {
            return false;
        }
        int i = 0;
        while (this.extendedPages != null && i < this.extendedPages.length) {
            if (!this.extendedPages[i].canPageFinish()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void resetAfterFinishError() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            DataModelWizardPage wtpPage = (DataModelWizardPage)pages[i];
            wtpPage.validatePage(true);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean performFinish() {
        IUndoableOperation op = null;
        boolean wasSuccessful = false;
        try {
            if (this.prePerformFinish()) {
                this.storeDefaultSettings();
                op = this.createOperation();
                if (op != null) {
                    RunnableOperationWrapper runnable = WTPUIPlugin.getRunnableWithProgress(op);
                    try {
                        this.getContainer().run(this.runForked(), this.isCancelable(), (IRunnableWithProgress)runnable);
                        this.postPerformFinish();
                    }
                    catch (InvocationTargetException e) {
                        Logger.getLogger().logError((Throwable)e);
                        ErrorDialog.openError(this.getShell(), WTPCommonUIResourceHandler.getString("WTPWizard_UI_0", new Object[]{this.getWindowTitle()}), WTPCommonUIResourceHandler.getString("WTPWizard_UI_1", new Object[]{this.getWindowTitle()}), e, 0, false);
                        boolean bl = wasSuccessful = false;
                        Object var5_9 = null;
                        if (wasSuccessful) return bl;
                        this.resetAfterFinishError();
                        return bl;
                    }
                    catch (InterruptedException e) {
                        Logger.getLogger().logError((Throwable)e);
                        boolean bl = wasSuccessful = false;
                        Object var5_10 = null;
                        if (wasSuccessful) return bl;
                        this.resetAfterFinishError();
                        return bl;
                    }
                    wasSuccessful = this.isSuccessfulFinish(runnable.getStatus());
                }
            }
            boolean bl = wasSuccessful;
            Object var5_11 = null;
            if (wasSuccessful) return bl;
            this.resetAfterFinishError();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            if (wasSuccessful) throw throwable;
            this.resetAfterFinishError();
            throw throwable;
        }
    }

    protected boolean isSuccessfulFinish(IStatus status) {
        return status.isOK();
    }

    protected boolean prePerformFinish() {
        return true;
    }

    protected void postPerformFinish() throws InvocationTargetException {
    }

    protected void storeDefaultSettings() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            this.storeDefaultSettings(pages[i], i);
            ++i;
        }
    }

    protected void storeDefaultSettings(IWizardPage page, int pageIndex) {
        if (page instanceof DataModelWizardPage) {
            ((DataModelWizardPage)page).storeDefaultSettings();
        }
    }

    protected boolean isCancelable() {
        return false;
    }

    protected boolean runForked() {
        return false;
    }

    private IUndoableOperation createOperation() {
        ExtendableOperationImpl baseOperation = (ExtendableOperationImpl)this.getDataModel().getDefaultOperation();
        if (baseOperation == null) {
            return null;
        }
        int i = 0;
        while (this.extendedPages != null && i < this.extendedPages.length) {
            IDataModelOperation op = this.extendedPages[i].createOperation();
            if (op != null) {
                baseOperation.appendOperation(op);
            }
            ++i;
        }
        return baseOperation;
    }

    public void setDataModel(IDataModel model) {
        this.dataModel = model;
    }

    public IDataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = DataModelFactory.createDataModel((IDataModelProvider)this.getDefaultProvider());
        }
        return this.dataModel;
    }

    public void dispose() {
        super.dispose();
        if (this.dataModel != null) {
            this.dataModel.dispose();
        }
    }

    public void addPage(IWizardPage page) {
        List pagesToSkip;
        if (this.getDataModel().isProperty("WTPWizardSkipPageDataModel.SKIP_PAGES") && page.getName() != null && (pagesToSkip = (List)this.getDataModel().getProperty("WTPWizardSkipPageDataModel.SKIP_PAGES")) != null && pagesToSkip.contains(page.getName())) {
            return;
        }
        super.addPage(page);
    }
}

