/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operation.extensionui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.IOperationNode;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.MasterDescriptor;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.SlaveDescriptor;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.UIOperationExtensionRegistry;
import org.eclipse.wst.common.frameworks.internal.operations.ComposedOperation;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.ui.WTPCommonUIResourceHandler;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;

public class WTPOptionalOperationDataModel
extends WTPOperationDataModel {
    public static final String EXTENDED_OPERATION_ID = "WTPOptionalOperationDataModel.EXTENDED_OPERATION_ID";
    public static final String STRUCTURED_SELECTION = "WTPOptionalOperationDataModel.STRUCTURED_SELECTION";
    public static final String MASTER_OPERATION_LIST = "WTPOptionalOperationDataModel.MASTER_OPERATION_LIST";
    public static final String OPERATION_TREE = "WTPOptionalOperationDataModel.OPERATION_TREE";
    public static final String IWORKBENCH_SITE = "IWORKBENCH_SITE";

    public static WTPOptionalOperationDataModel createDataModel(String extendedOperationId, IStructuredSelection selection) {
        WTPOptionalOperationDataModel dataModel = new WTPOptionalOperationDataModel();
        dataModel.setProperty(EXTENDED_OPERATION_ID, extendedOperationId);
        dataModel.setProperty(STRUCTURED_SELECTION, selection);
        return dataModel;
    }

    protected void init() {
        super.init();
        this.setProperty(OPERATION_TREE, new OperationNode(null, null));
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(MASTER_OPERATION_LIST);
        this.addValidBaseProperty(OPERATION_TREE);
        this.addValidBaseProperty(STRUCTURED_SELECTION);
        this.addValidBaseProperty(EXTENDED_OPERATION_ID);
        this.addValidBaseProperty(IWORKBENCH_SITE);
    }

    IStructuredSelection getStructuredSelection() {
        return (IStructuredSelection)this.getProperty(STRUCTURED_SELECTION);
    }

    public IOperationNode getOperationTree() {
        return (IOperationNode)this.getProperty(OPERATION_TREE);
    }

    public static IOperationNode[] getOptionalChildren(IOperationNode node) {
        IOperationNode[] children = node.getChildren();
        children = WTPOptionalOperationDataModel.filterRequiredChildren(children);
        return children;
    }

    public static IOperationNode[] filterRequiredChildren(IOperationNode[] children) {
        ArrayList<IOperationNode> filteredChildren = new ArrayList<IOperationNode>(Arrays.asList(children));
        int i = 0;
        while (i < children.length) {
            if (children[i].isAlwaysExecute()) {
                filteredChildren.remove(children[i]);
            }
            ++i;
        }
        children = new IOperationNode[filteredChildren.size()];
        filteredChildren.toArray(children);
        return children;
    }

    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        boolean returnVal = super.doSetProperty(propertyName, propertyValue);
        if (propertyName.equals(STRUCTURED_SELECTION) || propertyName.equals(EXTENDED_OPERATION_ID)) {
            String extendedOperationID = this.getStringProperty(EXTENDED_OPERATION_ID);
            IStructuredSelection selection = (IStructuredSelection)this.getProperty(STRUCTURED_SELECTION);
            this.setProperty(MASTER_OPERATION_LIST, UIOperationExtensionRegistry.INSTANCE.getExtendedUIOperations(extendedOperationID, selection));
        }
        if (propertyName.equals(MASTER_OPERATION_LIST)) {
            OperationNode rootNode = (OperationNode)this.getOperationTree();
            rootNode.clearChildren();
            MasterDescriptor[] descriptors = (MasterDescriptor[])propertyValue;
            if (descriptors != null) {
                int i = 0;
                while (i < descriptors.length) {
                    OperationNode child = new OperationNode(rootNode, descriptors[i]);
                    child.setChecked(true);
                    rootNode.addChild(child);
                    ++i;
                }
            }
            this.notifyListeners(OPERATION_TREE);
        }
        return returnVal;
    }

    public WTPOperation getDefaultOperation() {
        ComposedOperation operation = new ComposedOperation();
        OperationNode root = (OperationNode)this.getOperationTree();
        this.addOperationIfNecessary(operation, root);
        return operation;
    }

    private void addOperationIfNecessary(ComposedOperation operation, OperationNode node) {
        if (node.isAlwaysExecute() || node.isChecked()) {
            WTPOperation op = node.getOperation();
            if (op != null) {
                operation.addRunnable(op);
            }
        } else {
            IOperationNode[] children = node.getChildren(false);
            int i = 0;
            while (children != null && i < children.length) {
                this.addOperationIfNecessary(operation, (OperationNode)children[i]);
                ++i;
            }
        }
    }

    private boolean hasSelectedNodes(OperationNode node) {
        if (node.isChecked()) {
            return true;
        }
        boolean foundSelection = false;
        OperationNode[] children = (OperationNode[])node.getChildren(false);
        int i = 0;
        while (!foundSelection && children != null && i < children.length) {
            foundSelection = this.hasSelectedNodes(children[i]);
            ++i;
        }
        return foundSelection;
    }

    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(OPERATION_TREE)) {
            OperationNode root = (OperationNode)this.getOperationTree();
            if (root.isChecked()) {
                return WTPUIPlugin.createErrorStatus(WTPCommonUIResourceHandler.getString("WTPOptionalOperationDataModel_UI_0"));
            }
            if (!this.hasSelectedNodes(root)) {
                return WTPUIPlugin.createErrorStatus(WTPCommonUIResourceHandler.getString("WTPOptionalOperationDataModel_UI_1"));
            }
        }
        return super.doValidateProperty(propertyName);
    }

    private class OperationNode
    implements IOperationNode {
        private WTPOperationDataModel dataModel = null;
        private SlaveDescriptor descriptor = null;
        private List children = null;
        private OperationNode parent = null;
        private boolean checked = false;

        public OperationNode(OperationNode parent, SlaveDescriptor descriptor) {
            this.parent = parent;
            this.descriptor = descriptor;
            this.verifyRoot();
        }

        private void verifyRoot() {
            if (this.parent == null) {
                return;
            }
            IOperationNode root = WTPOptionalOperationDataModel.this.getOperationTree();
            OperationNode node = this;
            while (node.parent != null) {
                node = node.parent;
            }
            if (node != root) {
                throw new RuntimeException();
            }
        }

        public String getName() {
            return this.descriptor.getName();
        }

        public String getDescription() {
            return this.descriptor.getDescription();
        }

        public WTPOperationDataModel getDataModel() {
            IWorkbenchSite site = (IWorkbenchSite)WTPOptionalOperationDataModel.this.getProperty(WTPOptionalOperationDataModel.IWORKBENCH_SITE);
            if (this.dataModel == null) {
                IOperationNode root = WTPOptionalOperationDataModel.this.getOperationTree();
                if (this.parent == root) {
                    MasterDescriptor masterDescriptor = (MasterDescriptor)this.descriptor;
                    this.dataModel = masterDescriptor.getCreator().createDataModel(masterDescriptor.getExtendedOperationId(), masterDescriptor.getOperationClass(), WTPOptionalOperationDataModel.this.getStructuredSelection(), site);
                } else {
                    this.dataModel = this.parent.getDataModel();
                }
            }
            return this.dataModel;
        }

        public WTPOperation getOperation() {
            WTPOperation operation = this.descriptor.createOperation();
            WTPOperationDataModel dataModel1 = this.getDataModel();
            if (dataModel1 != null) {
                if (operation == null) {
                    operation = this.dataModel.getDefaultOperation();
                } else {
                    operation.setOperationDataModel(this.dataModel);
                }
            }
            return operation;
        }

        public IOperationNode[] getChildren() {
            this.verifyRoot();
            return this.getChildren(true);
        }

        public IOperationNode[] getChildren(boolean expandChildren) {
            if (expandChildren && this.children == null && this.parent != null) {
                this.children = new ArrayList();
                SlaveDescriptor[] slaveDescriptors = UIOperationExtensionRegistry.INSTANCE.getSlaveDescriptors(this.descriptor.getOperationClass());
                int i = 0;
                while (slaveDescriptors != null && i < slaveDescriptors.length) {
                    OperationNode child = new OperationNode(this, slaveDescriptors[i]);
                    child.checked = this.checked;
                    this.addChild(child);
                    ++i;
                }
            }
            if (this.children == null) {
                return null;
            }
            IOperationNode[] childNodes = new OperationNode[this.children.size()];
            this.children.toArray(childNodes);
            return childNodes;
        }

        public void clearChildren() {
            if (this.children != null) {
                this.children.clear();
            }
        }

        public void addChild(OperationNode childNode) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(childNode);
        }

        public boolean isChecked() {
            this.verifyRoot();
            if (this.descriptor instanceof MasterDescriptor && ((MasterDescriptor)this.descriptor).isAlwaysExecute()) {
                return true;
            }
            return this.checked;
        }

        public void setChecked(boolean checked) {
            if (this.descriptor instanceof MasterDescriptor && ((MasterDescriptor)this.descriptor).isAlwaysExecute()) {
                return;
            }
            this.internalSetChecked(checked);
            WTPOptionalOperationDataModel.this.getProperty(WTPOptionalOperationDataModel.OPERATION_TREE);
            WTPOptionalOperationDataModel.this.notifyListeners(WTPOptionalOperationDataModel.OPERATION_TREE);
        }

        public IOperationNode getParent() {
            return this.parent;
        }

        protected void internalSetChecked(boolean checked1) {
            this.checked = checked1;
            if (this.checked) {
                OperationNode[] children1 = (OperationNode[])this.getChildren(false);
                int i = 0;
                while (this.children != null && i < children1.length) {
                    children1[i].internalSetChecked(this.checked);
                    ++i;
                }
            } else if (this.parent != null) {
                this.parent.internalSetChecked(this.checked);
            }
        }

        public boolean isAlwaysExecute() {
            return this.descriptor instanceof MasterDescriptor && ((MasterDescriptor)this.descriptor).isAlwaysExecute();
        }
    }
}

