/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.codemanipulation.IRequestQuery;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public final class AddGetterSetterOperation
implements IWorkspaceRunnable {
    private static final String[] EMPTY_STRINGS = new String[0];
    private final IField[] fAccessorFields;
    private boolean fApply = true;
    private TextEdit fEdit = null;
    private final IField[] fGetterFields;
    private final IJavaElement fInsert;
    private final boolean fSave;
    private final IField[] fSetterFields;
    private final CodeGenerationSettings fSettings;
    private boolean fSkipAllExisting = false;
    private boolean fSkipAllFinalSetters = false;
    private final IRequestQuery fSkipExistingQuery;
    private final IRequestQuery fSkipFinalSettersQuery;
    private boolean fSort = false;
    private final IType fType;
    private final CompilationUnit fUnit;
    private int fVisibility = 1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public AddGetterSetterOperation(IType type, IField[] getters, IField[] setters, IField[] accessors, CompilationUnit unit, IRequestQuery skipFinalSettersQuery, IRequestQuery skipExistingQuery, IJavaElement insert, CodeGenerationSettings settings, boolean apply, boolean save) {
        Assert.isNotNull(type);
        Assert.isNotNull(unit);
        Assert.isNotNull(settings);
        this.fType = type;
        this.fGetterFields = getters;
        this.fSetterFields = setters;
        this.fAccessorFields = accessors;
        this.fUnit = unit;
        this.fSkipExistingQuery = skipExistingQuery;
        this.fSkipFinalSettersQuery = skipFinalSettersQuery;
        this.fInsert = insert;
        this.fSettings = settings;
        this.fSave = save;
        this.fApply = apply;
    }

    private void addNewAccessor(IType type, IField field, String contents, ListRewrite rewrite, ASTNode insertion) throws JavaModelException {
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)type);
        MethodDeclaration declaration = (MethodDeclaration)rewrite.getASTRewrite().createStringPlaceholder(CodeFormatterUtil.format(4, contents, 0, null, delimiter, field.getJavaProject()), 31);
        if (insertion != null) {
            rewrite.insertBefore((ASTNode)declaration, insertion, null);
        } else {
            rewrite.insertLast((ASTNode)declaration, null);
        }
    }

    private void generateGetterMethod(IField field, ListRewrite rewrite) throws CoreException, OperationCanceledException {
        IType type = field.getDeclaringType();
        String name = GetterSetterUtil.getGetterName(field, null);
        IMethod existing = JavaModelUtil.findMethod(name, EMPTY_STRINGS, false, type);
        if (existing == null || !this.querySkipExistingMethods(existing)) {
            IJavaElement sibling = null;
            if (existing != null) {
                sibling = StubUtility.findNextSibling((IJavaElement)existing);
                this.removeExistingAccessor(existing, rewrite);
            } else {
                sibling = this.fInsert;
            }
            MethodDeclaration insertion = null;
            if (sibling instanceof IMethod) {
                ASTNode aSTNode = NodeFinder.perform(rewrite.getParent().getRoot(), ((IMethod)this.fInsert).getNameRange());
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                insertion = (MethodDeclaration)ASTNodes.getParent(aSTNode, clazz);
            }
            this.addNewAccessor(type, field, GetterSetterUtil.getGetterStub(field, name, this.fSettings.createComments, this.fVisibility | field.getFlags() & 8), rewrite, (ASTNode)insertion);
        }
    }

    private void generateSetterMethod(IField field, ListRewrite rewrite) throws CoreException, OperationCanceledException {
        IType type = field.getDeclaringType();
        String name = GetterSetterUtil.getSetterName(field, null);
        IMethod existing = JavaModelUtil.findMethod(name, new String[]{field.getTypeSignature()}, false, type);
        if (!(Flags.isFinal((int)field.getFlags()) && this.querySkipFinalSetters(field) || existing != null && !this.querySkipExistingMethods(existing))) {
            IJavaElement sibling = null;
            if (existing != null) {
                sibling = StubUtility.findNextSibling((IJavaElement)existing);
                this.removeExistingAccessor(existing, rewrite);
            } else {
                sibling = this.fInsert;
            }
            MethodDeclaration insertion = null;
            if (sibling instanceof IMethod) {
                ASTNode aSTNode = NodeFinder.perform(rewrite.getParent().getRoot(), ((IMethod)this.fInsert).getNameRange());
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                insertion = (MethodDeclaration)ASTNodes.getParent(aSTNode, clazz);
            }
            this.addNewAccessor(type, field, GetterSetterUtil.getSetterStub(field, name, this.fSettings.createComments, this.fVisibility | field.getFlags() & 8), rewrite, (ASTNode)insertion);
        }
    }

    public final TextEdit getResultingEdit() {
        return this.fEdit;
    }

    public final ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public final int getVisibility() {
        return this.fVisibility;
    }

    public final boolean isSkipAllExisting() {
        return this.fSkipAllExisting;
    }

    public final boolean isSkipAllFinalSetters() {
        return this.fSkipAllFinalSetters;
    }

    private boolean querySkipExistingMethods(IMethod method) throws OperationCanceledException {
        if (!this.fSkipAllExisting) {
            switch (this.fSkipExistingQuery.doQuery((IMember)method)) {
                case 0: {
                    throw new OperationCanceledException();
                }
                case 1: {
                    return false;
                }
                case 3: {
                    this.fSkipAllExisting = true;
                }
            }
        }
        return true;
    }

    private boolean querySkipFinalSetters(IField field) throws OperationCanceledException {
        if (!this.fSkipAllFinalSetters) {
            switch (this.fSkipFinalSettersQuery.doQuery((IMember)field)) {
                case 0: {
                    throw new OperationCanceledException();
                }
                case 1: {
                    return false;
                }
                case 3: {
                    this.fSkipAllFinalSetters = true;
                }
            }
        }
        return true;
    }

    private void removeExistingAccessor(IMethod accessor, ListRewrite rewrite) throws JavaModelException {
        MethodDeclaration declaration;
        ASTNode aSTNode = NodeFinder.perform(rewrite.getParent().getRoot(), accessor.getNameRange());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((declaration = (MethodDeclaration)ASTNodes.getParent(aSTNode, clazz)) != null) {
            rewrite.remove((ASTNode)declaration, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            block36: {
                monitor.setTaskName(CodeGenerationMessages.AddGetterSetterOperation_description);
                monitor.beginTask("", this.fGetterFields.length + this.fSetterFields.length);
                ICompilationUnit unit = this.fType.getCompilationUnit();
                CompilationUnitRewrite rewrite = new CompilationUnitRewrite(unit, this.fUnit);
                ListRewrite rewriter = null;
                if (this.fType.isAnonymous()) {
                    AnonymousClassDeclaration declaration;
                    ClassInstanceCreation creation;
                    ASTNode aSTNode = NodeFinder.perform((ASTNode)rewrite.getRoot(), this.fType.getNameRange());
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.ClassInstanceCreation");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((creation = (ClassInstanceCreation)ASTNodes.getParent(aSTNode, clazz)) != null && (declaration = creation.getAnonymousClassDeclaration()) != null) {
                        rewriter = rewrite.getASTRewrite().getListRewrite((ASTNode)declaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
                    }
                } else {
                    AbstractTypeDeclaration declaration;
                    ASTNode aSTNode = NodeFinder.perform((ASTNode)rewrite.getRoot(), this.fType.getNameRange());
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((declaration = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz)) != null) {
                        rewriter = rewrite.getASTRewrite().getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty());
                    }
                }
                if (rewriter != null) {
                    ITextFileBuffer buffer = null;
                    IDocument document = null;
                    try {
                        block35: {
                            CompilationUnitChange change;
                            TextEdit edit;
                            int index;
                            if (!JavaModelUtil.isPrimary(unit)) {
                                document = new Document(unit.getBuffer().getContents());
                            } else {
                                buffer = RefactoringFileBuffers.acquire(unit);
                                document = buffer.getDocument();
                            }
                            this.fSkipAllFinalSetters = this.fSkipFinalSettersQuery == null;
                            boolean bl = this.fSkipAllExisting = this.fSkipExistingQuery == null;
                            if (!this.fSort) {
                                index = 0;
                                while (index < this.fAccessorFields.length) {
                                    this.generateGetterMethod(this.fAccessorFields[index], rewriter);
                                    this.generateSetterMethod(this.fAccessorFields[index], rewriter);
                                    monitor.worked(1);
                                    if (monitor.isCanceled()) {
                                        throw new OperationCanceledException();
                                    }
                                    ++index;
                                }
                            }
                            index = 0;
                            while (index < this.fGetterFields.length) {
                                this.generateGetterMethod(this.fGetterFields[index], rewriter);
                                monitor.worked(1);
                                if (monitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                ++index;
                            }
                            index = 0;
                            while (index < this.fSetterFields.length) {
                                this.generateSetterMethod(this.fSetterFields[index], rewriter);
                                monitor.worked(1);
                                if (monitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                ++index;
                            }
                            CompilationUnitChange result = rewrite.createChange();
                            if (result instanceof CompilationUnitChange && (edit = (change = result).getEdit()) != null) {
                                try {
                                    this.fEdit = edit;
                                    if (this.fApply) {
                                        edit.apply(document, 2);
                                    }
                                    if (!this.fSave) break block35;
                                    if (buffer != null) {
                                        buffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
                                    } else {
                                        unit.getBuffer().setContents(document.get());
                                    }
                                }
                                catch (Exception exception) {
                                    throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, exception.getLocalizedMessage(), (Throwable)exception));
                                }
                            }
                        }
                        Object var11_14 = null;
                        if (buffer == null) break block36;
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        if (buffer == null) throw throwable;
                        RefactoringFileBuffers.release(unit);
                        throw throwable;
                    }
                    RefactoringFileBuffers.release(unit);
                }
            }
            Object var13_17 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    public final void setSkipAllExisting(boolean skip) {
        this.fSkipAllExisting = skip;
    }

    public final void setSkipAllFinalSetters(boolean skip) {
        this.fSkipAllFinalSetters = skip;
    }

    public void setSort(boolean sort) {
        this.fSort = sort;
    }

    public final void setVisibility(int visibility) {
        this.fVisibility = visibility;
    }
}

