/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;

public class MethodChecks {
    private MethodChecks() {
    }

    public static boolean isVirtual(IMethod method) throws JavaModelException {
        if (method.isConstructor()) {
            return false;
        }
        if (JdtFlags.isPrivate((IMember)method)) {
            return false;
        }
        return !JdtFlags.isStatic((IMember)method);
    }

    public static boolean isVirtual(IMethodBinding methodBinding) {
        if (methodBinding.isConstructor()) {
            return false;
        }
        if (Modifier.isPrivate((int)methodBinding.getModifiers())) {
            return false;
        }
        return !Modifier.isStatic((int)methodBinding.getModifiers());
    }

    public static RefactoringStatus checkIfOverridesAnother(IMethod method, ITypeHierarchy hierarchy) throws JavaModelException {
        IMethod overrides = MethodChecks.overridesAnotherMethod(method, hierarchy);
        if (overrides == null) {
            return null;
        }
        RefactoringStatusContext context = JavaStatusContext.create((IMember)overrides);
        String message = Messages.format(RefactoringCoreMessages.MethodChecks_overrides, new String[]{JavaElementUtil.createMethodSignature(overrides), JavaModelUtil.getFullyQualifiedName(overrides.getDeclaringType())});
        return RefactoringStatus.createStatus((int)4, (String)message, (RefactoringStatusContext)context, (String)Corext.getPluginId(), (int)1, (Object)overrides);
    }

    public static RefactoringStatus checkIfComesFromInterface(IMethod method, ITypeHierarchy hierarchy, IProgressMonitor monitor) throws JavaModelException {
        IMethod inInterface = MethodChecks.isDeclaredInInterface(method, hierarchy, monitor);
        if (inInterface == null) {
            return null;
        }
        RefactoringStatusContext context = JavaStatusContext.create((IMember)inInterface);
        String message = Messages.format(RefactoringCoreMessages.MethodChecks_implements, new String[]{JavaElementUtil.createMethodSignature(inInterface), JavaModelUtil.getFullyQualifiedName(inInterface.getDeclaringType())});
        return RefactoringStatus.createStatus((int)4, (String)message, (RefactoringStatusContext)context, (String)Corext.getPluginId(), (int)2, (Object)inInterface);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IMethod isDeclaredInInterface(IMethod method, ITypeHierarchy hierarchy, IProgressMonitor monitor) throws JavaModelException {
        IMethod iMethod;
        SubProgressMonitor subMonitor;
        block7: {
            IMethod iMethod2;
            block8: {
                Assert.isTrue(MethodChecks.isVirtual(method));
                subMonitor = new SubProgressMonitor(monitor, 1);
                try {
                    IType[] classes = hierarchy.getAllClasses();
                    subMonitor.beginTask("", classes.length);
                    int i = 0;
                    block2: while (true) {
                        if (i >= classes.length) {
                            iMethod = null;
                            break block7;
                        }
                        IType clazz = classes[i];
                        IType[] superinterfaces = null;
                        superinterfaces = clazz.equals(hierarchy.getType()) ? hierarchy.getAllSuperInterfaces(clazz) : clazz.newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1)).getAllSuperInterfaces(clazz);
                        int j = 0;
                        while (true) {
                            if (j >= superinterfaces.length) {
                                subMonitor.worked(1);
                                ++i;
                                continue block2;
                            }
                            IMethod found = Checks.findSimilarMethod(method, superinterfaces[j]);
                            if (found != null && !found.equals(method)) {
                                iMethod2 = found;
                                Object var10_12 = null;
                                break block8;
                            }
                            ++j;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    subMonitor.done();
                    throw throwable;
                }
            }
            subMonitor.done();
            return iMethod2;
        }
        Object var10_13 = null;
        subMonitor.done();
        return iMethod;
    }

    public static IMethod overridesAnotherMethod(IMethod method, ITypeHierarchy hierarchy) throws JavaModelException {
        boolean overrides;
        IMethod found = JavaModelUtil.findMethodDeclarationInHierarchy(hierarchy, method.getDeclaringType(), method.getElementName(), method.getParameterTypes(), method.isConstructor());
        boolean bl = overrides = found != null && !found.equals(method) && !JdtFlags.isStatic((IMember)found) && !JdtFlags.isPrivate((IMember)found);
        if (overrides) {
            return found;
        }
        return null;
    }
}

