/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.Assert;

public class RefactoringScanner {
    private final String fName;
    private final String fQualifier;
    private IScanner fScanner;
    private ISourceRange fNoFlyZone;
    private Set fMatches;

    public RefactoringScanner(String name, String qualifier) {
        Assert.isNotNull(name);
        Assert.isNotNull(qualifier);
        this.fName = name;
        this.fQualifier = qualifier;
    }

    public void scan(ICompilationUnit cu) throws JavaModelException {
        char[] chars = cu.getBuffer().getCharacters();
        this.fMatches = new HashSet();
        this.fScanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        this.fScanner.setSource(chars);
        IImportContainer importContainer = cu.getImportContainer();
        this.fNoFlyZone = importContainer.exists() ? importContainer.getSourceRange() : null;
        this.doScan();
        this.fScanner = null;
    }

    public void scan(String text) {
        char[] chars = text.toCharArray();
        this.fMatches = new HashSet();
        this.fScanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        this.fScanner.setSource(chars);
        this.doScan();
        this.fScanner = null;
    }

    private void doScan() {
        try {
            int token = this.fScanner.getNextToken();
            while (token != 158) {
                switch (token) {
                    case 45: 
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        this.parseCurrentToken();
                    }
                }
                token = this.fScanner.getNextToken();
            }
        }
        catch (InvalidInputException invalidInputException) {}
    }

    private static boolean isWholeWord(String value, int from, int to) {
        char ch;
        if (from > 0 && (Character.isLetterOrDigit(ch = value.charAt(from - 1)) || ch == '_')) {
            return false;
        }
        return to >= value.length() || !Character.isLetterOrDigit(ch = value.charAt(to)) && ch != '_';
    }

    private void parseCurrentToken() {
        String value = new String(this.fScanner.getRawTokenSource());
        int start = this.fScanner.getCurrentTokenStartPosition();
        int index = value.indexOf(this.fName);
        while (index != -1) {
            if (RefactoringScanner.isWholeWord(value, index, index + this.fName.length()) && this.isQualifierOK(value, index)) {
                this.addMatch(start + index);
            }
            index = value.indexOf(this.fName, index + 1);
        }
    }

    private boolean isQualifierOK(String value, int nameStart) {
        int qualifierAfter = nameStart - 1;
        if (qualifierAfter < 0) {
            return true;
        }
        char charBeforeName = value.charAt(qualifierAfter);
        if (!this.isQualifierSeparator(charBeforeName)) {
            return true;
        }
        boolean canFinish = charBeforeName == '#';
        int i = 0;
        while (i < this.fQualifier.length()) {
            char goalQualifierChar;
            int qualifierCharPos = qualifierAfter - 1 - i;
            if (qualifierCharPos < 0) {
                return canFinish;
            }
            char qualifierChar = value.charAt(qualifierCharPos);
            if (qualifierChar != (goalQualifierChar = this.fQualifier.charAt(this.fQualifier.length() - 1 - i))) {
                return canFinish && !this.isQualifierPart(qualifierChar);
            }
            canFinish = !this.isQualifierSeparator(qualifierChar);
            ++i;
        }
        int beforeQualifierPos = qualifierAfter - this.fQualifier.length() - 1;
        if (beforeQualifierPos >= 0) {
            char beforeQualifierChar = value.charAt(beforeQualifierPos);
            return !this.isQualifierPart(beforeQualifierChar);
        }
        return true;
    }

    private boolean isQualifierPart(char ch) {
        return Character.isJavaIdentifierPart(ch) || this.isQualifierSeparator(ch);
    }

    private boolean isQualifierSeparator(char c) {
        return ".#".indexOf(c) != -1;
    }

    private void addMatch(int matchStart) {
        if (this.fNoFlyZone != null && this.fNoFlyZone.getOffset() <= matchStart && matchStart < this.fNoFlyZone.getOffset() + this.fNoFlyZone.getLength()) {
            return;
        }
        this.fMatches.add(new Integer(matchStart));
    }

    public Set getMatches() {
        return this.fMatches;
    }
}

