/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class EditorUtility {
    static /* synthetic */ Class class$0;

    public static boolean isEditorInput(Object element, IEditorPart editor) {
        if (editor != null) {
            try {
                return editor.getEditorInput().equals(EditorUtility.getEditorInput(element));
            }
            catch (JavaModelException x) {
                JavaPlugin.log(x.getStatus());
            }
        }
        return false;
    }

    public static IEditorPart isOpenInEditor(Object inputElement) {
        IWorkbenchPage p;
        IEditorInput input = null;
        try {
            input = EditorUtility.getEditorInput(inputElement);
        }
        catch (JavaModelException x) {
            JavaPlugin.log(x.getStatus());
        }
        if (input != null && (p = JavaPlugin.getActivePage()) != null) {
            return p.findEditor(input);
        }
        return null;
    }

    public static IEditorPart openInEditor(Object inputElement) throws JavaModelException, PartInitException {
        return EditorUtility.openInEditor(inputElement, true);
    }

    public static IEditorPart openInEditor(Object inputElement, boolean activate) throws JavaModelException, PartInitException {
        if (inputElement instanceof IFile) {
            return EditorUtility.openInEditor((IFile)inputElement, activate);
        }
        IEditorInput input = EditorUtility.getEditorInput(inputElement);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            return EditorUtility.openInEditor(fileInput.getFile(), activate);
        }
        if (input != null) {
            return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, inputElement), activate);
        }
        return null;
    }

    public static void revealInEditor(IEditorPart part, IJavaElement element) {
        if (element == null) {
            return;
        }
        if (part instanceof JavaEditor) {
            ((JavaEditor)part).setSelection(element);
            return;
        }
        try {
            ISourceRange range = null;
            if (element instanceof ICompilationUnit) {
                range = null;
            } else if (element instanceof IClassFile) {
                range = null;
            } else if (element instanceof ILocalVariable) {
                range = ((ILocalVariable)element).getNameRange();
            } else if (element instanceof IMember) {
                range = ((IMember)element).getNameRange();
            } else if (element instanceof ITypeParameter) {
                range = ((ITypeParameter)element).getNameRange();
            } else if (element instanceof ISourceReference) {
                range = ((ISourceReference)element).getSourceRange();
            }
            if (range != null) {
                EditorUtility.revealInEditor(part, range.getOffset(), range.getLength());
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public static void revealInEditor(IEditorPart part, IRegion region) {
        if (part != null && region != null) {
            EditorUtility.revealInEditor(part, region.getOffset(), region.getLength());
        }
    }

    public static void revealInEditor(IEditorPart editor, final int offset, final int length) {
        if (editor instanceof ITextEditor) {
            ((ITextEditor)editor).selectAndReveal(offset, length);
            return;
        }
        if (editor instanceof IGotoMarker) {
            final IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                final IGotoMarker gotoMarkerTarget = (IGotoMarker)editor;
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    /*
                     * Exception decompiling
                     */
                    protected void execute(IProgressMonitor monitor) throws CoreException {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 85->89)] java.lang.Throwable
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                };
                try {
                    op.run(null);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    Assert.isTrue((boolean)false, (String)"this operation can not be canceled");
                }
            }
            return;
        }
        if (editor != null && editor.getEditorSite().getSelectionProvider() != null) {
            IEditorSite site = editor.getEditorSite();
            if (site == null) {
                return;
            }
            ISelectionProvider provider = editor.getEditorSite().getSelectionProvider();
            if (provider == null) {
                return;
            }
            provider.setSelection((ISelection)new TextSelection(offset, length));
        }
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (file != null && (p = JavaPlugin.getActivePage()) != null) {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)activate);
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (input != null && (p = JavaPlugin.getActivePage()) != null) {
            IEditorPart editorPart = p.openEditor(input, editorID, activate);
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    private static void initializeHighlightRange(IEditorPart editorPart) {
        if (editorPart instanceof ITextEditor) {
            boolean enable;
            IAction toggleAction = editorPart.getEditorSite().getActionBars().getGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly");
            boolean bl = enable = toggleAction != null;
            if (enable && editorPart instanceof JavaEditor) {
                enable = JavaPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.jdt.ui.editor.showSegments");
            } else {
                boolean bl2 = enable = enable && toggleAction.isEnabled() && toggleAction.isChecked();
            }
            if (enable) {
                if (toggleAction instanceof TextEditorAction) {
                    ((TextEditorAction)toggleAction).setEditor(null);
                    ((TextEditorAction)toggleAction).setEditor((ITextEditor)editorPart);
                } else {
                    toggleAction.run();
                    toggleAction.run();
                }
            }
        }
    }

    public static String getEditorID(IEditorInput input, Object inputObject) {
        IEditorDescriptor editorDescriptor;
        try {
            editorDescriptor = IDE.getEditorDescriptor((String)input.getName());
        }
        catch (PartInitException partInitException) {
            return null;
        }
        if (editorDescriptor != null) {
            return editorDescriptor.getId();
        }
        return null;
    }

    private static IEditorInput getEditorInput(IJavaElement element) throws JavaModelException {
        while (element != null) {
            ICompilationUnit unit;
            IResource resource;
            if (element instanceof ICompilationUnit && (resource = (unit = JavaModelUtil.toOriginal((ICompilationUnit)element)).getResource()) instanceof IFile) {
                return new FileEditorInput((IFile)resource);
            }
            if (element instanceof IClassFile) {
                return new InternalClassFileEditorInput((IClassFile)element);
            }
            element = element.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object input) throws JavaModelException {
        if (input instanceof IJavaElement) {
            return EditorUtility.getEditorInput((IJavaElement)input);
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        if (input instanceof IStorage) {
            return new JarEntryEditorInput((IStorage)input);
        }
        return null;
    }

    public static IJavaElement getActiveEditorJavaInput() {
        IEditorInput editorInput;
        IEditorPart part;
        IWorkbenchPage page = JavaPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) != null && (editorInput = part.getEditorInput()) != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IJavaElement)editorInput.getAdapter((Class)clazz);
        }
        return null;
    }

    public static int findLocalizedModifier(String modifierName) {
        if (modifierName == null) {
            return 0;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static String getModifierString(int stateMask) {
        String modifierString = "";
        if ((stateMask & 0x40000) == 262144) {
            modifierString = EditorUtility.appendModifierString(modifierString, 262144);
        }
        if ((stateMask & 0x10000) == 65536) {
            modifierString = EditorUtility.appendModifierString(modifierString, 65536);
        }
        if ((stateMask & 0x20000) == 131072) {
            modifierString = EditorUtility.appendModifierString(modifierString, 131072);
        }
        if ((stateMask & 0x400000) == 0x400000) {
            modifierString = EditorUtility.appendModifierString(modifierString, 0x400000);
        }
        return modifierString;
    }

    private static String appendModifierString(String modifierString, int modifier) {
        if (modifierString == null) {
            modifierString = "";
        }
        String newModifierString = Action.findModifierString((int)modifier);
        if (modifierString.length() == 0) {
            return newModifierString;
        }
        return Messages.format(JavaEditorMessages.EditorUtility_concatModifierStrings, new String[]{modifierString, newModifierString});
    }

    public static IJavaProject getJavaProject(IEditorInput input) {
        IJavaProject jProject = null;
        if (input instanceof IFileEditorInput) {
            IProject project = ((IFileEditorInput)input).getFile().getProject();
            if (project != null && !(jProject = JavaCore.create((IProject)project)).exists()) {
                jProject = null;
            }
        } else if (input instanceof IClassFileEditorInput) {
            jProject = ((IClassFileEditorInput)input).getClassFile().getJavaProject();
        }
        return jProject;
    }
}

