/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.JavaElementLine;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.text.Match;

public class ImplementOccurrencesFinder
implements IOccurrencesFinder {
    private ASTNode fStart;
    private List fResult = new ArrayList();
    private ASTNode fSelectedNode;
    private ITypeBinding fSelectedType;

    public String initialize(CompilationUnit root, int offset, int length) {
        ASTNode node = NodeFinder.perform((ASTNode)root, offset, length);
        if (!(node instanceof Name)) {
            return SearchMessages.ImplementOccurrencesFinder_invalidTarget;
        }
        this.fSelectedNode = ASTNodes.getNormalizedNode(node);
        if (!(this.fSelectedNode instanceof Type)) {
            return SearchMessages.ImplementOccurrencesFinder_invalidTarget;
        }
        ASTNode typeDeclaration = this.fSelectedNode.getParent();
        if (!(typeDeclaration instanceof AbstractTypeDeclaration)) {
            return SearchMessages.ImplementOccurrencesFinder_invalidTarget;
        }
        this.fSelectedType = ((Type)this.fSelectedNode).resolveBinding();
        if (this.fSelectedType == null) {
            return SearchMessages.ImplementOccurrencesFinder_invalidTarget;
        }
        this.fStart = typeDeclaration;
        return null;
    }

    public List perform() {
        this.fStart.accept((ASTVisitor)new MethodVisitor());
        if (this.fSelectedNode != null) {
            this.fResult.add(this.fSelectedNode);
        }
        return this.fResult;
    }

    public void collectOccurrenceMatches(IJavaElement element, IDocument document, Collection resultingMatches) {
        Iterator iter = this.fResult.iterator();
        while (iter.hasNext()) {
            ASTNode node = (ASTNode)iter.next();
            int startPosition = node.getStartPosition();
            int length = node.getLength();
            try {
                int line = document.getLineOfOffset(startPosition);
                IRegion region = document.getLineInformation(line);
                String lineContents = document.get(region.getOffset(), region.getLength()).trim();
                JavaElementLine groupKey = new JavaElementLine(element, line, lineContents);
                resultingMatches.add(new Match((Object)groupKey, startPosition, length));
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public String getJobLabel() {
        return SearchMessages.ImplementOccurrencesFinder_searchfor;
    }

    public String getPluralLabel(String elementName) {
        Object[] args = new String[]{ASTNodes.asString(this.fSelectedNode), "{0}", elementName};
        return Messages.format(SearchMessages.ImplementOccurrencesFinder_label_plural, args);
    }

    public String getSingularLabel(String elementName) {
        Object[] args = new String[]{ASTNodes.asString(this.fSelectedNode), elementName};
        return Messages.format(SearchMessages.ImplementOccurrencesFinder_label_singular, args);
    }

    public void releaseAST() {
        this.fStart = null;
        this.fSelectedType = null;
    }

    private class MethodVisitor
    extends ASTVisitor {
        MethodVisitor() {
        }

        public boolean visit(MethodDeclaration node) {
            IMethodBinding method;
            IMethodBinding binding = node.resolveBinding();
            if (binding != null && (method = Bindings.findOverriddenMethodInHierarchy(ImplementOccurrencesFinder.this.fSelectedType, binding)) != null) {
                ImplementOccurrencesFinder.this.fResult.add(node.getName());
            }
            return super.visit(node);
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public boolean visit(TypeDeclarationStatement node) {
            return false;
        }
    }
}

