/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.text.HTMLPrinter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.projection.AnnotationBag;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;

public class JavaAnnotationHover
implements IAnnotationHover {
    public static final JavaAnnotationHoverType OVERVIEW_RULER_HOVER = new JavaAnnotationHoverType();
    public static final JavaAnnotationHoverType TEXT_RULER_HOVER = new JavaAnnotationHoverType();
    public static final JavaAnnotationHoverType VERTICAL_RULER_HOVER = new JavaAnnotationHoverType();
    private IPreferenceStore fStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
    private JavaAnnotationHoverType fType;

    public JavaAnnotationHover(JavaAnnotationHoverType type) {
        Assert.isTrue((OVERVIEW_RULER_HOVER.equals(type) || TEXT_RULER_HOVER.equals(type) || VERTICAL_RULER_HOVER.equals(type) ? 1 : 0) != 0);
        this.fType = type;
    }

    private boolean isRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                return line == document.getLineOfOffset(position.getOffset());
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    private IAnnotationModel getAnnotationModel(ISourceViewer viewer) {
        if (viewer instanceof ISourceViewerExtension2) {
            ISourceViewerExtension2 extension = (ISourceViewerExtension2)viewer;
            return extension.getVisualAnnotationModel();
        }
        return viewer.getAnnotationModel();
    }

    private boolean isDuplicateJavaAnnotation(Map messagesAtPosition, Position position, String message) {
        if (messagesAtPosition.containsKey(position)) {
            Object value = messagesAtPosition.get(position);
            if (message.equals(value)) {
                return true;
            }
            if (value instanceof List) {
                List messages = (List)value;
                if (messages.contains(message)) {
                    return true;
                }
                messages.add(message);
            } else {
                ArrayList<Object> messages = new ArrayList<Object>();
                messages.add(value);
                messages.add(message);
                messagesAtPosition.put(position, messages);
            }
        } else {
            messagesAtPosition.put(position, message);
        }
        return false;
    }

    private boolean includeAnnotation(Annotation annotation, Position position, HashMap messagesAtPosition) {
        String key;
        AnnotationPreference preference = this.getAnnotationPreference(annotation);
        if (preference == null) {
            return false;
        }
        if (OVERVIEW_RULER_HOVER.equals(this.fType) ? (key = preference.getOverviewRulerPreferenceKey()) == null || !this.fStore.getBoolean(key) : (TEXT_RULER_HOVER.equals(this.fType) ? ((key = preference.getTextPreferenceKey()) != null ? !this.fStore.getBoolean(key) : (key = preference.getHighlightPreferenceKey()) == null || !this.fStore.getBoolean(key)) : VERTICAL_RULER_HOVER.equals(this.fType) && (key = preference.getVerticalRulerPreferenceKey()) != null && !this.fStore.getBoolean(key))) {
            return false;
        }
        String text = annotation.getText();
        return text != null && !this.isDuplicateJavaAnnotation(messagesAtPosition, position, text);
    }

    private List getJavaAnnotationsForLine(ISourceViewer viewer, int line) {
        IAnnotationModel model = this.getAnnotationModel(viewer);
        if (model == null) {
            return null;
        }
        IDocument document = viewer.getDocument();
        ArrayList<Annotation> javaAnnotations = new ArrayList<Annotation>();
        HashMap messagesAtPosition = new HashMap();
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            Position position = model.getPosition(annotation);
            if (position == null || !this.isRulerLine(position, document, line)) continue;
            if (annotation instanceof AnnotationBag) {
                AnnotationBag bag = (AnnotationBag)annotation;
                Iterator e = bag.iterator();
                while (e.hasNext()) {
                    annotation = (Annotation)e.next();
                    position = model.getPosition(annotation);
                    if (position == null || !this.includeAnnotation(annotation, position, messagesAtPosition)) continue;
                    javaAnnotations.add(annotation);
                }
                continue;
            }
            if (!this.includeAnnotation(annotation, position, messagesAtPosition)) continue;
            javaAnnotations.add(annotation);
        }
        return javaAnnotations;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List javaAnnotations = this.getJavaAnnotationsForLine(sourceViewer, lineNumber);
        if (javaAnnotations != null) {
            if (javaAnnotations.size() == 1) {
                Annotation annotation = (Annotation)javaAnnotations.get(0);
                String message = annotation.getText();
                if (message != null && message.trim().length() > 0) {
                    return this.formatSingleMessage(message);
                }
            } else {
                ArrayList<String> messages = new ArrayList<String>();
                Iterator e = javaAnnotations.iterator();
                while (e.hasNext()) {
                    Annotation annotation = (Annotation)e.next();
                    String message = annotation.getText();
                    if (message == null || message.trim().length() <= 0) continue;
                    messages.add(message.trim());
                }
                if (messages.size() == 1) {
                    return this.formatSingleMessage((String)messages.get(0));
                }
                if (messages.size() > 1) {
                    return this.formatMultipleMessages(messages);
                }
            }
        }
        return null;
    }

    private String formatSingleMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(message));
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    private String formatMultipleMessages(List messages) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(JavaUIMessages.JavaAnnotationHover_multipleMarkersAtThisLine));
        HTMLPrinter.startBulletList(buffer);
        Iterator e = messages.iterator();
        while (e.hasNext()) {
            HTMLPrinter.addBullet(buffer, HTMLPrinter.convertToHTMLContent((String)e.next()));
        }
        HTMLPrinter.endBulletList(buffer);
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }

    private static class JavaAnnotationHoverType {
        JavaAnnotationHoverType() {
        }
    }
}

