/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.spelling.HtmlTagDictionary;
import org.eclipse.jdt.internal.ui.text.spelling.JavaDocTagDictionary;
import org.eclipse.jdt.internal.ui.text.spelling.SpellReconcileDictionary;
import org.eclipse.jdt.internal.ui.text.spelling.TaskTagDictionary;
import org.eclipse.jdt.internal.ui.text.spelling.engine.DefaultSpellChecker;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellDictionary;
import org.eclipse.jdt.internal.ui.text.spelling.engine.PersistentSpellDictionary;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class SpellCheckEngine
implements ISpellCheckEngine,
IPropertyChangeListener {
    public static final String DICTIONARY_LOCATION = "dictionaries/";
    private static ISpellCheckEngine fgEngine = null;
    private final Set fGlobalDictionaries = new HashSet();
    private Locale fLocale = null;
    private ISpellChecker fChecker = null;
    private final Map fLocaleDictionaries = new HashMap();
    private IPreferenceStore fPreferences = null;
    private ISpellDictionary fUserDictionary = null;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set getAvailableLocales() {
        URL url = null;
        Locale locale = null;
        InputStream stream = null;
        HashSet<Locale> result = new HashSet<Locale>();
        try {
            URL location = SpellCheckEngine.getDictionaryLocation();
            if (location == null) {
                return Collections.EMPTY_SET;
            }
            Locale[] locales = Locale.getAvailableLocales();
            int index = 0;
            while (true) {
                block10: {
                    if (index >= locales.length) {
                        return result;
                    }
                    locale = locales[index];
                    url = new URL(location, String.valueOf(locale.toString().toLowerCase()) + ".dictionary");
                    try {
                        Object var7_7;
                        stream = url.openStream();
                        if (stream == null) break block10;
                        try {
                            result.add(locale);
                        }
                        catch (Throwable throwable) {
                            var7_7 = null;
                            stream.close();
                            throw throwable;
                        }
                        {
                            var7_7 = null;
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                ++index;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return result;
    }

    public static Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public static URL getDictionaryLocation() throws MalformedURLException {
        JavaPlugin plugin = JavaPlugin.getDefault();
        if (plugin != null) {
            return plugin.getBundle().getEntry("/dictionaries/");
        }
        return null;
    }

    public static final synchronized ISpellCheckEngine getInstance() {
        if (fgEngine == null) {
            fgEngine = new SpellCheckEngine();
        }
        return fgEngine;
    }

    private SpellCheckEngine() {
        this.fGlobalDictionaries.add(new TaskTagDictionary());
        this.fGlobalDictionaries.add(new HtmlTagDictionary());
        this.fGlobalDictionaries.add(new JavaDocTagDictionary());
        try {
            Locale locale = null;
            URL location = SpellCheckEngine.getDictionaryLocation();
            Iterator iterator = SpellCheckEngine.getAvailableLocales().iterator();
            while (iterator.hasNext()) {
                locale = (Locale)iterator.next();
                this.fLocaleDictionaries.put(locale, new SpellReconcileDictionary(locale, location));
            }
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public final synchronized ISpellChecker createSpellChecker(Locale locale, IPreferenceStore store) {
        ISpellDictionary dictionary;
        if (this.fLocale != null && this.fLocale.equals(locale)) {
            return this.fChecker;
        }
        if (this.fChecker == null) {
            this.fChecker = new DefaultSpellChecker(store);
            store.addPropertyChangeListener((IPropertyChangeListener)this);
            this.fPreferences = store;
            dictionary = null;
            Iterator iterator = this.fGlobalDictionaries.iterator();
            while (iterator.hasNext()) {
                dictionary = (ISpellDictionary)iterator.next();
                this.fChecker.addDictionary(dictionary);
            }
        }
        dictionary = null;
        if (this.fLocale != null && (dictionary = (ISpellDictionary)this.fLocaleDictionaries.get(this.fLocale)) != null) {
            this.fChecker.removeDictionary(dictionary);
            dictionary.unload();
        }
        this.fLocale = locale;
        dictionary = (ISpellDictionary)this.fLocaleDictionaries.get(locale);
        if (dictionary == null) {
            if (!SpellCheckEngine.getDefaultLocale().equals(locale)) {
                if (this.fPreferences != null) {
                    this.fPreferences.removePropertyChangeListener((IPropertyChangeListener)this);
                }
                this.fChecker = null;
                this.fLocale = null;
            }
        } else {
            this.fChecker.addDictionary(dictionary);
        }
        if (this.fPreferences != null) {
            this.propertyChange(new PropertyChangeEvent((Object)this, "spelling_user_dictionary", null, (Object)this.fPreferences.getString("spelling_user_dictionary")));
        }
        return this.fChecker;
    }

    public final Locale getLocale() {
        return this.fLocale;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void propertyChange(PropertyChangeEvent event) {
        String file;
        if (this.fChecker == null) return;
        if (!event.getProperty().equals("spelling_user_dictionary")) return;
        if (this.fUserDictionary != null) {
            this.fChecker.removeDictionary(this.fUserDictionary);
            this.fUserDictionary = null;
        }
        if ((file = (String)event.getNewValue()).length() <= 0) return;
        try {
            URL url = new URL("file", null, file);
            InputStream stream = url.openStream();
            if (stream == null) return;
            try {
                this.fUserDictionary = new PersistentSpellDictionary(url);
                this.fChecker.addDictionary(this.fUserDictionary);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                stream.close();
                throw throwable;
            }
            {
                Object var5_7 = null;
                stream.close();
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        catch (IOException iOException) {}
    }

    public final synchronized void registerDictionary(ISpellDictionary dictionary) {
        this.fGlobalDictionaries.add(dictionary);
        if (this.fChecker != null) {
            this.fChecker.addDictionary(dictionary);
        }
    }

    public final synchronized void registerDictionary(Locale locale, ISpellDictionary dictionary) {
        this.fLocaleDictionaries.put(locale, dictionary);
        if (this.fChecker != null && this.fLocale != null && this.fLocale.equals(locale)) {
            this.fChecker.addDictionary(dictionary);
        }
    }

    public final synchronized void unload() {
        ISpellDictionary dictionary = null;
        Iterator<Object> iterator = this.fGlobalDictionaries.iterator();
        while (iterator.hasNext()) {
            dictionary = (ISpellDictionary)iterator.next();
            dictionary.unload();
        }
        iterator = this.fLocaleDictionaries.values().iterator();
        while (iterator.hasNext()) {
            dictionary = (ISpellDictionary)iterator.next();
            dictionary.unload();
        }
        if (this.fPreferences != null) {
            this.fPreferences.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.fUserDictionary = null;
        this.fChecker = null;
    }

    public final synchronized void unregisterDictionary(ISpellDictionary dictionary) {
        this.fGlobalDictionaries.remove(dictionary);
        this.fLocaleDictionaries.values().remove(dictionary);
        if (this.fChecker != null) {
            this.fChecker.removeDictionary(dictionary);
        }
        dictionary.unload();
    }
}

