/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.Assert;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.PartNavigator;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.ui.SaveablePartAdapter;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ActionHandler;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.commands.Priority;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.progress.IProgressService;

public class ParticipantPageSaveablePart
extends SaveablePartAdapter
implements IContentChangeListener {
    private CompareConfiguration cc;
    private ISynchronizeParticipant participant;
    private ISynchronizePageConfiguration pageConfiguration;
    private Image titleImage;
    private Shell shell;
    private Shell dialogShell;
    private boolean fDirty = false;
    private ArrayList fDirtyViewers = new ArrayList();
    private IPropertyChangeListener fDirtyStateListener;
    private CompareViewerSwitchingPane fContentPane;
    private CompareViewerPane fEditionPane;
    private CompareViewerSwitchingPane fStructuredComparePane;
    private Viewer viewer;
    private Control control;
    private boolean showContentPanes = true;
    private IActionBars actionBars;
    private List actionHandlers = new ArrayList(2);
    private IPageBookViewPage page;

    public ParticipantPageSaveablePart(Shell shell, CompareConfiguration cc, ISynchronizePageConfiguration pageConfiguration, ISynchronizeParticipant participant) {
        this.cc = cc;
        this.shell = shell;
        this.participant = participant;
        this.pageConfiguration = pageConfiguration;
        this.fDirtyStateListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getProperty();
                if ("DIRTY_STATE".equals(propertyName)) {
                    boolean changed = false;
                    Object newValue = e.getNewValue();
                    if (newValue instanceof Boolean) {
                        changed = (Boolean)newValue;
                    }
                    ParticipantPageSaveablePart.this.setDirty(e.getSource(), changed);
                }
            }
        };
    }

    public void dispose() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        if (this.page != null) {
            this.page.dispose();
        }
        IWorkbenchCommandSupport cm = PlatformUI.getWorkbench().getCommandSupport();
        Iterator it = this.actionHandlers.iterator();
        while (it.hasNext()) {
            HandlerSubmission handler = (HandlerSubmission)it.next();
            cm.removeHandlerSubmission(handler);
        }
        super.dispose();
    }

    public Image getTitleImage() {
        if (this.titleImage == null) {
            this.titleImage = this.participant.getImageDescriptor().createImage();
        }
        return this.titleImage;
    }

    public String getTitle() {
        return this.participant.getName();
    }

    public boolean isDirty() {
        return this.fDirty || this.fDirtyViewers.size() > 0;
    }

    public void contentChanged(IContentChangeNotifier source) {
        try {
            if (source instanceof DiffNode) {
                ParticipantPageSaveablePart.commit((IProgressMonitor)new NullProgressMonitor(), (DiffNode)source);
            } else if (source instanceof LocalResourceTypedElement) {
                ((LocalResourceTypedElement)source).commit((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            Utils.handle(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSave(IProgressMonitor pm) {
        ISynchronizeModelElement root = (ISynchronizeModelElement)this.viewer.getInput();
        if (root == null) return;
        if (!(root instanceof DiffNode)) return;
        try {
            try {
                ParticipantPageSaveablePart.commit(pm, (DiffNode)root);
            }
            catch (CoreException e) {
                Utils.handle(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setDirty(false);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.setDirty(false);
            return;
        }
    }

    public void createPartControl(Composite parent2) {
        Composite parent = new Composite(parent2, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)data);
        this.dialogShell = parent2.getShell();
        Splitter vsplitter = new Splitter(parent, 512);
        vsplitter.setLayoutData((Object)new GridData(1808));
        Splitter hsplitter = new Splitter((Composite)vsplitter, 256);
        this.fEditionPane = new CompareViewerPane((Composite)hsplitter, 0x800800);
        this.fStructuredComparePane = new CompareViewerSwitchingPane((Composite)hsplitter, 0x800800, false){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                if (input instanceof ICompareInput) {
                    return CompareUI.findStructureViewer((Viewer)oldViewer, (ICompareInput)((ICompareInput)input), (Composite)this, (CompareConfiguration)ParticipantPageSaveablePart.this.cc);
                }
                return null;
            }
        };
        this.fStructuredComparePane.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ParticipantPageSaveablePart.this.feedInput2(e.getSelection());
            }
        });
        this.fEditionPane.setText(TeamUIMessages.ParticipantPageSaveablePart_0);
        this.page = this.participant.createPage(this.pageConfiguration);
        ((SynchronizePageConfiguration)this.pageConfiguration).setSite(new CompareViewerPaneSite());
        ToolBarManager tbm = CompareViewerPane.getToolBarManager((Composite)this.fEditionPane);
        this.createActionBars((IToolBarManager)tbm);
        try {
            ((ISynchronizePage)this.page).init(this.pageConfiguration.getSite());
        }
        catch (PartInitException partInitException) {}
        this.page.createControl((Composite)this.fEditionPane);
        if (this.page instanceof ISynchronizePage) {
            ((ISynchronizePage)this.page).getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection ss;
                    ISelection sel = event.getSelection();
                    if (sel instanceof IStructuredSelection && (ss = (IStructuredSelection)sel).size() == 1) {
                        ParticipantPageSaveablePart.this.setInput(ss.getFirstElement());
                    }
                }
            });
            this.initializeDiffViewer(((ISynchronizePage)this.page).getViewer());
        }
        this.page.setActionBars(this.getActionBars());
        this.fEditionPane.setContent(this.page.getControl());
        tbm.update(true);
        if (this.page instanceof ISynchronizePage) {
            this.viewer = ((ISynchronizePage)this.page).getViewer();
        }
        this.fContentPane = new CompareViewerSwitchingPane((Composite)vsplitter, 0x800800){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                boolean isNewViewer;
                Viewer newViewer = CompareUI.findContentViewer((Viewer)oldViewer, (Object)input, (Composite)this, (CompareConfiguration)ParticipantPageSaveablePart.this.cc);
                boolean bl = isNewViewer = newViewer != oldViewer;
                if (isNewViewer && newViewer instanceof IPropertyChangeNotifier) {
                    IPropertyChangeNotifier dsp = (IPropertyChangeNotifier)newViewer;
                    dsp.addPropertyChangeListener(ParticipantPageSaveablePart.this.fDirtyStateListener);
                    Control c = newViewer.getControl();
                    c.addDisposeListener(new DisposeListener(this, dsp){
                        final /* synthetic */ 5 this$1;
                        private final /* synthetic */ IPropertyChangeNotifier val$dsp;
                        {
                            this.this$1 = var1_1;
                            this.val$dsp = iPropertyChangeNotifier;
                        }

                        public void widgetDisposed(DisposeEvent e) {
                            this.val$dsp.removePropertyChangeListener(ParticipantPageSaveablePart.access$7(5.access$0(this.this$1)));
                        }
                    });
                }
                return newViewer;
            }

            static /* synthetic */ ParticipantPageSaveablePart access$0(5 var0) {
                return var0.ParticipantPageSaveablePart.this;
            }
        };
        vsplitter.setWeights(new int[]{30, 70});
        this.setNavigator(this.pageConfiguration);
        this.control = parent;
        if (!this.showContentPanes) {
            hsplitter.setMaximizedControl((Control)this.fEditionPane);
        }
    }

    public void setNavigator(ISynchronizePageConfiguration configuration) {
        configuration.setProperty("org.eclipse.team.ui.P_NAVIGATOR", new PartNavigator(new Object[]{configuration.getProperty("org.eclipse.team.ui.P_ADVISOR"), this.fStructuredComparePane, this.fContentPane}));
    }

    public void setShowContentPanes(boolean showContentPanes) {
        this.showContentPanes = showContentPanes;
    }

    private void setInput(Object input) {
        this.fContentPane.setInput(input);
        if (this.fStructuredComparePane != null) {
            this.fStructuredComparePane.setInput(input);
        }
    }

    private void feedInput2(ISelection sel) {
        IStructuredSelection ss;
        if (sel instanceof IStructuredSelection && (ss = (IStructuredSelection)sel).size() == 1) {
            this.fContentPane.setInput(ss.getFirstElement());
        }
    }

    public Control getControl() {
        return this.control;
    }

    private void initializeDiffViewer(Viewer viewer) {
        if (viewer instanceof StructuredViewer) {
            ((StructuredViewer)viewer).addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    IResource resource;
                    ISelection s = event.getSelection();
                    SyncInfoModelElement node = ParticipantPageSaveablePart.this.getElement(s);
                    if (node != null && (resource = node.getResource()) != null && resource.getType() == 1) {
                        IProgressService manager = PlatformUI.getWorkbench().getProgressService();
                        try {
                            manager.busyCursorWhile(new IRunnableWithProgress(this, node){
                                final /* synthetic */ 7 this$1;
                                private final /* synthetic */ SyncInfoModelElement val$node;
                                {
                                    this.this$1 = var1_1;
                                    this.val$node = syncInfoModelElement;
                                }

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    try {
                                        ParticipantPageSaveablePart.access$9(7.access$0(this.this$1)).prepareCompareInput(this.val$node, ParticipantPageSaveablePart.access$4(7.access$0(this.this$1)), monitor);
                                        ParticipantPageSaveablePart.access$10(7.access$0(this.this$1), this.val$node);
                                    }
                                    catch (TeamException e) {
                                        Utils.handle(e);
                                    }
                                }
                            });
                        }
                        catch (InvocationTargetException e) {
                            Utils.handle(e);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                }

                static /* synthetic */ ParticipantPageSaveablePart access$0(7 var0) {
                    return var0.ParticipantPageSaveablePart.this;
                }
            });
        }
    }

    private void hookContentChangeListener(DiffNode node) {
        ITypedElement right;
        ITypedElement left = node.getLeft();
        if (left instanceof IContentChangeNotifier) {
            ((IContentChangeNotifier)left).addContentChangeListener((IContentChangeListener)this);
        }
        if ((right = node.getRight()) instanceof IContentChangeNotifier) {
            ((IContentChangeNotifier)right).addContentChangeListener((IContentChangeListener)this);
        }
    }

    private SyncInfoModelElement getElement(ISelection selection) {
        Object o;
        IStructuredSelection ss;
        if (selection != null && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (o = ss.getFirstElement()) instanceof SyncInfoModelElement) {
            return (SyncInfoModelElement)o;
        }
        return null;
    }

    private static void commit(IProgressMonitor pm, DiffNode node) throws CoreException {
        ITypedElement right;
        ITypedElement left = node.getLeft();
        if (left instanceof LocalResourceTypedElement) {
            ((LocalResourceTypedElement)left).commit(pm);
        }
        if ((right = node.getRight()) instanceof LocalResourceTypedElement) {
            ((LocalResourceTypedElement)right).commit(pm);
        }
        IDiffElement[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            ParticipantPageSaveablePart.commit(pm, (DiffNode)children[i]);
            ++i;
        }
    }

    private void setDirty(boolean dirty) {
        boolean confirmSave = true;
        Object o = this.cc.getProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY");
        if (o instanceof Boolean) {
            confirmSave = (Boolean)o;
        }
        if (!confirmSave) {
            this.fDirty = dirty;
            if (!this.fDirty) {
                this.fDirtyViewers.clear();
            }
        }
    }

    private void setDirty(Object source, boolean dirty) {
        Assert.isNotNull((Object)source);
        if (dirty) {
            this.fDirtyViewers.add(source);
        } else {
            this.fDirtyViewers.remove(source);
        }
    }

    private void createActionBars(final IToolBarManager toolbar) {
        if (this.actionBars == null) {
            this.actionBars = new IActionBars(){

                public void clearGlobalActionHandlers() {
                }

                public IAction getGlobalActionHandler(String actionId) {
                    return null;
                }

                public IMenuManager getMenuManager() {
                    return null;
                }

                public IStatusLineManager getStatusLineManager() {
                    return null;
                }

                public IToolBarManager getToolBarManager() {
                    return toolbar;
                }

                public void setGlobalActionHandler(String actionId, IAction action) {
                    if (actionId != null && !"".equals(actionId)) {
                        ActionHandler handler = new ActionHandler(action);
                        HandlerSubmission handlerSubmission = new HandlerSubmission(null, ParticipantPageSaveablePart.this.dialogShell, null, actionId, (IHandler)handler, Priority.MEDIUM);
                        PlatformUI.getWorkbench().getCommandSupport().addHandlerSubmission(handlerSubmission);
                        ParticipantPageSaveablePart.this.actionHandlers.add(handlerSubmission);
                    }
                }

                public void updateActionBars() {
                }
            };
        }
    }

    private IActionBars getActionBars() {
        return this.actionBars;
    }

    public ISynchronizePageConfiguration getPageConfiguration() {
        return this.pageConfiguration;
    }

    public ISynchronizeParticipant getParticipant() {
        return this.participant;
    }

    static /* synthetic */ ISynchronizeParticipant access$9(ParticipantPageSaveablePart participantPageSaveablePart) {
        return participantPageSaveablePart.participant;
    }

    static /* synthetic */ void access$10(ParticipantPageSaveablePart participantPageSaveablePart, DiffNode diffNode) {
        participantPageSaveablePart.hookContentChangeListener(diffNode);
    }

    class CompareViewerPaneSite
    implements ISynchronizePageSite {
        ISelectionProvider selectionProvider;

        CompareViewerPaneSite() {
        }

        public IWorkbenchPage getPage() {
            return null;
        }

        public ISelectionProvider getSelectionProvider() {
            if (this.selectionProvider != null) {
                return this.selectionProvider;
            }
            return ParticipantPageSaveablePart.this.viewer;
        }

        public Shell getShell() {
            return ParticipantPageSaveablePart.this.dialogShell;
        }

        public IWorkbenchWindow getWorkbenchWindow() {
            return null;
        }

        public void setSelectionProvider(ISelectionProvider provider) {
            this.selectionProvider = provider;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public IWorkbenchSite getWorkbenchSite() {
            return null;
        }

        public IWorkbenchPart getPart() {
            return null;
        }

        public IKeyBindingService getKeyBindingService() {
            return null;
        }

        public void setFocus() {
        }

        public IDialogSettings getPageSettings() {
            return null;
        }

        public IActionBars getActionBars() {
            return ParticipantPageSaveablePart.this.getActionBars();
        }

        public boolean isModal() {
            return true;
        }
    }
}

