/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.ServiceTracker;

public class MinimalState {
    protected State fState = stateObjectFactory.createState();
    private String fTargetMode = null;
    protected long fId;
    private PluginConverter fConverter = null;
    private boolean fJavaProfileChanged = false;
    private String fJavaProfile;
    private String[] fJavaProfiles;
    private static final String SYSTEM_BUNDLE = "org.eclipse.osgi";
    protected static boolean DEBUG = false;
    protected static StateObjectFactory stateObjectFactory;
    protected static String DIR;
    static /* synthetic */ Class class$0;

    static {
        DEBUG = PDECore.getDefault().isDebugging() && "true".equals(Platform.getDebugOption((String)"org.eclipse.pde.core/cache"));
        DIR = PDECore.getDefault().getStateLocation().toOSString();
        stateObjectFactory = Platform.getPlatformAdmin().getFactory();
    }

    public MinimalState() {
        this.fState.setResolver(Platform.getPlatformAdmin().getResolver());
        this.fState.setPlatformProperties(TargetPlatform.getTargetEnvironment());
    }

    public void addBundle(IPluginModelBase model, boolean update) {
        BundleDescription desc;
        if (!update) {
            BundleDescription[] bundles = this.fState.getBundles(model.getPluginBase().getId());
            Path path = new Path(model.getInstallLocation());
            int i = 0;
            while (i < bundles.length) {
                if (ExternalModelManager.arePathsEqual((IPath)path, (IPath)new Path(bundles[i].getLocation()))) {
                    model.setBundleDescription(bundles[i]);
                    return;
                }
                ++i;
            }
        }
        long bundleId = (desc = model.getBundleDescription()) == null || !update ? -1L : desc.getBundleId();
        try {
            model.setBundleDescription(this.addBundle(new File(model.getInstallLocation()), false, bundleId));
        }
        catch (PluginConversionException pluginConversionException) {
        }
        catch (CoreException e) {
            PDECore.log(e);
        }
    }

    public BundleDescription addBundle(IPluginModelBase model, long bundleId) {
        try {
            return this.addBundle(new File(model.getInstallLocation()), false, -1L);
        }
        catch (PluginConversionException pluginConversionException) {
        }
        catch (CoreException coreException) {}
        return null;
    }

    public BundleDescription addBundle(Dictionary manifest, File bundleLocation, boolean keepLibraries, long bundleId) {
        try {
            BundleDescription descriptor = stateObjectFactory.createBundleDescription(this.fState, manifest, bundleLocation.getAbsolutePath(), bundleId == -1L ? this.getNextId() : bundleId);
            if (bundleId == -1L) {
                this.fState.addBundle(descriptor);
            } else if (!this.fState.updateBundle(descriptor)) {
                this.fState.addBundle(descriptor);
            }
            return descriptor;
        }
        catch (BundleException bundleException) {
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    public BundleDescription addBundle(File bundleLocation, boolean keepLibraries, long bundleId) throws PluginConversionException, CoreException {
        BundleDescription desc;
        Dictionary manifest = MinimalState.loadManifest(bundleLocation);
        if (manifest == null || manifest.get("Bundle-SymbolicName") == null) {
            if (!(bundleLocation.isFile() || new File(bundleLocation, "plugin.xml").exists() || new File(bundleLocation, "fragment.xml").exists())) {
                return null;
            }
            PluginConverter converter = this.acquirePluginConverter();
            manifest = converter.convertManifest(bundleLocation, false, this.getTargetMode(), false, null);
            if (manifest == null || manifest.get("Bundle-SymbolicName") == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 4, "Error parsing plug-in manifest file at " + bundleLocation.toString(), null));
            }
        }
        if ((desc = this.addBundle(manifest, bundleLocation, keepLibraries, bundleId)) != null && SYSTEM_BUNDLE.equals(desc.getSymbolicName())) {
            this.setJavaProfiles(bundleLocation);
        }
        return desc;
    }

    protected void saveState(File dir) {
        this.saveState(this.fState, dir);
    }

    protected void saveState(State state, File dir) {
        try {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            stateObjectFactory.writeState(state, dir);
        }
        catch (FileNotFoundException e) {
            PDECore.log(e);
        }
        catch (IOException e) {
            PDECore.log(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Dictionary loadManifest(File bundleLocation) {
        Object var4_4;
        Properties properties;
        InputStream manifestStream;
        ZipFile jarFile;
        block18: {
            jarFile = null;
            manifestStream = null;
            try {
                String extension = new Path(bundleLocation.getName()).getFileExtension();
                if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                    jarFile = new ZipFile(bundleLocation, 1);
                    ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                    if (manifestEntry != null) {
                        manifestStream = jarFile.getInputStream(manifestEntry);
                    }
                    break block18;
                }
                File file = new File(bundleLocation, "META-INF/MANIFEST.MF");
                if (file.exists()) {
                    manifestStream = new FileInputStream(file);
                }
            }
            catch (IOException iOException) {}
        }
        if (manifestStream == null) {
            return null;
        }
        try {
            try {
                Manifest m = new Manifest(manifestStream);
                properties = MinimalState.manifestToProperties(m.getMainAttributes());
                var4_4 = null;
            }
            catch (IOException iOException) {
                PDECore.log((IStatus)new Status(4, "org.eclipse.pde.core", 4, String.valueOf(PDECoreMessages.PDEState_invalidFormat) + bundleLocation.toString(), null));
                Dictionary dictionary = null;
                var4_4 = null;
                try {
                    manifestStream.close();
                }
                catch (IOException iOException2) {}
                try {
                    if (jarFile == null) return dictionary;
                    jarFile.close();
                    return dictionary;
                }
                catch (IOException iOException3) {}
                return dictionary;
            }
        }
        catch (Throwable throwable) {
            var4_4 = null;
            try {}
            catch (IOException iOException) {}
            manifestStream.close();
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            if (jarFile == null) throw throwable;
            jarFile.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        manifestStream.close();
        try {}
        catch (IOException iOException) {}
        if (jarFile == null) return properties;
        jarFile.close();
        return properties;
    }

    private static Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            result.put(key.toString(), d.get(key));
        }
        return result;
    }

    public void resolveState(boolean incremental) {
        this.internalResolveState(incremental);
    }

    private synchronized StateDelta internalResolveState(boolean incremental) {
        if (this.fJavaProfile == null) {
            this.fJavaProfile = this.getDefaultJavaProfile();
            this.fJavaProfileChanged = true;
        }
        if (this.fJavaProfileChanged) {
            incremental = !this.fState.setPlatformProperties(this.getProfilePlatformProperties());
            this.fJavaProfileChanged = false;
        }
        return this.fState.resolve(incremental);
    }

    private Dictionary getProfilePlatformProperties() {
        Dictionary props = TargetPlatform.getTargetEnvironment();
        String profile = this.getJavaProfilePackages();
        if (profile != null) {
            props.put("org.osgi.framework.system.packages", profile);
        }
        return props;
    }

    private File getOSGiLocation() {
        BundleDescription osgiBundle = this.fState.getBundle(SYSTEM_BUNDLE, null);
        return osgiBundle == null ? null : new File(osgiBundle.getLocation());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getJavaProfilePackages() {
        ZipFile zipFile;
        InputStream is;
        block24: {
            String string;
            block22: {
                if (this.fJavaProfile == null) {
                    return null;
                }
                File location = this.getOSGiLocation();
                if (location == null) {
                    return null;
                }
                is = null;
                zipFile = null;
                try {
                    try {
                        if (location.isDirectory()) {
                            is = new FileInputStream(new File(location, this.fJavaProfile));
                        } else {
                            zipFile = null;
                            try {
                                zipFile = new ZipFile(location, 1);
                                ZipEntry entry = zipFile.getEntry(this.fJavaProfile);
                                if (entry != null) {
                                    is = zipFile.getInputStream(entry);
                                }
                            }
                            catch (IOException iOException) {}
                        }
                        Properties profile = new Properties();
                        profile.load(is);
                        string = profile.getProperty("org.osgi.framework.system.packages");
                        Object var5_6 = null;
                        if (is == null) break block22;
                    }
                    catch (IOException iOException) {
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (zipFile == null) throw throwable;
                    try {
                        zipFile.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                is.close();
            }
            if (zipFile == null) return string;
            try {}
            catch (IOException iOException) {}
            zipFile.close();
            return string;
        }
        Object var5_8 = null;
        if (is != null) {
            try {}
            catch (IOException iOException) {}
            is.close();
        }
        if (zipFile == null) return null;
        try {}
        catch (IOException iOException) {
            return null;
        }
        zipFile.close();
        return null;
    }

    public String getDefaultJavaProfile() {
        if (this.fJavaProfiles == null) {
            this.setJavaProfiles(this.getOSGiLocation());
        }
        if (this.fJavaProfiles != null && this.fJavaProfiles.length > 0) {
            return this.fJavaProfiles[0];
        }
        return null;
    }

    public void removeBundleDescription(BundleDescription description) {
        this.fState.removeBundle(description);
    }

    public State getState() {
        return this.fState;
    }

    protected void setTargetMode(URL[] urls) {
        this.fTargetMode = "2.1";
        int i = 0;
        while (i < urls.length) {
            if (urls[i].getFile().indexOf(SYSTEM_BUNDLE) != -1) {
                this.fTargetMode = null;
                break;
            }
            ++i;
        }
    }

    public String getTargetMode() {
        return this.fTargetMode;
    }

    public void setTargetMode(String mode) {
        this.fTargetMode = mode;
    }

    private void setJavaProfiles(File bundleLocation) {
        if (bundleLocation == null) {
            return;
        }
        this.fJavaProfiles = bundleLocation.isDirectory() ? this.getDirJavaProfiles(bundleLocation) : this.getJarJavaProfiles(bundleLocation);
        if (this.fJavaProfiles != null) {
            Arrays.sort(this.fJavaProfiles, new Comparator(){

                public int compare(Object profile1, Object profile2) {
                    return -((String)profile1).compareTo(profile2);
                }
            });
        }
        if (this.fJavaProfile != null) {
            if (this.fJavaProfiles == null) {
                this.fJavaProfile = null;
            } else if (Arrays.binarySearch(this.fJavaProfiles, this.fJavaProfile) < 0) {
                this.fJavaProfile = null;
            }
        }
        this.fJavaProfileChanged = true;
    }

    private String[] getDirJavaProfiles(File bundleLocation) {
        String[] profiles = bundleLocation.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".profile");
            }
        });
        return profiles;
    }

    /*
     * Exception decompiling
     */
    private String[] getJarJavaProfiles(File bundleLocation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 115->118)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addBundleDescription(BundleDescription toAdd) {
        this.fState.addBundle(toAdd);
    }

    private PluginConverter acquirePluginConverter() {
        if (this.fConverter == null) {
            BundleContext bundleContext = PDECore.getDefault().getBundleContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.service.pluginconversion.PluginConverter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ServiceTracker tracker = new ServiceTracker(bundleContext, clazz.getName(), null);
            tracker.open();
            this.fConverter = (PluginConverter)tracker.getService();
            tracker.close();
        }
        return this.fConverter;
    }

    public long getNextId() {
        return ++this.fId;
    }

    private BundleDescription findActiveBundle(String symbolicName) {
        BundleDescription[] bundles = this.fState.getBundles(symbolicName);
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].isResolved()) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    protected void logResolutionErrors() {
        MultiStatus errors = new MultiStatus(PDECore.getPluginId(), 1, PDECoreMessages.ExternalModelManager_scanningProblems, null);
        StateHelper helper = Platform.getPlatformAdmin().getStateHelper();
        BundleDescription[] all = this.fState.getBundles();
        int i = 0;
        while (i < all.length) {
            if (!all[i].isResolved()) {
                String message;
                VersionConstraint[] unsatisfiedConstraints = helper.getUnsatisfiedConstraints(all[i]);
                if (unsatisfiedConstraints.length == 0) {
                    if (DEBUG) {
                        BundleDescription activeBundle = this.findActiveBundle(all[i].getSymbolicName());
                        message = "Plug-in located at \"" + all[i].getLocation() + "\" was disabled because plug-in located at \"" + activeBundle.getLocation() + "\" was selected.";
                        System.out.print(message);
                    }
                } else {
                    int j = 0;
                    while (j < unsatisfiedConstraints.length) {
                        message = this.getResolutionFailureMessage(unsatisfiedConstraints[j]);
                        if (message != null) {
                            errors.add((IStatus)new Status(2, all[i].getSymbolicName(), 2, message, null));
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (errors.getChildren().length > 0) {
            PDECore.log((IStatus)errors);
        }
    }

    private String getResolutionFailureMessage(VersionConstraint unsatisfied) {
        if (unsatisfied.isResolved()) {
            throw new IllegalArgumentException();
        }
        if (unsatisfied instanceof ImportPackageSpecification) {
            return "Missing imported package: " + this.toString(unsatisfied);
        }
        if (unsatisfied instanceof BundleSpecification && !((BundleSpecification)unsatisfied).isOptional()) {
            return "Missing required plug-in: " + this.toString(unsatisfied);
        }
        if (unsatisfied instanceof HostSpecification) {
            return "Missing Fragment Host: " + this.toString(unsatisfied);
        }
        return null;
    }

    private String toString(VersionConstraint constraint) {
        VersionRange versionRange = constraint.getVersionRange();
        if (versionRange == null || versionRange.getMinimum() != null) {
            return constraint.getName();
        }
        return String.valueOf(constraint.getName()) + '_' + versionRange;
    }
}

