/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ExternalJavaSearchClasspathContainer;
import org.eclipse.pde.internal.core.FileAdapter;
import org.eclipse.pde.internal.core.IFileAdapterFactory;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.util.CoreUtility;

public class SearchablePluginsManager
implements IFileAdapterFactory {
    private IJavaProject proxyProject;
    private PluginModelManager manager;
    private static final String PROXY_FILE_NAME = ".searchable";
    private static final String PROXY_PROJECT_NAME = "External Plug-in Libraries";
    private static final String KEY = "searchablePlugins";
    private Listener elementListener;
    private ExternalJavaSearchClasspathContainer classpathContainer;

    private String getProxyProjectName() {
        return PROXY_PROJECT_NAME;
    }

    public SearchablePluginsManager(PluginModelManager manager) {
        this.manager = manager;
        this.elementListener = new Listener();
    }

    public void initialize() {
        this.initializeProxyProject();
        if (this.proxyProject == null) {
            return;
        }
        IProject project = this.proxyProject.getProject();
        IFile proxyFile = project.getFile(PROXY_FILE_NAME);
        this.initializeStates(proxyFile);
        JavaCore.addElementChangedListener((IElementChangedListener)this.elementListener);
    }

    public void shutdown() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.elementListener);
    }

    private void initializeProxyProject() {
        IProject project = PDECore.getWorkspace().getRoot().getProject(this.getProxyProjectName());
        if (project == null) {
            return;
        }
        this.proxyProject = JavaCore.create((IProject)project);
    }

    private void initializeStates(IFile proxyFile) {
        if (!proxyFile.exists()) {
            return;
        }
        Properties properties = new Properties();
        try {
            InputStream stream = proxyFile.getContents(true);
            properties.load(stream);
            stream.close();
            String value = properties.getProperty(KEY);
            if (value == null) {
                return;
            }
            ArrayList<String> ids = new ArrayList<String>();
            StringTokenizer stok = new StringTokenizer(value, ",");
            while (stok.hasMoreTokens()) {
                ids.add(stok.nextToken());
            }
            this.initializeStates(ids);
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
    }

    private void initializeStates(ArrayList ids) {
        int i = 0;
        while (i < ids.size()) {
            String id = (String)ids.get(i);
            ModelEntry entry = this.manager.findEntry(id);
            if (entry != null) {
                entry.setInJavaSearch(true);
            }
            ++i;
        }
    }

    public void persistStates(IProgressMonitor monitor) throws CoreException {
        ModelEntry[] entries = this.manager.getEntries();
        StringBuffer buffer = new StringBuffer();
        monitor.beginTask(PDECoreMessages.SearchablePluginsManager_saving, 3);
        int counter = 0;
        int i = 0;
        while (i < entries.length) {
            ModelEntry entry = entries[i];
            if (entry.isInJavaSearch()) {
                if (counter++ > 0) {
                    buffer.append(",");
                }
                buffer.append(entry.getId());
            }
            ++i;
        }
        this.createProxyProject(monitor);
        if (this.proxyProject == null) {
            return;
        }
        monitor.worked(1);
        IFile file = this.proxyProject.getProject().getFile(PROXY_FILE_NAME);
        this.persistStates(file, buffer.toString(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.updateClasspathContainer();
    }

    public void updateClasspathContainer() {
        if (this.proxyProject == null) {
            return;
        }
        try {
            this.updateClasspathContainer(this.proxyProject);
        }
        catch (CoreException e) {
            PDECore.logException(e);
        }
    }

    public void updateClasspathContainer(IJavaProject project) throws CoreException {
        IJavaProject[] javaProjects = new IJavaProject[]{project};
        IClasspathContainer[] containers = new IClasspathContainer[]{this.getClasspathContainer()};
        Path path = new Path("org.eclipse.pde.core.externalJavaSearch");
        try {
            this.getClasspathContainer().reset();
            JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])javaProjects, (IClasspathContainer[])containers, null);
        }
        catch (OperationCanceledException e) {
            this.getClasspathContainer().reset();
            throw e;
        }
    }

    public ExternalJavaSearchClasspathContainer getClasspathContainer() {
        this.classpathContainer = new ExternalJavaSearchClasspathContainer(this);
        return this.classpathContainer;
    }

    public IClasspathEntry[] computeContainerClasspathEntries() throws CoreException {
        ArrayList result = new ArrayList();
        ModelEntry[] entries = this.manager.getEntries();
        int i = 0;
        while (i < entries.length) {
            block8: {
                ArrayList<IClasspathEntry> entryResult;
                block7: {
                    IPluginModelBase model;
                    ModelEntry entry;
                    block6: {
                        entry = entries[i];
                        entryResult = new ArrayList<IClasspathEntry>();
                        if (entry.getWorkspaceModel() == null) break block6;
                        IProject eproject = entry.getWorkspaceModel().getUnderlyingResource().getProject();
                        if (eproject.hasNature("org.eclipse.jdt.core.javanature")) {
                            IClasspathEntry pentry = JavaCore.newProjectEntry((IPath)eproject.getFullPath());
                            entryResult.add(pentry);
                        }
                        break block7;
                    }
                    if (!entry.isInJavaSearch() || (model = entry.getExternalModel()) == null) break block8;
                    ClasspathUtilCore.addLibraries(model, entryResult);
                }
                this.addUniqueEntries(result, entryResult);
            }
            ++i;
        }
        return result.toArray(new IClasspathEntry[result.size()]);
    }

    private void computeClasspath(ModelEntry[] entries, IJavaProject project, IProgressMonitor monitor) throws CoreException {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        list.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.externalJavaSearch")));
        list.add(ClasspathUtilCore.createJREEntry());
        try {
            project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), monitor);
        }
        catch (JavaModelException e) {
            this.throwCoreException(e);
        }
    }

    private void addUniqueEntries(ArrayList result, ArrayList localResult) {
        ArrayList resultCopy = (ArrayList)result.clone();
        int i = 0;
        while (i < localResult.size()) {
            IClasspathEntry localEntry = (IClasspathEntry)localResult.get(i);
            boolean duplicate = false;
            int j = 0;
            while (j < resultCopy.size()) {
                IClasspathEntry entry = (IClasspathEntry)resultCopy.get(j);
                if (entry.getEntryKind() == localEntry.getEntryKind() && entry.getContentKind() == localEntry.getContentKind() && entry.getPath().equals((Object)localEntry.getPath())) {
                    duplicate = true;
                    break;
                }
                ++j;
            }
            if (!duplicate) {
                result.add(localEntry);
            }
            ++i;
        }
    }

    private void persistStates(IFile file, String value, IProgressMonitor monitor) throws CoreException {
        Properties properties = new Properties();
        properties.setProperty(KEY, value);
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            properties.store(outStream, "");
            outStream.flush();
            outStream.close();
            ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
            if (file.exists()) {
                file.setContents((InputStream)inStream, true, false, monitor);
            } else {
                file.create((InputStream)inStream, true, monitor);
            }
            inStream.close();
        }
        catch (IOException e) {
            this.throwCoreException(e);
        }
    }

    private void throwCoreException(Throwable e) throws CoreException {
        Status status = new Status(4, "org.eclipse.pde.core", 0, e.getMessage(), e);
        throw new CoreException((IStatus)status);
    }

    private void createProxyProject(IProgressMonitor monitor) {
        IProject project = PDECore.getWorkspace().getRoot().getProject(this.getProxyProjectName());
        if (project.exists()) {
            return;
        }
        monitor.beginTask("", 5);
        try {
            project.create((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            CoreUtility.addNatureToProject(project, "org.eclipse.jdt.core.javanature", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.proxyProject = JavaCore.create((IProject)project);
            this.proxyProject.setOutputLocation(project.getFullPath(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.computeClasspath(this.manager.getEntries(), this.proxyProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (CoreException coreException) {}
    }

    private boolean handleDelta(IJavaElementDelta delta) {
        IJavaProject project;
        IJavaElement element = delta.getElement();
        if (element instanceof IJavaModel) {
            IJavaElementDelta[] projectDeltas = delta.getAffectedChildren();
            int i = 0;
            while (i < projectDeltas.length) {
                if (this.handleDelta(projectDeltas[i])) break;
                ++i;
            }
            return true;
        }
        if (delta.getElement() instanceof IJavaProject && (project = (IJavaProject)delta.getElement()).equals(this.proxyProject) && delta.getKind() == 2) {
            this.manager.searchablePluginsRemoved();
            this.proxyProject = null;
            return true;
        }
        return false;
    }

    public Object createAdapterChild(FileAdapter parent, File file) {
        IPackageFragmentRoot root;
        String name;
        if (!file.isDirectory() && (name = file.getName().toLowerCase(Locale.ENGLISH)).endsWith(".jar") && (root = this.findPackageFragmentRoot(file.getAbsolutePath())) != null) {
            return root;
        }
        return new FileAdapter(parent, file, this);
    }

    private IPackageFragmentRoot findPackageFragmentRoot(String absolutePath) {
        int i;
        Path jarPath = new Path(absolutePath);
        if (this.proxyProject != null) {
            try {
                IPackageFragmentRoot[] roots = this.proxyProject.getAllPackageFragmentRoots();
                i = 0;
                while (i < roots.length) {
                    IPackageFragmentRoot root = roots[i];
                    IPath path = root.getPath();
                    if (path.equals((Object)jarPath)) {
                        return root;
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        IPluginModelBase[] pluginModels = PDECore.getDefault().getModelManager().getWorkspaceModels();
        i = 0;
        while (i < pluginModels.length) {
            IProject project = pluginModels[i].getUnderlyingResource().getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                IPackageFragmentRoot[] roots = javaProject.getAllPackageFragmentRoots();
                int j = 0;
                while (j < roots.length) {
                    IPackageFragmentRoot root = roots[j];
                    IPath path = root.getPath();
                    if (path.equals((Object)jarPath)) {
                        return root;
                    }
                    ++j;
                }
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        return null;
    }

    public IJavaProject getProxyProject() {
        return this.proxyProject;
    }

    class Listener
    implements IElementChangedListener {
        Listener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            if (e.getType() == 1) {
                SearchablePluginsManager.this.handleDelta(e.getDelta());
            }
        }
    }
}

