/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.dnd;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.common.ui.internal.dnd.DefaultDragAndDropCommand;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DragNodeCommand
extends DefaultDragAndDropCommand {
    public DragNodeCommand(Object target, float location, int operations, int operation, Collection sources) {
        super(target, location, operations, operation, sources);
    }

    protected void beginModelChange(Node node, boolean batchUpdate) {
        IStructuredModel structuredModel = this.getStructedModel(node);
        if (structuredModel != null) {
            structuredModel.beginRecording((Object)this, XMLUIMessages.DragNodeCommand_0);
        }
    }

    public boolean canExecute() {
        return this.executeHelper(true);
    }

    public boolean doMove(Node source, Node parentNode, Node refChild, boolean testOnly) {
        boolean result = false;
        if (source.getNodeType() == 2) {
            Attr sourceAttribute = (Attr)source;
            Element sourceAttributeOwnerElement = sourceAttribute.getOwnerElement();
            if (parentNode.getNodeType() == 1 && sourceAttributeOwnerElement != parentNode) {
                result = true;
                if (!testOnly) {
                    try {
                        Element targetElement = (Element)parentNode;
                        targetElement.setAttribute(sourceAttribute.getName(), sourceAttribute.getValue());
                        sourceAttributeOwnerElement.removeAttributeNode(sourceAttribute);
                    }
                    catch (Exception exception) {}
                }
            }
        } else if (!(parentNode.getNodeType() != 1 && parentNode.getNodeType() != 9 || refChild instanceof Attr)) {
            result = true;
            if (!testOnly && !this.isAncestor(source, parentNode) && source != refChild) {
                source.getParentNode().removeChild(source);
                parentNode.insertBefore(source, refChild);
            }
        }
        return result;
    }

    protected void endModelChange(Node node, boolean batchUpdate) {
        IStructuredModel structuredModel = this.getStructedModel(node);
        if (structuredModel != null) {
            structuredModel.endRecording((Object)this);
        }
    }

    public void execute() {
        this.executeHelper(false);
    }

    public boolean executeHelper(boolean testOnly) {
        boolean result = true;
        if (this.target instanceof Node) {
            boolean performBatchUpdate;
            Node targetNode = (Node)this.target;
            Node parentNode = this.getParentForDropPosition(targetNode);
            Node refChild = this.getRefChild(targetNode);
            Vector sourcesList = new Vector();
            sourcesList.addAll(this.sources);
            this.removeMemberDescendants(sourcesList);
            boolean bl = performBatchUpdate = sourcesList.size() > 5;
            if (!testOnly) {
                this.beginModelChange(targetNode, performBatchUpdate);
            }
            Iterator i = sourcesList.iterator();
            while (i.hasNext()) {
                Object source = i.next();
                if (source instanceof Node && !(result = refChild != null || !(targetNode instanceof Attr) ? this.doMove((Node)source, parentNode, refChild, testOnly) : false)) break;
            }
            if (!testOnly) {
                this.endModelChange(targetNode, performBatchUpdate);
            }
        } else {
            result = false;
        }
        return result;
    }

    public int getFeedback() {
        int result = 1;
        if ((double)this.location > 0.75) {
            result = 4;
        } else if ((double)this.location < 0.25) {
            result = 2;
        }
        return result;
    }

    protected Node getParentForDropPosition(Node node) {
        Node result = null;
        int feedback = this.getFeedback();
        result = feedback == 1 ? node : this.getParentOrOwner(node);
        return result;
    }

    protected Node getParentOrOwner(Node node) {
        return node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : node.getParentNode();
    }

    protected Node getRefChild(Node node) {
        Node result = null;
        int feedback = this.getFeedback();
        if (feedback == 2) {
            result = node;
        } else if (feedback == 4) {
            result = node.getNextSibling();
        }
        return result;
    }

    protected IStructuredModel getStructedModel(Node node) {
        IDOMModel result = null;
        if (node instanceof IDOMNode) {
            result = ((IDOMNode)node).getModel();
        }
        return result;
    }

    protected boolean isAncestor(Node a, Node b) {
        boolean result = false;
        Node parent = b;
        while (parent != null) {
            if (parent == a) {
                result = true;
                break;
            }
            parent = parent.getParentNode();
        }
        return result;
    }

    protected void removeMemberDescendants(List list) {
        Object node;
        Hashtable table = new Hashtable();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            node = i.next();
            table.put(node, node);
        }
        int i2 = list.size() - 1;
        while (i2 >= 0) {
            node = (Node)list.get(i2);
            Node parent = this.getParentOrOwner((Node)node);
            while (parent != null) {
                if (table.get(parent) != null) {
                    list.remove(i2);
                    break;
                }
                parent = this.getParentOrOwner(parent);
            }
            --i2;
        }
    }
}

