/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.taginfo;

import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocumentation;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDescriptionBuilder;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public class MarkupTagInfoProvider {
    protected static final String BOLD_END = "</b>";
    protected static final String BOLD_START = "<b>";
    protected static final String HEADING_END = "</h5>";
    protected static final String HEADING_START = "<h5>";
    protected static final String LIST_BEGIN = "<ul>";
    protected static final String LIST_ELEMENT = "<li>";
    protected static final String NEW_LINE = "<dl>";
    protected static final String PARAGRAPH_END = "</p>";
    protected static final String PARAGRAPH_START = "<p>";
    protected static final String SPACE = " ";

    public String getInfo(CMNode node) {
        if (node == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        this.printTagInfo(sb, node);
        if (sb.length() == 0) {
            this.printDescription(sb, node);
        }
        if (sb.length() == 0) {
            this.printDefaultInfo(node, sb);
        }
        return sb.toString();
    }

    protected void printDataTypeInfo(StringBuffer sb, CMDataType dataType) {
        String[] enumeratedValue;
        String dataTypeName = dataType.getNodeName();
        if (dataTypeName != null && dataTypeName.length() > 0) {
            sb.append("<p><b>" + XMLUIMessages.Data_Type____4 + SPACE + BOLD_END);
            sb.append(dataTypeName);
            sb.append(PARAGRAPH_END);
        }
        if ((enumeratedValue = dataType.getEnumeratedValues()) != null && enumeratedValue.length > 0) {
            sb.append("<p><b>" + XMLUIMessages.Enumerated_Values____5 + SPACE + BOLD_END);
            sb.append(LIST_BEGIN);
            int i = 0;
            while (i < enumeratedValue.length) {
                sb.append(LIST_ELEMENT + enumeratedValue[i]);
                ++i;
            }
            sb.append(PARAGRAPH_END);
        }
    }

    protected void printDefaultInfo(CMNode node, StringBuffer sb) {
        if (node.getNodeType() == 5) {
            CMElementDeclaration ed = (CMElementDeclaration)node;
            sb.append("<p><b>" + XMLUIMessages.Element____1 + SPACE + BOLD_END);
            sb.append(node.getNodeName());
            sb.append(PARAGRAPH_END);
            if (ed.getContentType() == 4) {
                CMDataType dataType = ed.getDataType();
                if (dataType != null) {
                    this.printDataTypeInfo(sb, dataType);
                }
            } else {
                CMDescriptionBuilder builder = new CMDescriptionBuilder();
                String description = builder.buildDescription(node);
                if (description != null && description.length() > 0) {
                    sb.append("<p><b>" + XMLUIMessages.Content_Model____2 + SPACE + BOLD_END);
                    sb.append(String.valueOf(description) + PARAGRAPH_END);
                }
            }
            this.printDocumentation(sb, node);
        } else if (node.getNodeType() == 2) {
            CMAttributeDeclaration ad = (CMAttributeDeclaration)node;
            sb.append("<p><b>" + XMLUIMessages.Attribute____3 + SPACE + BOLD_END);
            sb.append(node.getNodeName());
            sb.append(PARAGRAPH_END);
            CMDataType dataType = ad.getAttrType();
            if (dataType != null) {
                this.printDataTypeInfo(sb, dataType);
            }
            this.printDocumentation(sb, node);
        } else if (node.getNodeType() == 3) {
            sb.append("<p><b>" + XMLUIMessages.Data_Type____4 + SPACE + BOLD_END);
            sb.append(node.getNodeName());
            sb.append(PARAGRAPH_END);
            this.printDocumentation(sb, node);
        }
    }

    protected void printDescription(StringBuffer sb, CMNode node) {
        String tagInfo = (String)node.getProperty("description");
        if (tagInfo != null) {
            sb.append(PARAGRAPH_START + tagInfo.trim() + PARAGRAPH_END);
        }
    }

    protected void printDocumentation(StringBuffer sb, CMNode node) {
        CMNodeList nodeList = (CMNodeList)node.getProperty("documentation");
        if (nodeList != null && nodeList.getLength() > 0) {
            sb.append(NEW_LINE);
            int i = 0;
            while (i < nodeList.getLength()) {
                CMDocumentation documentation = (CMDocumentation)nodeList.item(i);
                String doc = documentation.getValue();
                if (doc != null) {
                    sb.append(PARAGRAPH_START + doc.trim() + PARAGRAPH_END);
                }
                ++i;
            }
        }
    }

    protected void printTagInfo(StringBuffer sb, CMNode node) {
        String tagInfo = (String)node.getProperty("tagInfo");
        if (tagInfo != null) {
            sb.append(PARAGRAPH_START + tagInfo.trim() + PARAGRAPH_END);
        }
    }
}

