/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.navigator.internal;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.common.navigator.internal.providers.CommonAdapterFactoryContentProvider;
import org.eclipse.jst.j2ee.internal.ejb.provider.BeanClassProviderHelper;
import org.eclipse.jst.j2ee.internal.provider.MethodsProviderDelegate;
import org.eclipse.jst.j2ee.navigator.internal.EMFRootObjectProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.internal.emfworkbench.integration.DynamicAdapterFactory;
import org.eclipse.wst.common.navigator.internal.provisional.views.AdaptabilityUtility;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;

public class J2EEContentProvider
implements ITreeContentProvider,
EMFRootObjectProvider.IRefreshHandlerListener {
    private static final Class IPROJECT_CLASS;
    private final EMFRootObjectProvider rootObjectProvider = new EMFRootObjectProvider();
    private AdapterFactoryContentProvider delegateContentProvider;
    private MethodsProviderDelegate delegateMethodsProvider;
    private String viewerId = null;
    Viewer viewer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IPROJECT_CLASS = clazz;
    }

    public J2EEContentProvider() {
        this.rootObjectProvider.addRefreshHandlerListener(this);
    }

    public J2EEContentProvider(String aViewerId) {
        this.updateContentProviders(aViewerId);
        this.rootObjectProvider.addRefreshHandlerListener(this);
    }

    public Object[] getElements(Object anInputElement) {
        return this.getChildren(anInputElement);
    }

    public Object[] getChildren(Object aParentElement) {
        IProject project = null;
        ArrayList<Object> children = new ArrayList<Object>();
        if (aParentElement instanceof IProject || aParentElement instanceof IJavaProject) {
            project = (IProject)((IAdaptable)aParentElement).getAdapter(IPROJECT_CLASS);
            if (project != null) {
                Object[] rootObjects;
                Object[] objectArray = rootObjects = this.rootObjectProvider != null ? this.rootObjectProvider.getModels(project) : null;
                if (rootObjects != null) {
                    int x = 0;
                    while (x < rootObjects.length) {
                        children.add(rootObjects[x]);
                        ++x;
                    }
                }
            }
        } else {
            if (MethodsProviderDelegate.providesContentFor((Object)aParentElement)) {
                return this.delegateMethodsProvider.getChildren(aParentElement);
            }
            Object[] siblings = this.delegateContentProvider.getChildren(aParentElement);
            if (siblings != null) {
                children.addAll(Arrays.asList(siblings));
            }
        }
        return children.toArray();
    }

    public Object getParent(Object object) {
        if (MethodsProviderDelegate.providesContentFor((Object)object)) {
            return this.delegateMethodsProvider.getParent(object);
        }
        Object parent = this.delegateContentProvider.getParent(object);
        if (parent == null && object instanceof BeanClassProviderHelper) {
            parent = ((BeanClassProviderHelper)object).getEjb();
        }
        if (parent == null && object instanceof EObject) {
            parent = ProjectUtilities.getProject((EObject)((EObject)object));
        }
        return parent;
    }

    public void dispose() {
        this.rootObjectProvider.removeRefreshHandlerListener(this);
        this.delegateContentProvider.dispose();
        this.rootObjectProvider.dispose();
        this.delegateMethodsProvider.dispose();
    }

    public boolean hasChildren(Object element) {
        if (MethodsProviderDelegate.providesContentFor((Object)element)) {
            return this.delegateMethodsProvider.hasChildren(element);
        }
        return this.delegateContentProvider.hasChildren(element);
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        String newViewerId = null;
        this.viewer = aViewer;
        if (aViewer instanceof CommonViewer) {
            newViewerId = ((CommonViewer)aViewer).getNavigatorContentService().getViewerId();
        }
        if (!(newViewerId == null || this.viewerId != null && this.viewerId.equals(newViewerId))) {
            this.updateContentProviders(newViewerId);
        }
        this.delegateContentProvider.inputChanged(aViewer, anOldInput, aNewInput);
        this.delegateMethodsProvider.inputChanged(aViewer, anOldInput, aNewInput);
    }

    private void updateContentProviders(String aViewerId) {
        if (this.delegateContentProvider != null) {
            this.delegateContentProvider.dispose();
        }
        if (this.delegateMethodsProvider != null) {
            this.delegateMethodsProvider.dispose();
        }
        DynamicAdapterFactory adapterFactory = new DynamicAdapterFactory(aViewerId);
        this.delegateContentProvider = new CommonAdapterFactoryContentProvider((AdapterFactory)adapterFactory);
        this.delegateMethodsProvider = new MethodsProviderDelegate((AdapterFactory)adapterFactory);
        this.viewerId = aViewerId;
    }

    public void onRefresh(final Object element) {
        if (this.viewer instanceof AbstractTreeViewer) {
            if (Display.getCurrent() != null) {
                ((AbstractTreeViewer)this.viewer).refresh(element, true);
            } else {
                UIJob job = new UIJob("Update the Navigator Content Viewer Job"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ((AbstractTreeViewer)J2EEContentProvider.this.viewer).refresh(element, true);
                        return Status.OK_STATUS;
                    }
                };
                if (element instanceof ISchedulingRule) {
                    job.setRule((ISchedulingRule)element);
                } else {
                    ISchedulingRule rule;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.core.runtime.jobs.ISchedulingRule");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((rule = (ISchedulingRule)AdaptabilityUtility.getAdapter((Object)element, (Class)clazz)) != null) {
                        job.setRule(rule);
                    }
                }
                job.schedule();
            }
        }
    }
}

