/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jem.internal.proxy.core.Expression;
import org.eclipse.jem.internal.proxy.core.ExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IInvokable;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IProxyBeanType;
import org.eclipse.jem.internal.proxy.core.IProxyField;
import org.eclipse.jem.internal.proxy.core.IProxyMethod;
import org.eclipse.jem.internal.proxy.remote.IREMBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMAbstractBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMExpression;
import org.eclipse.jem.internal.proxy.remote.REMFieldProxy;
import org.eclipse.jem.internal.proxy.remote.REMMethodProxy;
import org.eclipse.jem.internal.proxy.remote.REMMethodProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyConstants;

public class REMProxyConstants {
    private Map methodsCache = new HashMap(80);
    private Map invokablesCache = new HashMap(80);
    private Map fieldsCache = new HashMap(80);
    private REMProxyFactoryRegistry registry;
    static int REMMETHODCOUNT = 0;
    static int UNIQUEMETHODCOUNT = 0;
    static int REMINVOKABLECOUNT = 0;
    static int UNIQUEINVOKABLECOUNT = 0;
    static int INVOKEINVOKECOUNT = 0;
    static int METHODPROXYINVOKECOUNT = 0;
    static int REMFIELDCOUNT = 0;
    static int UNIQUEFIELDCOUNT = 0;
    static int REMCONSTRUCTORCALLED = 0;
    static HashMap METHODCOUNTMAP;
    static HashMap FIELDCOUNTMAP;
    static HashMap FIELDSETCOUNTMAP;
    static boolean GATHER_COUNTS;

    public REMProxyConstants(REMProxyFactoryRegistry registry) {
        this.registry = registry;
    }

    public static void setGatherCounts(boolean gatherCounts) {
        if (gatherCounts != GATHER_COUNTS) {
            REMProxyConstants.reset();
            if (gatherCounts && METHODCOUNTMAP == null) {
                METHODCOUNTMAP = new HashMap();
                FIELDCOUNTMAP = new HashMap();
                FIELDSETCOUNTMAP = new HashMap();
            }
            GATHER_COUNTS = gatherCounts;
        }
    }

    public static void reset() {
        UNIQUEFIELDCOUNT = 0;
        REMFIELDCOUNT = 0;
        INVOKEINVOKECOUNT = 0;
        METHODPROXYINVOKECOUNT = 0;
        REMCONSTRUCTORCALLED = 0;
        UNIQUEINVOKABLECOUNT = 0;
        REMINVOKABLECOUNT = 0;
        UNIQUEMETHODCOUNT = 0;
        REMMETHODCOUNT = 0;
        if (GATHER_COUNTS) {
            METHODCOUNTMAP.clear();
            FIELDCOUNTMAP.clear();
            FIELDSETCOUNTMAP.clear();
        }
    }

    public static void println() {
        if (GATHER_COUNTS) {
            REMFieldProxy fieldProxy;
            Map.Entry entry;
            System.out.println("--------------------------------------------------");
            System.out.println("Method proxies invokes = " + METHODPROXYINVOKECOUNT);
            System.out.println("Invoke invokes = " + INVOKEINVOKECOUNT);
            System.out.println("..................................................");
            System.out.println("Methods retrieved = " + REMMETHODCOUNT + "(" + UNIQUEMETHODCOUNT + ")");
            System.out.println("Invokes retrieved = " + REMINVOKABLECOUNT + "(" + UNIQUEINVOKABLECOUNT + ")");
            System.out.println("Fields retrieved = " + REMFIELDCOUNT + "(" + UNIQUEFIELDCOUNT + ")");
            System.out.println("Constructor calls = " + REMCONSTRUCTORCALLED);
            System.out.println("--------------------------------------------------");
            System.out.println("-Count of methods invoked-------------------------");
            System.out.println("--------------------------------------------------");
            Iterator entries = METHODCOUNTMAP.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                REMMethodProxy methodProxy = (REMMethodProxy)entry.getKey();
                System.out.println(String.valueOf(methodProxy.getClassType().getTypeName()) + "," + methodProxy.getName() + "," + entry.getValue());
            }
            System.out.println("--------------------------------------------------");
            System.out.println("-Count of fields get called ----------------------");
            System.out.println("--------------------------------------------------");
            entries = FIELDCOUNTMAP.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                fieldProxy = (REMFieldProxy)entry.getKey();
                System.out.println(String.valueOf(fieldProxy.toBeanString()) + "," + entry.getValue());
            }
            System.out.println("--------------------------------------------------");
            System.out.println("-Count of fields set called ----------------------");
            System.out.println("--------------------------------------------------");
            entries = FIELDSETCOUNTMAP.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                fieldProxy = (REMFieldProxy)entry.getKey();
                System.out.println(String.valueOf(fieldProxy.toBeanString()) + "," + entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMethodProxy getMethodProxy(IBeanTypeProxy aBeanTypeProxy, String methodName, String[] parmTypes) {
        IMethodProxy result;
        Object key;
        Map methods;
        if (!this.registry.isValid()) {
            return null;
        }
        ++REMMETHODCOUNT;
        REMProxyConstants rEMProxyConstants = this;
        synchronized (rEMProxyConstants) {
            methods = this.getMethods((IProxyBeanType)aBeanTypeProxy);
            key = parmTypes == null || parmTypes.length == 0 ? methodName : new MethodKeyStringParms(methodName, parmTypes);
            result = (IMethodProxy)methods.get(key);
            if (result != null) {
                return result;
            }
        }
        ++UNIQUEMETHODCOUNT;
        REMMethodProxyFactory proxyFactory = (REMMethodProxyFactory)this.registry.getMethodProxyFactory();
        result = proxyFactory.getMethodProxy((IREMBeanTypeProxy)aBeanTypeProxy, methodName, parmTypes);
        REMProxyConstants rEMProxyConstants2 = this;
        synchronized (rEMProxyConstants2) {
            IMethodProxy mValue = (IMethodProxy)methods.get(key);
            if (mValue != null && mValue != result) {
                this.registry.releaseProxy((IBeanProxy)result);
                return mValue;
            }
            methods.put(key, result);
        }
        return result;
    }

    private Map getMethods(IProxyBeanType aBeanTypeProxy) {
        HashMap methods = (HashMap)this.methodsCache.get(aBeanTypeProxy.getTypeName());
        if (methods == null) {
            methods = new HashMap(20);
            this.methodsCache.put(aBeanTypeProxy.getTypeName(), methods);
        }
        return methods;
    }

    private Map getInvokables(IBeanTypeProxy aBeanTypeProxy) {
        HashMap invokables = (HashMap)this.invokablesCache.get(aBeanTypeProxy);
        if (invokables == null) {
            invokables = new HashMap(20);
            this.invokablesCache.put(aBeanTypeProxy, invokables);
        }
        return invokables;
    }

    private Map getFields(IProxyBeanType aBeanTypeProxy) {
        HashMap fields = (HashMap)this.fieldsCache.get(aBeanTypeProxy.getTypeName());
        if (fields == null) {
            fields = new HashMap(20);
            this.fieldsCache.put(aBeanTypeProxy.getTypeName(), fields);
        }
        return fields;
    }

    public IInvokable getInvokable(IBeanTypeProxy aBeanTypeProxy, String invokableName, String[] parmTypeNames) {
        ++REMINVOKABLECOUNT;
        Map invokables = this.getInvokables(aBeanTypeProxy);
        Object key = null;
        key = parmTypeNames == null || parmTypeNames.length == 0 ? invokableName : new MethodKeyStringParms(invokableName, parmTypeNames);
        IInvokable result = (IInvokable)invokables.get(key);
        if (result != null) {
            return result;
        }
        ++UNIQUEINVOKABLECOUNT;
        REMMethodProxyFactory proxyFactory = (REMMethodProxyFactory)aBeanTypeProxy.getProxyFactoryRegistry().getMethodProxyFactory();
        result = proxyFactory.getInvokable((IREMBeanTypeProxy)aBeanTypeProxy, invokableName, parmTypeNames);
        invokables.put(key, result);
        return result;
    }

    public IInvokable getInvokable(IBeanTypeProxy aBeanTypeProxy, String invokableName, IBeanTypeProxy[] parmTypes) {
        ++REMINVOKABLECOUNT;
        Map invokables = this.getInvokables(aBeanTypeProxy);
        Object key = null;
        key = parmTypes == null || parmTypes.length == 0 ? invokableName : new MethodKeyProxyParms(invokableName, (IProxyBeanType[])parmTypes);
        IInvokable result = (IInvokable)invokables.get(key);
        if (result != null) {
            return result;
        }
        ++UNIQUEINVOKABLECOUNT;
        REMMethodProxyFactory proxyFactory = (REMMethodProxyFactory)aBeanTypeProxy.getProxyFactoryRegistry().getMethodProxyFactory();
        result = proxyFactory.getInvokable((IREMBeanTypeProxy)aBeanTypeProxy, invokableName, parmTypes);
        invokables.put(key, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMethodProxy getMethodProxy(IBeanTypeProxy aBeanTypeProxy, String methodName, IBeanTypeProxy[] parmTypes) {
        IMethodProxy result;
        Object key;
        Map methods;
        if (!this.registry.isValid()) {
            return null;
        }
        ++REMMETHODCOUNT;
        REMProxyConstants rEMProxyConstants = this;
        synchronized (rEMProxyConstants) {
            methods = this.getMethods((IProxyBeanType)aBeanTypeProxy);
            key = null;
            key = parmTypes == null || parmTypes.length == 0 ? methodName : new MethodKeyProxyParms(methodName, (IProxyBeanType[])parmTypes);
            result = (IMethodProxy)methods.get(key);
            if (result != null) {
                return result;
            }
        }
        ++UNIQUEMETHODCOUNT;
        REMMethodProxyFactory proxyFactory = (REMMethodProxyFactory)this.registry.getMethodProxyFactory();
        result = proxyFactory.getMethodProxy((IREMBeanTypeProxy)aBeanTypeProxy, methodName, parmTypes);
        REMProxyConstants rEMProxyConstants2 = this;
        synchronized (rEMProxyConstants2) {
            IMethodProxy mValue = (IMethodProxy)methods.get(key);
            if (mValue != null && mValue != result) {
                this.registry.releaseProxy((IBeanProxy)result);
                return mValue;
            }
            methods.put(key, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProxyMethod getMethodProxy(IExpression expression, IProxyBeanType aBeanTypeProxy, String methodName, IProxyBeanType[] parmTypes) {
        Map epMethods;
        boolean isKey;
        Object key;
        Map methods;
        if (!this.registry.isValid()) {
            return null;
        }
        ++REMMETHODCOUNT;
        REMProxyConstants rEMProxyConstants = this;
        synchronized (rEMProxyConstants) {
            methods = this.getMethods(aBeanTypeProxy);
            if (parmTypes == null || parmTypes.length == 0) {
                key = methodName;
                isKey = false;
            } else {
                key = new MethodKeyProxyParms(methodName, parmTypes);
                isKey = true;
            }
            IProxyMethod result = (IProxyMethod)methods.get(key);
            if (result != null) {
                return result;
            }
            epMethods = ((REMExpression)expression).getMethods(aBeanTypeProxy);
            result = (IProxyMethod)epMethods.get(key);
            if (result != null) {
                return result;
            }
        }
        ++UNIQUEMETHODCOUNT;
        IProxyMethod result = ((Expression)expression).createMethodExpressionProxy(aBeanTypeProxy, methodName, parmTypes);
        epMethods.put(key, result);
        final Object epKey = key;
        final Map rMethods = methods;
        final Map fepMethods = epMethods;
        final boolean isKeyType = isKey;
        ((ExpressionProxy)result).addProxyListener((ExpressionProxy.ProxyListener)new ExpressionProxy.ProxyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                REMProxyConstants rEMProxyConstants = REMProxyConstants.this;
                synchronized (rEMProxyConstants) {
                    if (rMethods.containsKey(epKey)) {
                        return;
                    }
                    Object key = isKeyType ? ((MethodKeyProxyParms)epKey).toMethodKeyStringParms() : epKey;
                    rMethods.put(key, event.getProxy());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
                REMProxyConstants rEMProxyConstants = REMProxyConstants.this;
                synchronized (rEMProxyConstants) {
                    fepMethods.remove(epKey);
                }
            }
        });
        return result;
    }

    static void methodInvoked(REMMethodProxy proxy) {
        if (GATHER_COUNTS) {
            Integer count = (Integer)METHODCOUNTMAP.get(proxy);
            if (count == null) {
                METHODCOUNTMAP.put(proxy, new Integer(1));
            } else {
                METHODCOUNTMAP.put(proxy, new Integer(count + 1));
            }
        }
    }

    static void fieldGetInvoked(IBeanProxy proxy) {
        if (GATHER_COUNTS) {
            Integer count = (Integer)FIELDCOUNTMAP.get(proxy);
            if (count == null) {
                FIELDCOUNTMAP.put(proxy, new Integer(1));
            } else {
                FIELDCOUNTMAP.put(proxy, new Integer(count + 1));
            }
        }
    }

    static void fieldSetInvoked(IBeanProxy proxy, IBeanProxy value) {
        if (GATHER_COUNTS) {
            Integer count = (Integer)FIELDSETCOUNTMAP.get(proxy);
            if (count == null) {
                FIELDSETCOUNTMAP.put(proxy, new Integer(1));
            } else {
                FIELDSETCOUNTMAP.put(proxy, new Integer(count + 1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFieldProxy getFieldProxy(REMAbstractBeanTypeProxy aBeanTypeProxy, String fieldName) {
        Map fields;
        if (!this.registry.isValid()) {
            return null;
        }
        ++REMFIELDCOUNT;
        REMProxyConstants rEMProxyConstants = this;
        synchronized (rEMProxyConstants) {
            fields = this.getFields((IProxyBeanType)aBeanTypeProxy);
            IFieldProxy result = (IFieldProxy)fields.get(fieldName);
            if (result != null) {
                return result;
            }
        }
        ++UNIQUEFIELDCOUNT;
        IFieldProxy result = (IFieldProxy)REMStandardBeanProxyConstants.getConstants(aBeanTypeProxy.getProxyFactoryRegistry()).getClassGetField().invokeCatchThrowableExceptions((IBeanProxy)aBeanTypeProxy, (IBeanProxy)this.registry.getBeanProxyFactory().createBeanProxyWith(fieldName));
        REMProxyConstants rEMProxyConstants2 = this;
        synchronized (rEMProxyConstants2) {
            IFieldProxy fValue = (IFieldProxy)fields.get(fieldName);
            if (fValue != null) {
                this.registry.releaseProxy((IBeanProxy)result);
                return fValue;
            }
            fields.put(fieldName, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProxyField getFieldProxy(IExpression expression, IProxyBeanType aBeanTypeProxy, final String fieldName) {
        Map epFields;
        Map fields;
        if (!this.registry.isValid()) {
            return null;
        }
        ++REMFIELDCOUNT;
        REMProxyConstants rEMProxyConstants = this;
        synchronized (rEMProxyConstants) {
            fields = this.getFields(aBeanTypeProxy);
            IProxyField result = (IProxyField)fields.get(fieldName);
            if (result != null) {
                return result;
            }
            epFields = ((REMExpression)expression).getFields(aBeanTypeProxy);
            result = (IProxyField)epFields.get(fieldName);
            if (result != null) {
                return result;
            }
        }
        ++UNIQUEFIELDCOUNT;
        IProxyField result = ((REMExpression)expression).createFieldExpressionProxy(aBeanTypeProxy, fieldName);
        epFields.put(fieldName, result);
        final Map fpFields = fields;
        final Map fepFields = epFields;
        ((ExpressionProxy)result).addProxyListener((ExpressionProxy.ProxyListener)new ExpressionProxy.ProxyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                REMProxyConstants rEMProxyConstants = REMProxyConstants.this;
                synchronized (rEMProxyConstants) {
                    if (fpFields.containsKey(fieldName)) {
                        return;
                    }
                    fpFields.put(fieldName, event.getProxy());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
                REMProxyConstants rEMProxyConstants = REMProxyConstants.this;
                synchronized (rEMProxyConstants) {
                    fepFields.remove(fieldName);
                }
            }
        });
        return result;
    }

    private static abstract class MethodKey {
        public String methodName;

        public MethodKey(String methodName) {
            this.methodName = methodName;
        }

        protected abstract boolean compareParms(IProxyBeanType[] var1);

        protected abstract boolean compareParms(String[] var1);

        public int hashCode() {
            return this.methodName.hashCode();
        }
    }

    private static class MethodKeyStringParms
    extends MethodKey {
        public String[] parmNames;

        public MethodKeyStringParms(String methodName, String[] parmNames) {
            super(methodName);
            this.parmNames = parmNames;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            try {
                return ((MethodKey)obj).compareParms(this.parmNames);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            int h = super.hashCode();
            int i = 0;
            while (i < this.parmNames.length) {
                h += this.parmNames[i].hashCode();
                ++i;
            }
            return h;
        }

        protected boolean compareParms(IProxyBeanType[] parms) {
            if (parms.length != this.parmNames.length) {
                return false;
            }
            int i = 0;
            while (i < parms.length) {
                if (!parms[i].getTypeName().equals(this.parmNames[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected boolean compareParms(String[] parms) {
            return Arrays.equals(parms, this.parmNames);
        }
    }

    private static class MethodKeyProxyParms
    extends MethodKey {
        public IProxyBeanType[] parmTypes;

        public MethodKeyProxyParms(String methodName, IProxyBeanType[] parmTypes) {
            super(methodName);
            this.parmTypes = parmTypes;
        }

        public Object toMethodKeyStringParms() {
            String[] parms = new String[this.parmTypes.length];
            int i = 0;
            while (i < this.parmTypes.length) {
                parms[i] = this.parmTypes[i].getTypeName();
                ++i;
            }
            return new MethodKeyStringParms(this.methodName, parms);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            try {
                return ((MethodKey)obj).compareParms(this.parmTypes);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            int h = super.hashCode();
            int i = 0;
            while (i < this.parmTypes.length) {
                h += this.parmTypes[i].getTypeName().hashCode();
                ++i;
            }
            return h;
        }

        protected boolean compareParms(String[] parms) {
            if (parms.length != this.parmTypes.length) {
                return false;
            }
            int i = 0;
            while (i < parms.length) {
                if (!this.parmTypes[i].getTypeName().equals(parms[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected boolean compareParms(IProxyBeanType[] parms) {
            if (parms.length != this.parmTypes.length) {
                return false;
            }
            int i = 0;
            while (i < parms.length) {
                if (!this.parmTypes[i].getTypeName().equals(parms[i].getTypeName())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

