/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;

public class BuildSetAction
extends Action {
    public static BuildSetAction lastBuilt;
    private IWorkingSet workingSet;
    private IWorkbenchWindow window;
    private IActionBarConfigurer actionBars;

    public BuildSetAction(IWorkingSet set, IWorkbenchWindow window, IActionBarConfigurer actionBars) {
        super(set == null ? "" : set.getName(), 8);
        this.window = window;
        this.actionBars = actionBars;
        this.workingSet = set;
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    public void run() {
        this.setActionDefinitionId("org.eclipse.ui.project.buildLast");
        this.actionBars.registerGlobalAction((IAction)this);
        this.window.getWorkbench().getWorkingSetManager().addRecentWorkingSet(this.workingSet);
        Object[] projects = BuildUtilities.extractProjects(this.workingSet.getElements());
        if (projects.length == 0) {
            MessageDialog.openInformation((Shell)this.window.getShell(), (String)IDEWorkbenchMessages.BuildSetAction_noBuildTitle, (String)IDEWorkbenchMessages.BuildSetAction_noProjects);
            return;
        }
        lastBuilt = this;
        BuildAction build = new BuildAction(this.window.getShell(), 10);
        build.selectionChanged((IStructuredSelection)new StructuredSelection(projects));
        build.run();
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof MenuItem && !((MenuItem)event.widget).getSelection()) {
            return;
        }
        this.run();
    }

    public String toString() {
        return "BuildSetAction(" + this.workingSet.getName() + ")";
    }
}

