/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.command;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.ws.internal.common.EnvironmentUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.ProgressMonitor;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusHandler;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;

public class GenerateHandlerSkeletonCommand
extends SimpleCommand {
    private IProject serviceProject_;
    private MessageUtils msgUtils_;
    private String LABEL = "TASK_LABEL_GEN_HANDLER_SKELETON";
    private String DESCRIPTION = "TASK_DESC_GEN_HANDLER_SKELETON";
    private IPath outputLocation_;
    private String[] handlerNames_;
    private boolean genSkeleton_;
    private String handlerNameForEdit_ = null;

    public GenerateHandlerSkeletonCommand() {
        String pluginId = "org.eclipse.jst.ws.consumption.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.setName(this.msgUtils_.getMessage(this.LABEL));
        this.setDescription(this.msgUtils_.getMessage(this.DESCRIPTION));
    }

    public Status execute(Environment env) {
        if (!this.genSkeleton_) {
            return new SimpleStatus("");
        }
        boolean error = false;
        SimpleStatus status = null;
        int i = 0;
        while (i < this.handlerNames_.length) {
            Status writeStatus = this.writeFile(env, this.handlerNames_[i], this.outputLocation_);
            if (writeStatus.getSeverity() == 4) {
                error = true;
                if (status == null) {
                    status = new SimpleStatus("execute", this.msgUtils_.getMessage("MSG_ERROR_GENERATE_HANDLER_SKELETON"), 4);
                }
                status.addChild(writeStatus);
            }
            ++i;
        }
        if (error) {
            env.getStatusHandler().reportError(status);
        } else {
            status = new SimpleStatus("");
        }
        return status;
    }

    public Status writeFile(Environment env, String className, IPath outputLocation) {
        SimpleStatus status;
        block11: {
            status = new SimpleStatus("");
            String simpleClassName = className;
            String packageName = null;
            IPath filePath = outputLocation;
            if (className != null) {
                int index = className.lastIndexOf(46);
                if (index != -1) {
                    simpleClassName = className.substring(index + 1);
                    String packageSegment = packageName = className.substring(0, index);
                    int j = 0;
                    j = packageSegment.indexOf(46);
                    while (j != -1) {
                        filePath = filePath.append(packageSegment.substring(0, j));
                        packageSegment = packageSegment.substring(j + 1);
                        j = packageSegment.indexOf(46);
                    }
                    filePath = filePath.append(packageSegment);
                } else {
                    packageName = "";
                }
            }
            filePath = filePath.append(simpleClassName);
            IResource workspaceRes = ResourceUtils.findResource((IPath)(filePath = filePath.addFileExtension("java")));
            if (workspaceRes != null && workspaceRes.exists()) {
                return status;
            }
            if (this.handlerNameForEdit_ == null) {
                this.handlerNameForEdit_ = className;
            }
            OutputStream outputStream = FileResourceUtils.newFileOutputStream((ResourceContext)EnvironmentUtils.getResourceContext((Environment)env), (IPath)filePath, (ProgressMonitor)env.getProgressMonitor(), (StatusHandler)env.getStatusHandler());
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outputStream));
            try {
                if (packageName.length() != 0) {
                    bw.write("package " + packageName + ";");
                    bw.newLine();
                    bw.newLine();
                }
                bw.write("import javax.xml.rpc.handler.GenericHandler;");
                bw.newLine();
                bw.write("import javax.xml.rpc.handler.MessageContext;");
                bw.newLine();
                bw.write("import javax.xml.namespace.QName;");
                bw.newLine();
                bw.newLine();
                bw.write("public class " + simpleClassName + " extends GenericHandler");
                bw.newLine();
                bw.write("{");
                bw.newLine();
                bw.newLine();
                bw.write("   public QName[] getHeaders ()");
                bw.newLine();
                bw.write("   {");
                bw.newLine();
                bw.write("      // Fill in method body");
                bw.newLine();
                bw.write("      return null;");
                bw.newLine();
                bw.write("   }");
                bw.newLine();
                bw.newLine();
                bw.write("   public boolean handleRequest( MessageContext context )");
                bw.newLine();
                bw.write("   {");
                bw.newLine();
                bw.write("      // Fill in method body or delete method to use GenericHandler");
                bw.newLine();
                bw.write("      return true;");
                bw.newLine();
                bw.write("   }");
                bw.newLine();
                bw.newLine();
                bw.write("   public boolean handleResponse( MessageContext context )");
                bw.newLine();
                bw.write("   {");
                bw.newLine();
                bw.write("      // Fill in method body or delete method to use GenericHandler ");
                bw.newLine();
                bw.write("      return true;");
                bw.newLine();
                bw.write("   }");
                bw.newLine();
                bw.newLine();
                bw.write("   public boolean handleFault( MessageContext context )");
                bw.newLine();
                bw.write("   {");
                bw.newLine();
                bw.write("      // Fill in method body or delete method to use GenericHandler");
                bw.newLine();
                bw.write("      return true;");
                bw.newLine();
                bw.write("   }");
                bw.newLine();
                bw.newLine();
                bw.write("}");
                bw.close();
                status = new SimpleStatus("");
            }
            catch (IOException e) {
                status = new SimpleStatus("writeFile", this.msgUtils_.getMessage("MSG_ERROR_WRITE_FILE", (Object[])new String[]{className}), 4, (Throwable)e);
                if (bw == null) break block11;
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
        return status;
    }

    public Status undo(Environment environment) {
        return null;
    }

    public Status redo(Environment environment) {
        return null;
    }

    public void setOutputLocation(IPath outputLocation) {
        this.outputLocation_ = outputLocation;
    }

    public void setHandlerNames(String[] handlerNames) {
        this.handlerNames_ = handlerNames;
    }

    public void setGenSkeletonEnabled(boolean genSkeleton) {
        this.genSkeleton_ = genSkeleton;
    }

    public IProject getProject() {
        IProject project = null;
        if (this.outputLocation_ != null) {
            project = ResourceUtils.getProjectOf((IPath)this.outputLocation_);
        }
        return project;
    }

    public List getClassNames() {
        ArrayList<String> classes = new ArrayList<String>();
        if (this.handlerNameForEdit_ != null) {
            classes.add(this.handlerNameForEdit_);
        }
        return classes;
    }
}

