/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class WSDLSelectionOutputCommand
extends SimpleCommand {
    private WebServicesParser webServicesParser;
    private String wsdlURI;
    private IProject project;
    private String componentName;
    private boolean testService;

    public boolean getTestService() {
        return this.testService;
    }

    public void setTestService(boolean testService) {
        this.testService = testService;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getWsdlURI() {
        return this.wsdlURI;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public WebServicesParser getWebServicesParser() {
        if (this.webServicesParser != null) {
            return this.webServicesParser;
        }
        return new WebServicesParserExt();
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public Status execute(Environment env) {
        MessageUtils msgUtils = new MessageUtils("org.eclipse.jst.ws.consumption.ui.plugin", (Object)this);
        if (this.wsdlURI != null && this.getWebServicesParser().getWSDLDefinition(this.wsdlURI) != null) {
            SimpleStatus status = new SimpleStatus("");
            Map services = this.getWebServicesParser().getWSDLDefinition(this.wsdlURI).getServices();
            if (services.isEmpty() && this.testService) {
                this.testService = false;
                status = new SimpleStatus("", msgUtils.getMessage("MSG_WARNING_NO_SERVICE_ELEMENT"), 2);
                try {
                    env.getStatusHandler().report((Status)status);
                }
                catch (Exception exception) {
                    status = new SimpleStatus("", msgUtils.getMessage("MSG_WARNING_NO_SERVICE_ELEMENT"), 4);
                }
            }
            return status;
        }
        SimpleStatus status = new SimpleStatus("", msgUtils.getMessage("PAGE_MSG_SELECTION_MUST_BE_WSDL"), 4);
        env.getStatusHandler().reportError((Status)status);
        return status;
    }
}

