/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.vm.remote;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.IOCommandException;
import org.eclipse.jem.internal.proxy.vm.remote.CallbackHandler;
import org.eclipse.jem.internal.proxy.vm.remote.RemoteVMServerThread;

public class CallbackOutputStream
extends OutputStream {
    protected CallbackHandler fHandler;
    protected RemoteVMServerThread fSvr;
    protected byte[] fBuffer;
    protected int fNextByte = 0;

    public CallbackOutputStream(CallbackHandler handler, RemoteVMServerThread svr) {
        this.fHandler = handler;
        this.fSvr = svr;
        Integer bufSize = Integer.getInteger("proxyvm.bufsize");
        if (bufSize == null) {
            bufSize = new Integer(5000);
        }
        this.fBuffer = new byte[bufSize.intValue()];
    }

    protected void clearStream() {
        this.fSvr.returnCallbackHandler(this.fHandler);
        this.fSvr = null;
        this.fHandler = null;
        this.fBuffer = null;
    }

    protected void processException(CommandException e) throws IOException {
        this.clearStream();
        throw new IOCommandException(e);
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.fHandler.out.flush();
    }

    protected void flushBuffer() throws IOException {
        if (this.fHandler == null) {
            throw new IOException("Stream closed. No more operations permitted.");
        }
        if (this.fNextByte > 0) {
            try {
                if (this.fHandler.in.available() > 0) {
                    this.fHandler.in.skip(this.fHandler.in.available());
                    this.close(false);
                    throw new InterruptedIOException();
                }
                this.fHandler.writeBytes(this.fBuffer, this.fNextByte);
                this.fNextByte = 0;
            }
            catch (CommandException e) {
                this.processException(e);
            }
        }
    }

    public void close() throws IOException {
        this.close(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void close(boolean wait) throws IOException {
        if (this.fHandler == null) return;
        try {
            this.flushBuffer();
            try {
                this.fHandler.writeBytes(null, -1);
                this.fHandler.out.flush();
                if (wait) {
                    this.fHandler.in.readByte();
                    if (this.fHandler.in.available() > 0) {
                        this.fHandler.in.skip(this.fHandler.in.available());
                    }
                }
            }
            catch (CommandException e) {
                this.processException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.clearStream();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.clearStream();
            return;
        }
    }

    public void write(int b) throws IOException {
        this.fBuffer[this.fNextByte++] = (byte)b;
        if (this.fNextByte >= this.fBuffer.length) {
            this.flushBuffer();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len != 0) ** GOTO lbl16
        return;
lbl-1000:
        // 1 sources

        {
            move = this.fBuffer.length - this.fNextByte;
            if (len < move) {
                move = len;
            }
            System.arraycopy(b, off, this.fBuffer, this.fNextByte, move);
            len -= move;
            off += move;
            this.fNextByte += move;
            if (this.fNextByte < this.fBuffer.length) continue;
            this.flushBuffer();
lbl16:
            // 3 sources

            ** while (len > 0)
        }
lbl17:
        // 1 sources

    }
}

