/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.vm.remote;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.MapTypes;
import org.eclipse.jem.internal.proxy.common.MethodHelper;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.initParser.tree.ExpressionProcesser;
import org.eclipse.jem.internal.proxy.initParser.tree.InfixOperator;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalConditionalOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalExpressionProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalIfElseOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalInfixOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.NoExpressionValueException;
import org.eclipse.jem.internal.proxy.initParser.tree.PrefixOperator;
import org.eclipse.jem.internal.proxy.vm.remote.ConnectionHandler;
import org.eclipse.jem.internal.proxy.vm.remote.RemoteVMServerThread;

public class ExpressionProcesserController {
    protected final RemoteVMServerThread server;
    protected final ConnectionHandler connHandler;
    protected final ExpressionProcesser exp;
    protected Commands.ValueObject workerValue = new Commands.ValueObject();
    private ClassLoader classLoader;
    private static final List PRIMITIVE_NAMES = Arrays.asList("byte", "char", "short", "int", "long", "float", "double");
    private static final Class[] PRIMITIVE_TYPES = new Class[]{Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ExpressionProcesserController(RemoteVMServerThread server, ConnectionHandler connHandler) {
        this(server, connHandler, new ExpressionProcesser(Boolean.getBoolean("proxyvm.expressionTrace"), Long.getLong("proxyvm.expressionTraceTimerThreshold", -1L).longValue()));
    }

    public ExpressionProcesserController(RemoteVMServerThread server, ConnectionHandler connHandler, boolean trace) {
        this(server, connHandler, new ExpressionProcesser(trace, Long.getLong("proxyvm.expressionTraceTimerThreshold", -1L).longValue()));
    }

    protected ExpressionProcesserController(RemoteVMServerThread server, ConnectionHandler connHandler, ExpressionProcesser exp) {
        this.server = server;
        this.connHandler = connHandler;
        this.exp = exp;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected Class loadClass(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        if (className.endsWith("[]")) {
            return this.loadClass(MapTypes.getJNIFormatName((String)className));
        }
        int primIndex = PRIMITIVE_NAMES.indexOf(className);
        if (primIndex >= 0) {
            return PRIMITIVE_TYPES[primIndex];
        }
        if (this.classLoader == null) {
            return Class.forName(className);
        }
        return this.classLoader.loadClass(className);
    }

    /*
     * Unable to fully structure code
     */
    public void process(DataInputStream in) throws CommandException, IOException {
        subcommand = in.readByte();
        try {
            switch (subcommand) {
                case 12: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    value = this.connHandler.getInvokableObject(this.workerValue);
                    if (value == null) {
                        this.exp.pushExpression(null, MethodHelper.NULL_TYPE);
                        break;
                    }
                    if (this.workerValue.isPrimitive()) {
                        this.exp.pushExpression(value, this.workerValue.getPrimitiveType());
                        break;
                    }
                    this.exp.pushExpression(value, value.getClass());
                    break;
                }
                case 4: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    try {
                        classValue = this.getBeanTypeValue(this.workerValue);
                        this.exp.pushCast(classValue);
                    }
                    catch (FailedProxyException e) {
                        this.exp.processException(e.getCause());
                    }
                    break;
                }
                case 8: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    try {
                        classValue = this.getBeanTypeValue(this.workerValue);
                        this.exp.pushInstanceof(classValue);
                    }
                    catch (FailedProxyException e) {
                        this.exp.processException(e.getCause());
                    }
                    break;
                }
                case 9: {
                    infix_operator = in.readByte();
                    infix_operandType = in.readByte();
                    this.exp.pushInfix(InfixOperator.get((int)infix_operator), InternalInfixOperandType.get((int)infix_operandType));
                    break;
                }
                case 11: {
                    prefix_operandType = in.readByte();
                    this.exp.pushPrefix(PrefixOperator.get((int)prefix_operandType));
                    break;
                }
                case 1: {
                    arrayAccess_Indexcount = in.readInt();
                    this.exp.pushArrayAccess(arrayAccess_Indexcount);
                    break;
                }
                case 2: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    arrayCreation_dimCount = in.readInt();
                    try {
                        classValue = this.getBeanTypeValue(this.workerValue);
                        this.exp.pushArrayCreation(classValue, arrayCreation_dimCount);
                    }
                    catch (FailedProxyException e) {
                        this.exp.processException(e.getCause());
                    }
                    break;
                }
                case 3: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    stripCount = in.readInt();
                    arrayInitializer_expressionCount = in.readInt();
                    try {
                        classValue = this.getBeanTypeValue(this.workerValue);
                        this.exp.pushArrayInitializer(classValue, stripCount, arrayInitializer_expressionCount);
                    }
                    catch (FailedProxyException e) {
                        this.exp.processException(e.getCause());
                    }
                    break;
                }
                case 6: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    newInstance_argCount = in.readInt();
                    try {
                        classValue = this.getBeanTypeValue(this.workerValue);
                        this.exp.pushClassInstanceCreation(classValue, newInstance_argCount);
                    }
                    catch (FailedProxyException e) {
                        this.exp.processException(e.getCause());
                    }
                    break;
                }
                case 14: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    try {
                        classValue = this.getBeanTypeValue(this.workerValue);
                        this.exp.pushExpression((Object)classValue, classValue);
                    }
                    catch (FailedProxyException e) {
                        this.exp.processException(e.getCause());
                    }
                    break;
                }
                case 7: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    has_fieldAccess_receiver = in.readBoolean();
                    try {
                        fieldAccess = this.getFieldValue(this.workerValue);
                        this.exp.pushFieldAccess(fieldAccess, this.workerValue.getType() == 17, has_fieldAccess_receiver);
                    }
                    catch (ClassCastException e) {
                        this.exp.processException((Throwable)e);
                    }
                    catch (FailedProxyException e) {
                        this.exp.processException(e.getCause());
                    }
                    break;
                }
                case 10: {
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    has_method_receiver = in.readBoolean();
                    method_argCount = in.readInt();
                    try {
                        method = this.getMethodValue(this.workerValue);
                        this.exp.pushMethodInvocation(method, this.workerValue.getType() == 17, has_method_receiver, method_argCount);
                    }
                    catch (FailedProxyException e) {
                        this.exp.processException(e.getCause());
                    }
                    break;
                }
                case 5: {
                    this.exp.pushConditional(InternalConditionalOperandType.get((int)in.readByte()));
                    break;
                }
                case 15: {
                    proxyid = in.readInt();
                    this.exp.pushAssignment((InternalExpressionProxy)new RemoteExpressionProxy(proxyid));
                    break;
                }
                case 17: {
                    this.exp.pushAssignment();
                    break;
                }
                case 16: {
                    proxyid = in.readInt();
                    try {
                        this.exp.getExpressionProxy(proxyid, new Object[2]);
                    }
                    catch (NoExpressionValueException e1) {
                        if (e1.getProxy() == null) ** GOTO lbl139
                        failure = (FailedRemoteExpressionProxy)e1.getProxy();
                        this.exp.processException((Throwable)failure.getValue());
                        break;
                    }
lbl139:
                    // 2 sources

                    this.exp.pushExpressionProxy(proxyid);
                    break;
                }
                case 18: {
                    this.exp.pushBlockBegin(in.readInt());
                    break;
                }
                case 19: {
                    this.exp.pushBlockBreak(in.readInt());
                    break;
                }
                case 20: {
                    this.exp.pushBlockEnd(in.readInt());
                    break;
                }
                case 21: {
                    this.exp.pushTryBegin(in.readInt());
                    break;
                }
                case 22: {
                    tryNumber = in.readInt();
                    Commands.readValue((DataInputStream)in, (Commands.ValueObject)this.workerValue);
                    proxyid = in.readInt();
                    try {
                        classValue = this.getBeanTypeValue(this.workerValue);
                        this.exp.pushTryCatchClause(tryNumber, classValue, (InternalExpressionProxy)(proxyid != -1 ? new RemoteExpressionProxy(proxyid) : null));
                    }
                    catch (FailedProxyException e) {
                        this.exp.processException(e.getCause());
                    }
                    break;
                }
                case 23: {
                    this.exp.pushTryFinallyClause(in.readInt());
                    break;
                }
                case 24: {
                    this.exp.pushTryEnd(in.readInt());
                    break;
                }
                case 25: {
                    this.exp.pushThrowException();
                    break;
                }
                case 26: {
                    this.exp.pushTryRethrow(in.readInt());
                    break;
                }
                case 13: {
                    proxyid = in.readInt();
                    typeName = Commands.readStringData((DataInputStream)in);
                    try {
                        classValue = this.loadClass(typeName);
                        rep = new RemoteExpressionProxy(proxyid);
                        v0 = ExpressionProcesserController.class$0;
                        if (v0 == null) {
                            try {
                                v0 = ExpressionProcesserController.class$0 = Class.forName("java.lang.Class");
                            }
                            catch (ClassNotFoundException v1) {
                                throw new NoClassDefFoundError(v1.getMessage());
                            }
                        }
                        rep.setProxy(classValue, v0);
                        this.exp.allocateExpressionProxy((InternalExpressionProxy)rep);
                    }
                    catch (ClassNotFoundException e) {
                        rep = new FailedRemoteExpressionProxy(proxyid);
                        rep.setProxy(e, e.getClass());
                        this.exp.allocateExpressionProxy((InternalExpressionProxy)rep);
                    }
                    catch (LinkageError e) {
                        rep = new FailedRemoteExpressionProxy(proxyid);
                        rep.setProxy(e, e.getClass());
                        this.exp.allocateExpressionProxy((InternalExpressionProxy)rep);
                    }
                    break;
                }
                case 27: {
                    proxyid = in.readInt();
                    decClassValue = Commands.readValue((DataInputStream)in, (Commands.ValueObject)new Commands.ValueObject());
                    methodName = Commands.readStringData((DataInputStream)in);
                    argCount = in.readInt();
                    args = null;
                    if (argCount > 0) {
                        args = new Commands.ValueObject[argCount];
                        i = 0;
                        while (i < argCount) {
                            args[i] = Commands.readValue((DataInputStream)in, (Commands.ValueObject)new Commands.ValueObject());
                            ++i;
                        }
                    }
                    decClass = null;
                    argClasses = null;
                    try {
                        decClass = this.getBeanTypeValue(decClassValue);
                        argClasses = null;
                        if (argCount > 0) {
                            argClasses = new Class[argCount];
                            i = 0;
                            while (i < argCount) {
                                argClasses[i] = this.getBeanTypeValue(args[i]);
                                ++i;
                            }
                        }
                        m = decClass.getMethod(methodName, argClasses);
                        rep = new RemoteExpressionProxy(proxyid);
                        v2 = ExpressionProcesserController.class$1;
                        if (v2 == null) {
                            try {
                                v2 = ExpressionProcesserController.class$1 = Class.forName("java.lang.reflect.Method");
                            }
                            catch (ClassNotFoundException v3) {
                                throw new NoClassDefFoundError(v3.getMessage());
                            }
                        }
                        rep.setProxy(m, v2);
                        this.exp.allocateExpressionProxy((InternalExpressionProxy)rep);
                        break;
                    }
                    catch (FailedProxyException e) {
                        rep = new FailedRemoteExpressionProxy(proxyid);
                        rep.setProxy(e.getCause(), e.getCause().getClass());
                        this.exp.allocateExpressionProxy((InternalExpressionProxy)rep);
                        break;
                    }
                    catch (NoSuchMethodException e) {
                        s = new StringBuffer();
                        s.append(decClass.getName());
                        s.append('.');
                        s.append(methodName);
                        s.append('(');
                        if (argClasses == null) ** GOTO lbl265
                        i = 0;
                        ** while (i < argClasses.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (i > 0) {
                            s.append(',');
                        }
                        s.append(argClasses[i].getName());
                        ++i;
                        continue;
                    }
lbl265:
                    // 2 sources

                    s.append(')');
                    ne = new NoSuchMethodException(s.toString());
                    ne.setStackTrace(e.getStackTrace());
                    rep = new FailedRemoteExpressionProxy(proxyid);
                    rep.setProxy(ne, ne.getClass());
                    this.exp.allocateExpressionProxy((InternalExpressionProxy)rep);
                    break;
                }
                case 28: {
                    proxyid = in.readInt();
                    decClassValue = Commands.readValue((DataInputStream)in, (Commands.ValueObject)new Commands.ValueObject());
                    fieldName = Commands.readStringData((DataInputStream)in);
                    try {
                        decClass = this.getBeanTypeValue(decClassValue);
                        f = decClass.getField(fieldName);
                        rep = new RemoteExpressionProxy(proxyid);
                        v4 = ExpressionProcesserController.class$1;
                        if (v4 == null) {
                            try {
                                v4 = ExpressionProcesserController.class$1 = Class.forName("java.lang.reflect.Method");
                            }
                            catch (ClassNotFoundException v5) {
                                throw new NoClassDefFoundError(v5.getMessage());
                            }
                        }
                        rep.setProxy(f, v4);
                        this.exp.allocateExpressionProxy((InternalExpressionProxy)rep);
                    }
                    catch (FailedProxyException e) {
                        rep = new FailedRemoteExpressionProxy(proxyid);
                        rep.setProxy(e.getCause(), e.getCause().getClass());
                        this.exp.allocateExpressionProxy((InternalExpressionProxy)rep);
                    }
                    catch (NoSuchFieldException e) {
                        rep = new FailedRemoteExpressionProxy(proxyid);
                        rep.setProxy(e, e.getClass());
                        this.exp.allocateExpressionProxy((InternalExpressionProxy)rep);
                    }
                    break;
                }
                case 30: {
                    this.exp.pushIfElse();
                    break;
                }
                case 29: {
                    this.exp.pushIfElse(InternalIfElseOperandType.get((int)in.readByte()));
                    break;
                }
                case 31: {
                    initString = Commands.readStringData((DataInputStream)in);
                    this.workerValue = Commands.readValue((DataInputStream)in, (Commands.ValueObject)new Commands.ValueObject());
                    try {
                        classValue = this.getBeanTypeValue(this.workerValue);
                        this.exp.pushNewInstanceFromString(initString, classValue, this.classLoader);
                    }
                    catch (FailedProxyException e) {
                        this.exp.processException(e.getCause());
                    }
                    break;
                }
                case 32: {
                    markID = in.readInt();
                    this.exp.pushMark(markID);
                    break;
                }
                case 33: {
                    markID = in.readInt();
                    restore = in.readBoolean();
                    this.exp.pushEndmark(markID, restore);
                    break;
                }
                case 34: {
                    this.exp.pushSubexpressionBegin(in.readInt());
                    break;
                }
                case 35: {
                    this.exp.pushSubexpressionEnd(in.readInt());
                }
            }
        }
        catch (RuntimeException e) {
            this.exp.processException((Throwable)e);
        }
        this.workerValue.set();
    }

    protected Class getBeanTypeValue(Commands.ValueObject value) throws FailedProxyException {
        Object beantype = this.connHandler.getInvokableObject(value);
        if (value.type == 3) {
            Object[] expvalue = new Object[2];
            try {
                this.exp.getExpressionProxy(((Integer)beantype).intValue(), expvalue);
                beantype = expvalue[0];
            }
            catch (NoExpressionValueException e) {
                if (e.getProxy() != null) {
                    FailedRemoteExpressionProxy failure = (FailedRemoteExpressionProxy)e.getProxy();
                    throw new FailedProxyException((Throwable)failure.getValue());
                }
                throw new FailedProxyException(new ClassNotFoundException());
            }
        }
        return (Class)beantype;
    }

    protected Object getMethodValue(Commands.ValueObject value) throws FailedProxyException {
        Object method = this.connHandler.getInvokableObject(value);
        if (value.type == 3) {
            Object[] expvalue = new Object[2];
            try {
                this.exp.getExpressionProxy(((Integer)method).intValue(), expvalue);
                method = expvalue[0];
            }
            catch (NoExpressionValueException e) {
                if (e.getProxy() != null) {
                    FailedRemoteExpressionProxy failure = (FailedRemoteExpressionProxy)e.getProxy();
                    throw new FailedProxyException((Throwable)failure.getValue());
                }
                throw new FailedProxyException(new NoSuchMethodException());
            }
        }
        return method;
    }

    protected Object getFieldValue(Commands.ValueObject value) throws FailedProxyException {
        Object field = this.connHandler.getInvokableObject(value);
        if (value.type == 3) {
            Object[] expvalue = new Object[2];
            try {
                this.exp.getExpressionProxy(((Integer)field).intValue(), expvalue);
                field = expvalue[0];
            }
            catch (NoExpressionValueException e) {
                if (e.getProxy() != null) {
                    FailedRemoteExpressionProxy failure = (FailedRemoteExpressionProxy)e.getProxy();
                    throw new FailedProxyException((Throwable)failure.getValue());
                }
                throw new FailedProxyException(new NoSuchFieldException());
            }
        }
        return field;
    }

    public boolean pullExpressionProxyValue(int proxyID, Object[] result) {
        try {
            this.exp.pullExpressionProxyValue(proxyID, result);
            return true;
        }
        catch (NoExpressionValueException noExpressionValueException) {
            return false;
        }
    }

    public Object[] pullValue() throws NoExpressionValueException {
        Object[] result = new Object[2];
        this.exp.pullValue(result);
        return result;
    }

    public void close() {
        this.exp.close();
    }

    public Throwable getErrorThrowable() {
        return this.exp.getErrorThrowable();
    }

    public boolean noErrors() {
        return this.exp.noErrors();
    }

    public boolean isNoExpressionValue() {
        return this.exp.isNoExpressionValue();
    }

    private static class FailedProxyException
    extends Exception {
        private static final long serialVersionUID = 2872325672166348923L;

        public FailedProxyException(Throwable realThrowable) {
            super(realThrowable);
        }
    }

    private static class RemoteExpressionProxy
    implements InternalExpressionProxy {
        private final int proxyID;
        private Object value;
        private Class type;
        private boolean set;

        public RemoteExpressionProxy(int proxyID) {
            this.proxyID = proxyID;
        }

        public int getProxyID() {
            return this.proxyID;
        }

        public Class getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isSet() {
            return this.set;
        }

        public void setProxy(Object value, Class type) {
            this.value = value;
            this.type = type;
            this.set = true;
        }

        public boolean isFailedExpression() {
            return false;
        }
    }

    private static class FailedRemoteExpressionProxy
    extends RemoteExpressionProxy {
        public FailedRemoteExpressionProxy(int proxyID) {
            super(proxyID);
        }

        public boolean isFailedExpression() {
            return true;
        }

        public boolean isSet() {
            return false;
        }
    }
}

