/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.xsd.ui.internal.actions.CreateElementAction;
import org.eclipse.wst.xsd.ui.internal.actions.DOMAttribute;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CreateSimpleContentAction
extends CreateElementAction {
    XSDSchema xsdSchema;

    public CreateSimpleContentAction() {
    }

    public CreateSimpleContentAction(String text) {
        super(text);
    }

    public CreateSimpleContentAction(String text, XSDSchema xsdSchema) {
        super(text);
        this.xsdSchema = xsdSchema;
    }

    public CreateSimpleContentAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public Element createAndAddNewChildElement() {
        Element childNode = super.createAndAddNewChildElement();
        String prefix = this.parentNode.getPrefix();
        prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
        Element derivedByNode = this.getDocument().createElementNS("http://www.w3.org/2001/XMLSchema", String.valueOf(prefix) + "restriction");
        childNode.appendChild(derivedByNode);
        Element sequence = null;
        if (XSDDOMHelper.inputEquals(childNode, "complexContent", false)) {
            sequence = this.getDocument().createElementNS("http://www.w3.org/2001/XMLSchema", String.valueOf(prefix) + "sequence");
            derivedByNode.appendChild(sequence);
        }
        TypesHelper typesHelper = new TypesHelper(this.xsdSchema);
        List listOfCT = typesHelper.getUserComplexTypeNamesList();
        String firstType = "";
        if (listOfCT.size() > 0) {
            firstType = (String)listOfCT.get(0);
        }
        DOMAttribute attr = new DOMAttribute("base", firstType);
        derivedByNode.setAttribute(attr.getName(), attr.getValue());
        this.formatChild(derivedByNode);
        if (sequence != null) {
            this.formatChild(sequence);
            this.formatChild(derivedByNode);
        }
        this.formatChild(childNode);
        return childNode;
    }

    public void run() {
        new ArrayList();
        this.beginRecording(this.getDescription());
        this.createAndAddNewChildElement();
        this.endRecording();
        NodeList children = this.parentNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node aChild = children.item(i);
            if (aChild != null && aChild instanceof Element && !XSDDOMHelper.inputEquals((Element)aChild, "attribute", false) && !XSDDOMHelper.inputEquals((Element)aChild, "attribute", true) && !XSDDOMHelper.inputEquals((Element)aChild, "anyAttribute", false)) {
                XSDDOMHelper.inputEquals((Element)aChild, "attributeGroup", true);
            }
            ++i;
        }
    }
}

