/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xsd.ui.internal.actions.CreateElementAction;
import org.eclipse.wst.xsd.ui.internal.actions.DOMAttribute;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xml.XMLComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.refactor.delete.XSDExternalFileCleanup;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSDSetTypeHelper {
    private XSDSchema xsdSchema;
    private IFile currentIFile;

    public XSDSetTypeHelper(IFile iFile, XSDSchema schema) {
        this.currentIFile = iFile;
        this.xsdSchema = schema;
    }

    public void setType(Element element, String property, XMLComponentSpecification spec) {
        this.addImportIfNecessary(element, spec);
        String typeObject = this.getPrefixedTypeName(spec);
        String previousStringType = "";
        Attr attr = element.getAttributeNode(property);
        if (attr != null) {
            attr.getValue();
        }
        if (!XSDDOMHelper.inputEquals(element, "union", false)) {
            if (spec != null && spec.getTagPath().equals("**anonymous**")) {
                if (spec.getTagPath().equals("ANONYMOUS_SIMPLE_TYPE")) {
                    if (!previousStringType.equals("**anonymous**")) {
                        this.updateElementToAnonymous(element, "simpleType");
                    }
                } else if (!previousStringType.equals("**anonymous**")) {
                    this.updateElementToAnonymous(element, "complexType");
                }
                element.removeAttribute(property);
            } else {
                XSDDOMHelper.updateElementToNotAnonymous(element);
                element.setAttribute(property, typeObject.toString());
            }
        }
    }

    public void addImportIfNecessary(Element element, XMLComponentSpecification spec) {
        if (spec != null) {
            String itemType = spec.getTagPath();
            String cfr_ignored_0 = (String)spec.getAttributeInfo("name");
            if (!itemType.equals("BUILT_IN_SIMPLE_TYPE")) {
                XSDParser parser = new XSDParser();
                parser.parse(spec.getFileLocation());
                XSDSchema schema = parser.getSchema();
                String tns = schema.getTargetNamespace();
                boolean exists = false;
                String currentFile = this.getNormalizedLocation(this.xsdSchema.getSchemaLocation());
                Path currentFilePath = new Path(currentFile);
                if (currentFilePath.equals((Object)new Path(spec.getFileLocation()))) {
                    exists = true;
                }
                if (!exists) {
                    if (tns.equals(this.xsdSchema.getTargetNamespace())) {
                        List existingList = this.getXSDIncludes();
                        existingList.addAll(this.getXSDRedefines());
                        Iterator it = existingList.iterator();
                        while (it.hasNext()) {
                            String normalizedSpec;
                            XSDSchemaDirective existingSchema = (XSDSchemaDirective)it.next();
                            String normalizedFile = this.getNormalizedLocation(existingSchema.getResolvedSchema().getSchemaLocation());
                            if (!normalizedFile.equals(normalizedSpec = spec.getFileLocation())) continue;
                            exists = true;
                        }
                    } else {
                        List existingList = this.getXSDImports();
                        Iterator it = existingList.iterator();
                        while (it.hasNext()) {
                            String normalizedSpec;
                            XSDSchemaDirective existingSchema = (XSDSchemaDirective)it.next();
                            String normalizedFile = this.getNormalizedLocation(existingSchema.getResolvedSchema().getSchemaLocation());
                            if (!normalizedFile.equals(normalizedSpec = spec.getFileLocation())) continue;
                            exists = true;
                        }
                    }
                }
                if (!exists) {
                    this.doImport(spec.getFileLocation(), schema);
                }
            }
        }
    }

    public String getPrefixedTypeName(XMLComponentSpecification spec) {
        String typeObject = (String)spec.getAttributeInfo("name");
        TypesHelper typesHelper = new TypesHelper(this.xsdSchema);
        List prefixedNames = typesHelper.getPrefixedNames(spec.getTargetNamespace(), typeObject);
        if (prefixedNames.size() > 0) {
            typeObject = (String)prefixedNames.get(0);
        }
        return typeObject;
    }

    private void updateElementToAnonymous(Element element, String xsdType) {
        String prefix = element.getPrefix();
        prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
        XSDDOMHelper.updateElementToNotAnonymous(element);
        this.hasElementChildren(element);
        Element childNode = null;
        if (xsdType.equals("complexType")) {
            childNode = element.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", String.valueOf(prefix) + "complexType");
        } else if (xsdType.equals("simpleType")) {
            childNode = element.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", String.valueOf(prefix) + "simpleType");
        }
        if (childNode != null) {
            XSDDOMHelper helper = new XSDDOMHelper();
            Node annotationNode = helper.getChildNode(element, "annotation");
            if (annotationNode == null) {
                Node firstChild = element.getFirstChild();
                element.insertBefore(childNode, firstChild);
            } else {
                Node nextSibling = annotationNode.getNextSibling();
                element.insertBefore(childNode, nextSibling);
            }
            XSDDOMHelper.formatChild(childNode);
        }
    }

    private boolean hasElementChildren(Node parentNode) {
        boolean hasChildrenElements = false;
        if (parentNode != null && parentNode.hasChildNodes()) {
            NodeList nodes = parentNode.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                if (nodes.item(i) instanceof Element) {
                    hasChildrenElements = true;
                    break;
                }
                ++i;
            }
        }
        return hasChildrenElements;
    }

    private void doImport(String externalSchemaPath, XSDSchema externalSchema) {
        String locationAttribute = URIHelper.getRelativeURI((String)externalSchemaPath, (String)this.currentIFile.getLocation().toOSString());
        boolean isInclude = false;
        if (externalSchema.getTargetNamespace().equals(this.xsdSchema.getTargetNamespace())) {
            isInclude = true;
        }
        if (externalSchema != null) {
            if (isInclude) {
                ArrayList<DOMAttribute> attributes = new ArrayList<DOMAttribute>();
                attributes.add(new DOMAttribute("schemaLocation", locationAttribute));
                Element newElement = this.createElement("include", attributes);
            } else if (!isInclude) {
                ArrayList<DOMAttribute> attributes = new ArrayList<DOMAttribute>();
                attributes.add(new DOMAttribute("namespace", externalSchema.getTargetNamespace()));
                attributes.add(new DOMAttribute("schemaLocation", locationAttribute));
                Element newElement = this.createElement("import", attributes);
                this.handleImportNS(newElement, externalSchema);
            }
        }
    }

    private void handleImportNS(Element importElement, XSDSchema externalSchema) {
        String namespace = externalSchema.getTargetNamespace();
        if (namespace == null) {
            namespace = "";
        }
        XSDImport xsdImport = (XSDImport)this.xsdSchema.getCorrespondingComponent((Node)importElement);
        xsdImport.setResolvedSchema(externalSchema);
        Map map = this.xsdSchema.getQNamePrefixToNamespaceMap();
        XSDSchema referencedSchema = xsdImport.getResolvedSchema();
        if (referencedSchema != null) {
            XSDExternalFileCleanup cleanHelper = new XSDExternalFileCleanup(referencedSchema);
            cleanHelper.visitSchema(this.xsdSchema);
        }
        Element schemaElement = this.xsdSchema.getElement();
        TypesHelper helper = new TypesHelper(externalSchema);
        String prefix = helper.getPrefix(namespace, false);
        if (map.containsKey(prefix)) {
            prefix = null;
        }
        if (prefix == null || prefix != null && prefix.length() == 0) {
            StringBuffer newPrefix = new StringBuffer("pref");
            int prefixExtension = 1;
            while (map.containsKey(newPrefix.toString()) && prefixExtension < 100) {
                newPrefix = new StringBuffer("pref" + String.valueOf(prefixExtension));
                ++prefixExtension;
            }
            prefix = newPrefix.toString();
        }
        if (namespace.length() > 0) {
            if (map.containsValue(namespace)) {
                TypesHelper typesHelper = new TypesHelper(this.xsdSchema);
                prefix = typesHelper.getPrefix(namespace, false);
            } else {
                schemaElement.setAttribute("xmlns:" + prefix, namespace);
            }
        }
    }

    private Element createElement(String elementTag, List attributes) {
        Node relativeNode = XSDDOMHelper.getNextElementNode(this.xsdSchema.getElement().getFirstChild());
        CreateElementAction action = new CreateElementAction("");
        action.setElementTag(elementTag);
        action.setAttributes(attributes);
        action.setParentNode(this.xsdSchema.getElement());
        action.setRelativeNode(relativeNode);
        action.setXSDSchema(this.xsdSchema);
        return action.createAndAddNewChildElement();
    }

    private String getNormalizedLocation(String location) {
        try {
            URL url = new URL(location);
            URL resolvedURL = Platform.resolve((URL)url);
            location = resolvedURL.getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return location;
    }

    private List getXSDImports() {
        ArrayList<XSDSchemaContent> imports = new ArrayList<XSDSchemaContent>();
        Iterator contents = this.xsdSchema.getContents().iterator();
        while (contents.hasNext()) {
            XSDSchemaContent content = (XSDSchemaContent)contents.next();
            if (!(content instanceof XSDImport)) continue;
            imports.add(content);
        }
        return imports;
    }

    private List getXSDIncludes() {
        ArrayList<XSDSchemaContent> includes = new ArrayList<XSDSchemaContent>();
        Iterator contents = this.xsdSchema.getContents().iterator();
        while (contents.hasNext()) {
            XSDSchemaContent content = (XSDSchemaContent)contents.next();
            if (!(content instanceof XSDInclude)) continue;
            includes.add(content);
        }
        return includes;
    }

    private List getXSDRedefines() {
        ArrayList<XSDSchemaContent> includes = new ArrayList<XSDSchemaContent>();
        Iterator contents = this.xsdSchema.getContents().iterator();
        while (contents.hasNext()) {
            XSDSchemaContent content = (XSDSchemaContent)contents.next();
            if (!(content instanceof XSDRedefine)) continue;
            includes.add(content);
        }
        return includes;
    }
}

