/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.handles.MoveHandleLocator;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.IFeedbackHandler;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.DragAndDropCommand;
import org.eclipse.wst.xsd.ui.internal.graph.figures.BogusLayout;
import org.eclipse.wst.xsd.ui.internal.graph.figures.ContainerFigure;

public class SelectionHandlesEditPolicyImpl
extends SelectionHandlesEditPolicy {
    protected IFigure feedback;
    protected Rectangle originalLocation;
    protected DragAndDropCommand dragAndDropCommand;
    Polyline polyLine;
    RectangleFigure ghostShape;

    protected List createSelectionHandles() {
        ArrayList<MoveHandle> list = new ArrayList<MoveHandle>();
        EditPart editPart = this.getHost();
        if (editPart instanceof GraphicalEditPart) {
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
            IFigure figure = graphicalEditPart instanceof BaseEditPart ? ((BaseEditPart)graphicalEditPart).getSelectionFigure() : graphicalEditPart.getFigure();
            Cursor cursorFigure = figure.getCursor();
            MoveHandleLocator loc = new MoveHandleLocator(figure);
            MoveHandle moveHandle = new MoveHandle(graphicalEditPart, (Locator)loc);
            moveHandle.setCursor(cursorFigure);
            list.add(moveHandle);
        }
        return list;
    }

    public boolean understandsRequest(Request request) {
        boolean result = false;
        result = "move".equals(request.getType()) ? false : super.understandsRequest(request);
        return result;
    }

    public Command getCommand(Request request) {
        return null;
    }

    public void setDragAndDropCommand(DragAndDropCommand dragAndDropCommand) {
        this.dragAndDropCommand = dragAndDropCommand;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move children");
        req.setEditParts(this.getHost());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        return this.getHost().getParent().getCommand((Request)req);
    }

    public void showSourceFeedback(Request request) {
        if ("move".equals(request.getType()) || "add children".equals(request.getType())) {
            this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        PointList pointList;
        int size;
        IFigure p = this.getDragSourceFeedbackFigure();
        Rectangle r = this.originalLocation.getTranslated(request.getMoveDelta());
        Dimension resize = request.getSizeDelta();
        r.width += resize.width;
        r.height += resize.height;
        ((GraphicalEditPart)this.getHost()).getFigure().translateToAbsolute((Translatable)r);
        p.translateToRelative((Translatable)r);
        Rectangle pBounds = r.getCopy();
        if (this.dragAndDropCommand != null && this.dragAndDropCommand.canExecute() && (size = request.getEditParts().size()) > 0 && request.getEditParts().get(size - 1) == this.getHost() && (pointList = this.dragAndDropCommand.getConnectionPoints(r)) != null && pointList.size() > 0) {
            this.polyLine.setPoints(pointList);
            Point firstPoint = pointList.getFirstPoint();
            if (firstPoint != null) {
                pBounds = pBounds.getUnion(new Rectangle(firstPoint.x, firstPoint.y, 1, 1));
            }
        }
        p.setBounds(pBounds);
        this.ghostShape.setBounds(r);
        p.validate();
    }

    protected IFigure getDragSourceFeedbackFigure() {
        EditPart editPart = this.getHost();
        if (this.feedback == null && editPart instanceof BaseEditPart) {
            BaseEditPart baseEditPart = (BaseEditPart)editPart;
            this.originalLocation = new Rectangle(baseEditPart.getSelectionFigure().getBounds());
            this.feedback = this.createDragSourceFeedbackFigure(baseEditPart.getSelectionFigure());
        }
        return this.feedback;
    }

    protected IFigure createDragSourceFeedbackFigure(IFigure draggedFigure) {
        ContainerFigure panel = new ContainerFigure();
        panel.setLayoutManager((LayoutManager)new BogusLayout());
        this.ghostShape = new RectangleFigure();
        FigureUtilities.makeGhostShape((Shape)this.ghostShape);
        this.ghostShape.setLineStyle(4);
        this.ghostShape.setForegroundColor(ColorConstants.white);
        Rectangle r = draggedFigure.getBounds();
        panel.setOpaque(false);
        panel.add((IFigure)this.ghostShape);
        this.polyLine = new Polyline();
        this.polyLine.setLineWidth(3);
        panel.add((IFigure)this.polyLine);
        panel.setBounds(r);
        this.ghostShape.setBounds(r);
        this.addFeedback((IFigure)panel);
        return panel;
    }

    public void deactivate() {
        if (this.feedback != null) {
            this.removeFeedback(this.feedback);
            this.feedback = null;
        }
        this.hideFocus();
        super.deactivate();
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        if (this.feedback != null) {
            this.removeFeedback(this.feedback);
        }
        this.feedback = null;
        this.originalLocation = null;
    }

    public void eraseSourceFeedback(Request request) {
        if ("move".equals(request.getType()) || "add children".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    protected void hideSelection() {
        EditPart editPart = this.getHost();
        if (editPart instanceof IFeedbackHandler) {
            ((IFeedbackHandler)editPart).removeFeedback();
        }
    }

    protected void showSelection() {
        EditPart editPart = this.getHost();
        if (editPart instanceof IFeedbackHandler) {
            ((IFeedbackHandler)editPart).addFeedback();
        }
    }
}

