/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.BasePropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.FixedOrDefaultTextPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.properties.XSDComboBoxPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.GlobalElementRenamer;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementPropertySource
extends BasePropertySource
implements IPropertySource {
    private static final String PROPERTY_NAME = "org.eclipse.wst.xsd.ui.internal.name";
    private String[] blockComboValues = new String[]{"", "#all", "extension", "restriction", "substitution"};
    private String[] finalComboValues = new String[]{"", "#all", "extension", "restriction"};
    private String[] substitutionGroupComboValues = new String[]{""};
    private String[] formComboValues = new String[]{"", XSDEditorPlugin.getXSDString("_UI_COMBO_UNQUALIFIED"), XSDEditorPlugin.getXSDString("_UI_COMBO_QUALIFIED")};

    public ElementPropertySource() {
    }

    public ElementPropertySource(XSDSchema xsdSchema) {
        super(xsdSchema);
    }

    public ElementPropertySource(Viewer viewer, XSDSchema xsdSchema) {
        super(viewer, xsdSchema);
    }

    public void setInput(Element element) {
        this.element = element;
        TypesHelper helper = new TypesHelper(this.xsdSchema);
        List globals = helper.getGlobalElements();
        int size = globals.size() + 1;
        this.substitutionGroupComboValues = new String[size];
        this.substitutionGroupComboValues[0] = "";
        if (globals != null) {
            int k = 0;
            while (k < globals.size()) {
                this.substitutionGroupComboValues[k + 1] = (String)globals.get(k);
                ++k;
            }
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Node parentNode = this.element.getParentNode();
        boolean isGlobalElement = XSDDOMHelper.inputEquals(parentNode, "schema", false);
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
        if (isGlobalElement) {
            XSDComboBoxPropertyDescriptor abstractDescriptor = new XSDComboBoxPropertyDescriptor("abstract", "abstract", this.trueFalseComboValues);
            list.add(abstractDescriptor);
        }
        if (!isGlobalElement) {
            TextPropertyDescriptor minOccursDescriptor = new TextPropertyDescriptor((Object)"minOccurs", "minOccurs");
            list.add((PropertyDescriptor)minOccursDescriptor);
            TextPropertyDescriptor maxOccursDescriptor = new TextPropertyDescriptor((Object)"maxOccurs", "maxOccurs");
            list.add((PropertyDescriptor)maxOccursDescriptor);
        }
        XSDComboBoxPropertyDescriptor nillableDescriptor = new XSDComboBoxPropertyDescriptor("nillable", "nillable", this.trueFalseComboValues);
        list.add(nillableDescriptor);
        XSDComboBoxPropertyDescriptor blockDescriptor = new XSDComboBoxPropertyDescriptor("block", "block", this.blockComboValues);
        list.add(blockDescriptor);
        if (isGlobalElement) {
            XSDComboBoxPropertyDescriptor finalDescriptor = new XSDComboBoxPropertyDescriptor("final", "final", this.finalComboValues);
            list.add(finalDescriptor);
            XSDComboBoxPropertyDescriptor substitutionGroupDescriptor = new XSDComboBoxPropertyDescriptor("substitutionGroup", "substitutionGroup", this.substitutionGroupComboValues);
            list.add(substitutionGroupDescriptor);
        }
        if (!isGlobalElement) {
            XSDComboBoxPropertyDescriptor formDescriptor = new XSDComboBoxPropertyDescriptor("form", "form", this.formComboValues);
            list.add(formDescriptor);
        }
        Attr fixedAttr = this.element.getAttributeNode("fixed");
        Attr defaultAttr = this.element.getAttributeNode("default");
        String str = fixedAttr != null ? "fixed" : (defaultAttr != null ? "default" : "fixed/default");
        FixedOrDefaultTextPropertyDescriptor fixedOrDefaultDescriptor = new FixedOrDefaultTextPropertyDescriptor(str, str, this.element);
        list.add(fixedOrDefaultDescriptor);
        IPropertyDescriptor[] result = new IPropertyDescriptor[list.size()];
        list.toArray(result);
        return result;
    }

    public Object getPropertyValue(Object id) {
        String result = null;
        if (id instanceof String) {
            String attributeName = (String)id;
            result = this.element.getAttribute(attributeName);
            if (result == null) {
                result = "";
            }
            if (attributeName.equals("type")) {
                boolean isAnonymous = this.checkForAnonymousType(this.element);
                if (isAnonymous) {
                    return "**anonymous**";
                }
                if (result.equals("")) {
                    result = XSDEditorPlugin.getXSDString("_UI_NO_TYPE");
                }
                return result;
            }
            if (attributeName.equals("maxOccurs") || attributeName.equals("minOccurs") || attributeName.equals("substitutionGroup") || attributeName.equals("form") || attributeName.equals("abstract") || attributeName.equals("nillable") || attributeName.equals("block") || attributeName.equals("final") || attributeName.equals("fixed") || attributeName.equals("default") || attributeName.equals("name")) {
                return result;
            }
        }
        return "";
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (value == null) {
            value = "";
        }
        if (value instanceof String) {
            String newValue = (String)value;
            String attributeName = (String)id;
            if (attributeName.equals("maxOccurs")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_MAXOCCURS_CHANGE"), this.element);
            } else if (attributeName.equals("minOccurs")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_MINOCCURS_CHANGE"), this.element);
            } else if (attributeName.equals("substitutionGroup")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ELEMENT_SUBSTITUTIONGROUP_CHANGE"), this.element);
            } else if (attributeName.equals("form")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ELEMENT_FORM_CHANGE"), this.element);
            } else if (attributeName.equals("abstract")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ELEMENT_ABSTRACT_CHANGE"), this.element);
            } else if (attributeName.equals("nillable")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ELEMENT_NILLABLE_CHANGE"), this.element);
            } else if (attributeName.equals("block")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ELEMENT_BLOCK_CHANGE"), this.element);
            } else if (attributeName.equals("final")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ELEMENT_FINAL_CHANGE"), this.element);
            } else if (attributeName.equals("fixed") || attributeName.equals("default")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ELEMENT_VALUE_CHANGE"), this.element);
            } else if (attributeName.equals("name")) {
                if (this.validateName(newValue)) {
                    XSDConcreteComponent comp;
                    this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ELEMENT_NAME_CHANGE"), this.element);
                    if (this.xsdSchema != null && (comp = this.xsdSchema.getCorrespondingComponent((Node)this.element)) != null && comp instanceof XSDElementDeclaration && comp.getContainer().equals(this.xsdSchema)) {
                        GlobalElementRenamer renamer = new GlobalElementRenamer((XSDNamedComponent)comp, newValue);
                        renamer.visitSchema(this.xsdSchema);
                    }
                }
            } else {
                attributeName.equals("type");
            }
            if (newValue.length() > 0) {
                this.element.setAttribute((String)id, (String)value);
            } else if (!attributeName.equals("name")) {
                this.element.removeAttribute((String)id);
            }
            this.endRecording(this.element);
        }
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                if (ElementPropertySource.this.viewer != null) {
                    ElementPropertySource.this.viewer.refresh();
                }
            }
        };
        Display.getCurrent().asyncExec(delayedUpdate);
    }

    boolean checkForAnonymousType(Element element) {
        boolean isAnonymous = false;
        Node aNode = this.getDomHelper().getChildNode(element, "simpleType");
        if (aNode != null) {
            return true;
        }
        aNode = this.getDomHelper().getChildNode(element, "complexType");
        if (aNode != null) {
            isAnonymous = true;
        }
        return isAnonymous;
    }
}

